/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Calendar;
import java.util.TimeZone;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ZonelessDate;
import org.apache.calcite.util.ZonelessTime;
import org.apache.calcite.util.ZonelessTimestamp;

abstract class SqlAbstractDateTimeLiteral
extends SqlLiteral {
    protected final boolean hasTimeZone;
    protected final String formatString;
    protected final int precision;

    protected SqlAbstractDateTimeLiteral(Calendar d, boolean tz, SqlTypeName typeName, int precision, String formatString, SqlParserPos pos) {
        super(d, typeName, pos);
        this.hasTimeZone = tz;
        this.precision = precision;
        this.formatString = formatString;
    }

    public int getPrec() {
        return this.precision;
    }

    @Override
    public String toValue() {
        return Long.toString(this.getCal().getTimeInMillis());
    }

    public Calendar getCal() {
        return (Calendar)this.value;
    }

    public TimeZone getTimeZone() {
        assert (this.hasTimeZone) : "Attempt to get timezone on Literal date: " + this.getCal() + ", which has no timezone";
        return this.getCal().getTimeZone();
    }

    @Override
    public abstract String toString();

    public abstract String toFormattedString();

    @Override
    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(this.getTypeName(), this.getPrec());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toString());
    }

    protected ZonelessDate getDate() {
        ZonelessDate zd = new ZonelessDate();
        zd.setZonelessTime(this.getCal().getTimeInMillis());
        return zd;
    }

    protected ZonelessTime getTime() {
        ZonelessTime zt = new ZonelessTime();
        zt.setZonelessTime(this.getCal().getTimeInMillis());
        return zt;
    }

    protected ZonelessTimestamp getTimestamp() {
        ZonelessTimestamp zt = new ZonelessTimestamp();
        zt.setZonelessTime(this.getCal().getTimeInMillis());
        return zt;
    }
}

