/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidatorException;

public class RexCallBinding
extends SqlOperatorBinding {
    private final List<RexNode> operands;

    public RexCallBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator, List<? extends RexNode> operands) {
        super(typeFactory, sqlOperator);
        this.operands = ImmutableList.copyOf(operands);
    }

    @Override
    public String getStringLiteralOperand(int ordinal) {
        return RexLiteral.stringValue(this.operands.get(ordinal));
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        return RexLiteral.intValue(this.operands.get(ordinal));
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return RexUtil.isNullLiteral(this.operands.get(ordinal), allowCast);
    }

    @Override
    public int getOperandCount() {
        return this.operands.size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        return this.operands.get(ordinal).getType();
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return SqlUtil.newContextException(SqlParserPos.ZERO, e);
    }
}

