/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0001\u0003\u0001>\u0011\u0001bQ1tK^CWM\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u0018;A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\u000fD_6\u0004H.\u001a=UsB,W*\u001a:hS:<W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005aq\u0012BA\u0010\u001a\u0005\u001d\u0001&o\u001c3vGRD\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\tEJ\fgn\u00195fgV\t1\u0005E\u0002%Y=r!!\n\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0005!r\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tY\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u00055r#aA*fc*\u00111&\u0007\t\u00051A\u0002\u0002#\u0003\u000223\t1A+\u001e9mKJB\u0001b\r\u0001\u0003\u0012\u0003\u0006IaI\u0001\nEJ\fgn\u00195fg\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\nK2\u001cXMV1mk\u0016,\u0012a\u000e\t\u00041a\u0002\u0012BA\u001d\u001a\u0005\u0019y\u0005\u000f^5p]\"A1\b\u0001B\tB\u0003%q'\u0001\u0006fYN,g+\u00197vK\u0002BQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDcA A\u0003B\u0011\u0011\u0003\u0001\u0005\u0006Cq\u0002\ra\t\u0005\bkq\u0002\n\u00111\u00018\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003!\u0019\u0007.\u001b7ee\u0016tW#A#\u0011\u0007\u0011b\u0003\u0003\u0003\u0005H\u0001!\u0015\r\u0011\"\u0011I\u0003QIg\u000e];u)f\u0004Xm\u001d$pe6+'oZ5oOV\t\u0011\nE\u0002%Y)\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0004\u0002\u000bQL\b/Z:\n\u0005=c%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u0011E\u0003\u0001\u0012!Q!\n%\u000bQ#\u001b8qkR$\u0016\u0010]3t\r>\u0014X*\u001a:hS:<\u0007\u0005\u000b\u0002Q'B\u0011\u0001\u0004V\u0005\u0003+f\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000b]\u0003A\u0011\t-\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u0017\t\u00031iK!aW\r\u0003\u000f\t{w\u000e\\3b]\")Q\f\u0001C!=\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\t\u0005A\u0011M\\1msNL7/\u0003\u0002eC\nyA+\u001f9f\u0007\",7m\u001b*fgVdG\u000fC\u0003g\u0001\u0011\u0005s-\u0001\u0003fm\u0006dGC\u00015l!\tA\u0012.\u0003\u0002k3\t\u0019\u0011I\\=\t\u000f1,\u0007\u0013!a\u0001[\u0006)\u0011N\u001c9viB\u0011an\\\u0007\u0002\t%\u0011\u0001\u000f\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003s\u0001\u0011\u00053/\u0001\u0005u_N#(/\u001b8h)\u0005!\bCA;y\u001d\tAb/\u0003\u0002x3\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9\u0018\u0004C\u0003\b\u0001\u0011\u0005C0F\u0001u\u0011\u0015q\b\u0001\"\u0011\u0000\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0002\u00055\u0011q\u0003\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0002\u0002\u000f\r|G-Z4f]&!\u00111BA\u0003\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\b{\u0002\u0007\u0011\u0011C\u0001\u0004GRD\b\u0003BA\u0002\u0003'IA!!\u0006\u0002\u0006\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\r{\u0002\u0007\u0011\u0011A\u0001\u0003KZD\u0011\"!\b\u0001\u0003\u0003%\t!a\b\u0002\t\r|\u0007/\u001f\u000b\u0006\u007f\u0005\u0005\u00121\u0005\u0005\tC\u0005m\u0001\u0013!a\u0001G!AQ'a\u0007\u0011\u0002\u0003\u0007q\u0007C\u0005\u0002(\u0001\t\n\u0011\"\u0001\u0002*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0016U\r\u0019\u0013QF\u0016\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011H\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0005M\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\t\u0001\u0012\u0002\u0013\u0005\u00111I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)EK\u00028\u0003[A\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0005\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\t1\fgn\u001a\u0006\u0003\u0003/\nAA[1wC&\u0019\u00110!\u0015\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA1!\rA\u00121M\u0005\u0004\u0003KJ\"aA%oi\"I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111N\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rA\u0017Q\u000e\u0005\u000b\u0003_\n9'!AA\u0002\u0005\u0005\u0014a\u0001=%c!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013QO\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000f\t\u0006\u0003s\ny\b[\u0007\u0003\u0003wR1!! \u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t)\tAA\u0001\n\u0003\t9)\u0001\u0005dC:,\u0015/^1m)\rI\u0016\u0011\u0012\u0005\n\u0003_\n\u0019)!AA\u0002!D\u0011\"!$\u0001\u0003\u0003%\t%a$\u0002\r\u0015\fX/\u00197t)\rI\u0016\u0011\u0013\u0005\n\u0003_\nY)!AA\u0002!Ds\u0002AAK\u00037\u000bi*!)\u0002$\u0006\u001d\u0016\u0011\u0016\t\u0004#\u0005]\u0015bAAM\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAP\u0003\u0005m3)Q*FA]CUI\u0014\u0011fqB\u0014\u0018\u0007\t+I\u000b:\u0003S\r\u001f9se\u0001Zv\u000bS#OA\u0015D\bO]\u001a!)\"+e\nI3yaJ$TL\u000b\u0011\\\u000b2\u001bV\tI3yaJ,T\fI#O\t\u0002j\u0003e\u00165f]\u0002\u0002W\r\u001f9sc\u0001\u0004S\b\t;sk\u0016d\u0003E]3ukJt7\u000f\t1fqB\u0014(\u0007Y\u001e!K2\u001cX\rI<iK:\u0004\u0003-\u001a=qeN\u0002\u0007%\u0010\u0011ueV,G\u0006\t:fiV\u0014hn\u001d\u0011aKb\u0004(\u000f\u000e1<A\u0015d7/\u001a\u0011sKR,(O\\:!A\u0016D\bO]\u001ba]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003K\u000b\u0011\u0011 \u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO]\u001a![\u0001\"\b.\u001a\u0011ce\u0006t7\r\u001b\u0011d_:$\u0017\u000e^5p]\u0002*\u0007\u0010\u001d:fgNLwN\\:!g\"|W\u000f\u001c3!C2d\u0007EY3!E>|G.Z1oAQL\b/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO\u001d\u001a-A\u0015D\bO\u001d\u001b-A\u0015D\bO]\u001b![\u0001\"\b.\u001a\u0011ce\u0006t7\r\u001b\u0011wC2,X\rI3yaJ,7o]5p]N\u0004\u0013M\u001c3!K2\u001cX\r\t<bYV,\u0007%\u001a=qe\u0016\u001c8/[8oAMDw.\u001e7eA\u0005dG\u000e\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e]1nK\u0002\"\u0018\u0010]3!_J\u00043m\\3sG&\u0014G.\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111V\u0001\u0002~*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033)Q*FA]CUI\u0014\u00112Ay\u0002\u0003\u0007\t+I\u000b:\u0003\u0013\u0007I,I\u000b:\u0003#\u0007\t !a\u0001\"\u0006*\u0012(!e9\u0002\u0004%\u0012'T\u000b\u0002\ndF\r\u0011F\u001d\u0012[$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!\u0007\u0006\u001bV\tI,I\u000b:\u0003\u0013\u0007\t\u001f!a\u0001\"\u0006*\u0012(!c\u0001:\u0006*\u0012(!e\u0001r\u0004\u0005\r\u0011U\u0011\u0016s\u0005E\r\u00181A\u0015c5+\u0012\u00112]I\u0002SI\u0014#<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001b\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011=AA\u0002C\u000bS#OAIr\u0003\u0007I#O\tnR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002saBAX\u0005!\u0005\u0011\u0011W\u0001\t\u0007\u0006\u001cXm\u00165f]B\u0019\u0011#a-\u0007\r\u0005\u0011\u0001\u0012AA['\u0015\t\u0019,a.\u0018!\rA\u0012\u0011X\u0005\u0004\u0003wK\"AB!osJ+g\rC\u0004>\u0003g#\t!a0\u0015\u0005\u0005E\u0006\u0002CAb\u0003g#\t!!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b}\n9-!3\t\r\u0005\n\t\r1\u0001$\u0011\u0019)\u0014\u0011\u0019a\u0001!!A\u0011QZAZ\t\u0003\ty-\u0001\tde\u0016\fG/\u001a$s_6\u0004\u0016M]:feR\u0019q(!5\t\r\u0005\nY\r1\u0001F\u0011)\t\u0019-a-\u0002\u0002\u0013\u0005\u0015Q\u001b\u000b\u0006\u007f\u0005]\u0017\u0011\u001c\u0005\u0007C\u0005M\u0007\u0019A\u0012\t\u0011U\n\u0019\u000e%AA\u0002]B!\"!8\u00024\u0006\u0005I\u0011QAp\u0003\u001d)h.\u00199qYf$B!!9\u0002fB!\u0001\u0004OAr!\u0011A\u0002gI\u001c\t\u0013\u0005\u001d\u00181\\A\u0001\u0002\u0004y\u0014a\u0001=%a!Q\u00111^AZ#\u0003%\t!a\u0011\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIIB!\"a<\u00024F\u0005I\u0011AA\"\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!Q\u00111_AZ\u0003\u0003%I!!>\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u0004B!a\u0014\u0002z&!\u00111`A)\u0005\u0019y%M[3di\u0002")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
Serializable {
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private transient Seq<DataType> inputTypesForMerging;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    private Seq inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((TraversableLike)this.branches().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(Tuple2<Expression, Expression> x$6) {
                        return ((Expression)x$6._2()).dataType();
                    }
                }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(Expression x$7) {
                        return x$7.dataType();
                    }
                })), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = true;
            }
            return this.inputTypesForMerging;
        }
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression$class.dataTypeCheck(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression$class.dataType(this);
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)this.branches().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Expression> apply(Tuple2<Expression, Expression> b) {
                Expression expression = (Expression)b._1();
                Expression expression2 = (Expression)b._2();
                return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return this.bitmap$trans$0 ? this.inputTypesForMerging : this.inputTypesForMerging$lzycompute();
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Expression, Expression> x$8) {
                return ((Expression)x$8._2()).nullable();
            }
        }) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$9) {
                return x$9.nullable();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Expression, Expression> x$10) {
                    DataType dataType2 = ((Expression)x$10._1()).dataType();
                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                    return !(dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null);
                }
            })) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Expression, Expression> x$11) {
                        DataType dataType2 = ((Expression)x$11._1()).dataType();
                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                        return dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null;
                    }
                });
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHEN expressions in CaseWhen should all be boolean type, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the ", "th when expression's type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1)), ((Tuple2)this.branches().apply(index))._1()}))).toString());
            }
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("THEN and ELSE expressions should all be same type or coercible to a common type");
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((TraversableOnce)this.branches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Expression, Expression> x0$1) {
                Tuple2<Expression, Expression> tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression c = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" WHEN ", " THEN ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$12) {
                return new StringBuilder().append((Object)" ELSE ").append((Object)x$12).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringBuilder().append((Object)"CASE").append((Object)cases).append((Object)elseCase).append((Object)" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((TraversableOnce)this.branches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Expression, Expression> x0$2) {
                Tuple2<Expression, Expression> tuple2 = x0$2;
                if (tuple2 != null) {
                    Expression c = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" WHEN ", " THEN ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.sql(), v.sql()}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$13) {
                return new StringBuilder().append((Object)" ELSE ").append((Object)x$13.sql()).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringBuilder().append((Object)"CASE").append((Object)cases).append((Object)elseCase).append((Object)" END").toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1)new Serializable(this, ctx, ev, HAS_NONNULL, HAS_NULL, resultState){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$1;
            private final ExprCode ev$1;
            private final int HAS_NONNULL$1;
            private final int HAS_NULL$1;
            private final String resultState$1;

            public final String apply(Tuple2<Expression, Expression> x0$3) {
                Tuple2<Expression, Expression> tuple2 = x0$3;
                if (tuple2 != null) {
                    Expression condExpr = (Expression)tuple2._1();
                    Expression valueExpr = (Expression)tuple2._2();
                    ExprCode cond = condExpr.genCode(this.ctx$1);
                    ExprCode res = valueExpr.genCode(this.ctx$1);
                    String string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |if (!", " && ", ") {\n         |  ", "\n         |  ", " = (byte)(", " ? ", " : ", ");\n         |  ", " = ", ";\n         |  continue;\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cond.code(), cond.isNull(), cond.value(), res.code(), this.resultState$1, res.isNull(), BoxesRunTime.boxToInteger((int)this.HAS_NULL$1), BoxesRunTime.boxToInteger((int)this.HAS_NONNULL$1), this.ev$1.value(), res.value()})))).stripMargin();
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$1 = ctx$1;
                this.ev$1 = ev$1;
                this.HAS_NONNULL$1 = HAS_NONNULL$1;
                this.HAS_NULL$1 = HAS_NULL$1;
                this.resultState$1 = resultState$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option elseCode = this.elseValue().map((Function1)new Serializable(this, ctx, ev, HAS_NONNULL, HAS_NULL, resultState){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$1;
            private final ExprCode ev$1;
            private final int HAS_NONNULL$1;
            private final int HAS_NULL$1;
            private final String resultState$1;

            public final String apply(Expression elseExpr) {
                ExprCode res = elseExpr.genCode(this.ctx$1);
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", " = (byte)(", " ? ", " : ", ");\n         |", " = ", ";\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.code(), this.resultState$1, res.isNull(), BoxesRunTime.boxToInteger((int)this.HAS_NULL$1), BoxesRunTime.boxToInteger((int)this.HAS_NONNULL$1), this.ev$1.value(), res.value()})))).stripMargin();
            }
            {
                this.ctx$1 = ctx$1;
                this.ev$1 = ev$1;
                this.HAS_NONNULL$1 = HAS_NONNULL$1;
                this.HAS_NULL$1 = HAS_NULL$1;
                this.resultState$1 = resultState$1;
            }
        });
        Seq x$15 = allConditions = (Seq)cases.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(elseCode), Seq$.MODULE$.canBuildFrom());
        String x$16 = "caseWhen";
        String x$17 = "byte";
        Serializable x$18 = new Serializable(this, NOT_MATCHED, resultState){
            public static final long serialVersionUID = 0L;
            private final int NOT_MATCHED$1;
            private final String resultState$1;

            public final String apply(String func) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " ", " = ", ";\n           |do {\n           |  ", "\n           |} while (false);\n           |return ", ";\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", this.resultState$1, BoxesRunTime.boxToInteger((int)this.NOT_MATCHED$1), func, this.resultState$1})))).stripMargin();
            }
            {
                this.NOT_MATCHED$1 = NOT_MATCHED$1;
                this.resultState$1 = resultState$1;
            }
        };
        Serializable x$19 = new Serializable(this, NOT_MATCHED, resultState){
            public static final long serialVersionUID = 0L;
            public final int NOT_MATCHED$1;
            public final String resultState$1;

            public final String apply(Seq<String> x$14) {
                return ((TraversableOnce)x$14.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final String apply(String funcCall) {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " = ", ";\n           |if (", " != ", ") {\n           |  continue;\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.resultState$1, funcCall, this.$outer.resultState$1, BoxesRunTime.boxToInteger((int)this.$outer.NOT_MATCHED$1)})))).stripMargin();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString();
            }
            {
                this.NOT_MATCHED$1 = NOT_MATCHED$1;
                this.resultState$1 = resultState$1;
            }
        };
        Seq<Tuple2<String, String>> x$20 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$15, x$16, x$20, x$17, (Function1<String, String>)x$18, (Function1<Seq<String>, String>)x$19);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                option = this.elseValue();
                break;
            }
            case 0: {
                option = this.branches();
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression$class.$init$(this);
    }
}

