/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.storage.ql.io.sarg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;

public class ExpressionTree {
    private final Operator operator;
    private final List<ExpressionTree> children;
    private int leaf;
    private final SearchArgument.TruthValue constant;

    ExpressionTree() {
        this.operator = null;
        this.children = null;
        this.leaf = 0;
        this.constant = null;
    }

    ExpressionTree(Operator op, ExpressionTree ... kids) {
        this.operator = op;
        this.children = new ArrayList<ExpressionTree>();
        this.leaf = -1;
        this.constant = null;
        Collections.addAll(this.children, kids);
    }

    ExpressionTree(int leaf) {
        this.operator = Operator.LEAF;
        this.children = null;
        this.leaf = leaf;
        this.constant = null;
    }

    ExpressionTree(SearchArgument.TruthValue constant) {
        this.operator = Operator.CONSTANT;
        this.children = null;
        this.leaf = -1;
        this.constant = constant;
    }

    ExpressionTree(ExpressionTree other) {
        this.operator = other.operator;
        if (other.children == null) {
            this.children = null;
        } else {
            this.children = new ArrayList<ExpressionTree>();
            for (ExpressionTree child : other.children) {
                this.children.add(new ExpressionTree(child));
            }
        }
        this.leaf = other.leaf;
        this.constant = other.constant;
    }

    public SearchArgument.TruthValue evaluate(SearchArgument.TruthValue[] leaves) {
        SearchArgument.TruthValue result = null;
        switch (this.operator) {
            case OR: {
                for (ExpressionTree child : this.children) {
                    result = child.evaluate(leaves).or(result);
                }
                return result;
            }
            case AND: {
                for (ExpressionTree child : this.children) {
                    result = child.evaluate(leaves).and(result);
                }
                return result;
            }
            case NOT: {
                return this.children.get(0).evaluate(leaves).not();
            }
            case LEAF: {
                return leaves[this.leaf];
            }
            case CONSTANT: {
                return this.constant;
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)this.operator));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        switch (this.operator) {
            case OR: {
                buffer.append("(or");
                for (ExpressionTree child : this.children) {
                    buffer.append(' ');
                    buffer.append(child.toString());
                }
                buffer.append(')');
                break;
            }
            case AND: {
                buffer.append("(and");
                for (ExpressionTree child : this.children) {
                    buffer.append(' ');
                    buffer.append(child.toString());
                }
                buffer.append(')');
                break;
            }
            case NOT: {
                buffer.append("(not ");
                buffer.append(this.children.get(0));
                buffer.append(')');
                break;
            }
            case LEAF: {
                buffer.append("leaf-");
                buffer.append(this.leaf);
                break;
            }
            case CONSTANT: {
                buffer.append((Object)this.constant);
            }
        }
        return buffer.toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<ExpressionTree> getChildren() {
        return this.children;
    }

    public SearchArgument.TruthValue getConstant() {
        return this.constant;
    }

    public int getLeaf() {
        return this.leaf;
    }

    public void setLeaf(int leaf) {
        this.leaf = leaf;
    }

    public static enum Operator {
        OR,
        AND,
        NOT,
        LEAF,
        CONSTANT;

    }
}

