/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.ml.image.RecursiveFlag$;
import org.apache.spark.ml.image.SamplePathFilter$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@Experimental
public final class ImageSchema$ {
    public static final ImageSchema$ MODULE$;
    private final String undefinedImageType;
    private final scala.collection.immutable.Map<String, Object> ocvTypes;
    private final Map<String, Object> javaOcvTypes;
    private final StructType columnSchema;
    private final String[] imageFields;
    private final StructType imageSchema;

    static {
        new ImageSchema$();
    }

    public String undefinedImageType() {
        return this.undefinedImageType;
    }

    public scala.collection.immutable.Map<String, Object> ocvTypes() {
        return this.ocvTypes;
    }

    public Map<String, Object> javaOcvTypes() {
        return this.javaOcvTypes;
    }

    public StructType columnSchema() {
        return this.columnSchema;
    }

    public String[] imageFields() {
        return this.imageFields;
    }

    public StructType imageSchema() {
        return this.imageSchema;
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public int getHeight(Row row) {
        return row.getInt(1);
    }

    public int getWidth(Row row) {
        return row.getInt(2);
    }

    public int getNChannels(Row row) {
        return row.getInt(3);
    }

    public int getMode(Row row) {
        return row.getInt(4);
    }

    public byte[] getData(Row row) {
        return (byte[])row.getAs(5);
    }

    public Row invalidImageRow(String origin) {
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), this.ocvTypes().apply((Object)this.undefinedImageType()), Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Byte())}))}));
    }

    public Option<Row> decode(String origin, byte[] bytes) {
        Tuple2.mcII.sp sp2;
        block7: {
            None$ none$;
            block6: {
                Tuple2.mcII.sp sp3;
                BufferedImage img;
                block5: {
                    img = ImageIO.read(new ByteArrayInputStream(bytes));
                    if (img != null) break block5;
                    none$ = None$.MODULE$;
                    break block6;
                }
                boolean isGray = img.getColorModel().getColorSpace().getType() == 6;
                boolean hasAlpha = img.getColorModel().hasAlpha();
                int height = img.getHeight();
                int width = img.getWidth();
                Tuple2.mcII.sp sp4 = isGray ? new Tuple2.mcII.sp(1, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC1"))) : (sp2 = hasAlpha ? new Tuple2.mcII.sp(4, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC4"))) : new Tuple2.mcII.sp(3, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC3"))));
                if (sp2 == null) break block7;
                int nChannels = sp2._1$mcI$sp();
                int mode = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp5 = sp3 = new Tuple2.mcII.sp(nChannels, mode);
                int nChannels2 = sp5._1$mcI$sp();
                int mode2 = sp5._2$mcI$sp();
                int imageSize = height * width * nChannels2;
                Predef$.MODULE$.assert((double)imageSize < 1.0E9, (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "image is too large";
                    }
                });
                byte[] decoded = (byte[])Array$.MODULE$.ofDim(imageSize, ClassTag$.MODULE$.Byte());
                if (isGray) {
                    IntRef offset = IntRef.create((int)0);
                    WritableRaster raster = img.getRaster();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)new Serializable(width, decoded, offset, raster){
                        public static final long serialVersionUID = 0L;
                        private final int width$1;
                        public final byte[] decoded$1;
                        public final IntRef offset$1;
                        public final WritableRaster raster$1;

                        public final void apply(int h) {
                            this.apply$mcVI$sp(h);
                        }

                        public void apply$mcVI$sp(int h) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.width$1).foreach$mVc$sp((Function1)new Serializable(this, h){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.decode.1 $outer;
                                private final int h$1;

                                public final void apply(int w2) {
                                    this.apply$mcVI$sp(w2);
                                }

                                public void apply$mcVI$sp(int w2) {
                                    this.$outer.decoded$1[this.$outer.offset$1.elem] = (byte)this.$outer.raster$1.getSample(w2, this.h$1, 0);
                                    ++this.$outer.offset$1.elem;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.h$1 = h$1;
                                }
                            });
                        }
                        {
                            this.width$1 = width$1;
                            this.decoded$1 = decoded$1;
                            this.offset$1 = offset$1;
                            this.raster$1 = raster$1;
                        }
                    });
                } else {
                    IntRef offset = IntRef.create((int)0);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)new Serializable(img, hasAlpha, width, nChannels2, decoded, offset){
                        public static final long serialVersionUID = 0L;
                        public final BufferedImage img$1;
                        public final boolean hasAlpha$1;
                        private final int width$1;
                        public final int nChannels$1;
                        public final byte[] decoded$1;
                        public final IntRef offset$2;

                        public final void apply(int h) {
                            this.apply$mcVI$sp(h);
                        }

                        public void apply$mcVI$sp(int h) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.width$1).foreach$mVc$sp((Function1)new Serializable(this, h){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.decode.2 $outer;
                                private final int h$2;

                                public final void apply(int w2) {
                                    this.apply$mcVI$sp(w2);
                                }

                                public void apply$mcVI$sp(int w2) {
                                    Color color = new Color(this.$outer.img$1.getRGB(w2, this.h$2), this.$outer.hasAlpha$1);
                                    this.$outer.decoded$1[this.$outer.offset$2.elem] = (byte)color.getBlue();
                                    this.$outer.decoded$1[this.$outer.offset$2.elem + 1] = (byte)color.getGreen();
                                    this.$outer.decoded$1[this.$outer.offset$2.elem + 2] = (byte)color.getRed();
                                    if (this.$outer.hasAlpha$1) {
                                        this.$outer.decoded$1[this.$outer.offset$2.elem + 3] = (byte)color.getAlpha();
                                    }
                                    this.$outer.offset$2.elem += this.$outer.nChannels$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.h$2 = h$2;
                                }
                            });
                        }
                        {
                            this.img$1 = img$1;
                            this.hasAlpha$1 = hasAlpha$1;
                            this.width$1 = width$1;
                            this.nChannels$1 = nChannels$1;
                            this.decoded$1 = decoded$1;
                            this.offset$2 = offset$2;
                        }
                    });
                }
                none$ = new Some((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels2), BoxesRunTime.boxToInteger((int)mode2), decoded}))})));
            }
            return none$;
        }
        throw new MatchError((Object)sp2);
    }

    public Dataset<Row> readImages(String path) {
        return this.readImages(path, null, false, -1, false, 1.0, 0L);
    }

    public Dataset<Row> readImages(String path, SparkSession sparkSession, boolean recursive, int numPartitions, boolean dropImageFailures, double sampleRatio, long seed) {
        Predef$.MODULE$.require(sampleRatio <= 1.0 && sampleRatio >= 0.0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "sampleRatio should be between 0 and 1";
            }
        });
        SparkSession session = sparkSession == null ? SparkSession$.MODULE$.builder().getOrCreate() : sparkSession;
        int partitions = numPartitions > 0 ? numPartitions : session.sparkContext().defaultParallelism();
        return (Dataset)RecursiveFlag$.MODULE$.withRecursiveFlag(recursive, session, new Serializable(path, numPartitions, dropImageFailures, sampleRatio, seed, session, partitions){
            public static final long serialVersionUID = 0L;
            public final String path$1;
            public final int numPartitions$1;
            public final boolean dropImageFailures$1;
            private final double sampleRatio$1;
            private final long seed$1;
            public final SparkSession session$1;
            public final int partitions$1;

            public final Dataset<Row> apply() {
                return (Dataset)SamplePathFilter$.MODULE$.withPathFilter(this.sampleRatio$1, this.session$1, this.seed$1, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.readImages.2 $outer;

                    public final Dataset<Row> apply() {
                        RDD rDD;
                        RDD binResult = this.$outer.session$1.sparkContext().binaryFiles(this.$outer.path$1, this.$outer.partitions$1);
                        if (this.$outer.numPartitions$1 == -1) {
                            rDD = binResult;
                        } else {
                            int x$9 = this.$outer.partitions$1;
                            Ordering x$10 = binResult.repartition$default$2(x$9);
                            rDD = binResult.repartition(x$9, x$10);
                        }
                        RDD streams = rDD;
                        Serializable convert = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<Row> apply(String origin, PortableDataStream bytes) {
                                return ImageSchema$.MODULE$.decode(origin, bytes.toArray());
                            }
                        };
                        RDD images = this.$outer.dropImageFailures$1 ? streams.flatMap((Function1)new Serializable(this, (Function2)convert){
                            public static final long serialVersionUID = 0L;
                            private final Function2 convert$1;

                            public final Iterable<Row> apply(Tuple2<String, PortableDataStream> x0$1) {
                                Tuple2<String, PortableDataStream> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String origin = (String)tuple2._1();
                                    PortableDataStream bytes = (PortableDataStream)tuple2._2();
                                    Iterable iterable = Option$.MODULE$.option2Iterable((Option)this.convert$1.apply((Object)origin, (Object)bytes));
                                    return iterable;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.convert$1 = convert$1;
                            }
                        }, ClassTag$.MODULE$.apply(Row.class)) : streams.map((Function1)new Serializable(this, (Function2)convert){
                            public static final long serialVersionUID = 0L;
                            private final Function2 convert$1;

                            public final Row apply(Tuple2<String, PortableDataStream> x0$2) {
                                Tuple2<String, PortableDataStream> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String origin = (String)tuple2._1();
                                    PortableDataStream bytes = (PortableDataStream)tuple2._2();
                                    Row row = (Row)((Option)this.convert$1.apply((Object)origin, (Object)bytes)).getOrElse((Function0)new Serializable(this, origin){
                                        public static final long serialVersionUID = 0L;
                                        private final String origin$1;

                                        public final Row apply() {
                                            return ImageSchema$.MODULE$.invalidImageRow(this.origin$1);
                                        }
                                        {
                                            this.origin$1 = origin$1;
                                        }
                                    });
                                    return row;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.convert$1 = convert$1;
                            }
                        }, ClassTag$.MODULE$.apply(Row.class));
                        return this.$outer.session$1.createDataFrame(images, ImageSchema$.MODULE$.imageSchema());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$1 = path$1;
                this.numPartitions$1 = numPartitions$1;
                this.dropImageFailures$1 = dropImageFailures$1;
                this.sampleRatio$1 = sampleRatio$1;
                this.seed$1 = seed$1;
                this.session$1 = session$1;
                this.partitions$1 = partitions$1;
            }
        });
    }

    private ImageSchema$() {
        MODULE$ = this;
        this.undefinedImageType = "Undefined";
        this.ocvTypes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.undefinedImageType()), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8U"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC3"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC4"), (Object)BoxesRunTime.boxToInteger((int)24))}));
        this.javaOcvTypes = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.ocvTypes()).asJava();
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("nChannels", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("mode", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.columnSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        this.imageFields = this.columnSchema().fieldNames();
        StructField structField7 = new StructField("image", (DataType)this.columnSchema(), true, StructField$.MODULE$.apply$default$4());
        this.imageSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7));
    }
}

