/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Collection;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q!\u0001\u0002\u0001\u00119\u0011Q#\u00128w'\u0016\u001c'/\u001a;t\r\u0016\fG/\u001e:f'R,\u0007O\u0003\u0002\u0004\t\u0005Aa-Z1ukJ,7O\u0003\u0002\u0006\r\u0005\u00191\u000eO:\u000b\u0005\u001dA\u0011A\u00023fa2|\u0017P\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!aG&vE\u0016\u0014h.\u001a;fg\u001a+\u0017\r^;sK\u000e{gNZ5h'R,\u0007\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u001c\u0001\u0001\r\u0002\u001eGA\u0019adH\u0011\u000e\u0003\u0011I!\u0001\t\u0003\u0003\u001d-+(-\u001a:oKR,7oQ8oMB\u0011!e\t\u0007\u0001\t%!\u0013$!A\u0001\u0002\u000b\u0005QEA\u0002`IE\n\"AJ\u0015\u0011\u0005A9\u0013B\u0001\u0015\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\b\u0016\n\u0005-\"!AG&vE\u0016\u0014h.\u001a;fgJ{G.Z*qK\u000eLg-[2D_:4\u0007\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011a\u0003\u0001\u0005\u000651\u0002\r!\r\u0019\u0003eQ\u00022AH\u00104!\t\u0011C\u0007B\u0005%a\u0005\u0005\t\u0011!B\u0001K!)a\u0007\u0001C!o\u0005a1m\u001c8gS\u001e,(/\u001a)pIR\u0011\u0001h\u000f\t\u0003=eJ!A\u000f\u0003\u0003\u0011M\u0003\u0018M]6Q_\u0012DQ\u0001P\u001bA\u0002a\n1\u0001]8e\u0011\u0015q\u0004\u0001\"\u0011@\u0003\u0001:W\r^!eI&$\u0018n\u001c8bYB{GmU=ti\u0016l\u0007K]8qKJ$\u0018.Z:\u0015\u0003\u0001\u0003B!\u0011#H\u000f:\u0011\u0001CQ\u0005\u0003\u0007F\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\ri\u0015\r\u001d\u0006\u0003\u0007F\u0001\"!\u0011%\n\u0005%3%AB*ue&tw\rC\u0003L\u0001\u0011\u0005C*\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\\&vE\u0016\u0014h.\u001a;fgJ+7o\\;sG\u0016\u001cH#A'\u0011\u000793\u0016L\u0004\u0002P):\u0011\u0001kU\u0007\u0002#*\u0011!kG\u0001\u0007yI|w\u000e\u001e \n\u0003II!!V\t\u0002\u000fA\f7m[1hK&\u0011q\u000b\u0017\u0002\u0004'\u0016\f(BA+\u0012!\tQV-D\u0001\\\u0015\taV,A\u0003n_\u0012,GN\u0003\u0002_?\u0006\u0019\u0011\r]5\u000b\u0005\u0001\f\u0017AC6vE\u0016\u0014h.\u001a;fg*\u0011!mY\u0001\bM\u0006\u0014'/[29\u0015\u0005!\u0017AA5p\u0013\t17LA\u0006ICNlU\r^1eCR\f\u0007")
public class EnvSecretsFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Iterable addedEnvSecrets = (Iterable)this.kubernetesConf.roleSecretEnvNamesToKeyRefs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String envName = (String)tuple2._1();
                    String keyRef = (String)tuple2._2();
                    String[] keyRefParts = keyRef.split(":");
                    Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])keyRefParts).size() == 2, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "SecretKeyRef must be in the form name:key.";
                        }
                    });
                    String name = keyRefParts[0];
                    String key = keyRefParts[1];
                    EnvVar envVar = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarFluentImpl)new EnvVarBuilder().withName(envName)).withNewValueFrom().withNewSecretKeyRef().withKey(key).withName(name)).endSecretKeyRef()).endValueFrom()).build();
                    return envVar;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Container containerWithEnvVars = ((ContainerBuilder)new ContainerBuilder(pod.container()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(addedEnvSecrets.toSeq()).asJava())).build();
        return new SparkPod(pod.pod(), containerWithEnvVars);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public EnvSecretsFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

