/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.mapping.Mappings;

public class RelMdDistribution {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.DISTRIBUTION.method, new RelMdDistribution());

    private RelMdDistribution() {
    }

    public RelDistribution distribution(RelNode rel) {
        return RelDistributions.SINGLETON;
    }

    public RelDistribution distribution(SingleRel rel) {
        return RelMetadataQuery.distribution(rel.getInput());
    }

    public RelDistribution distribution(BiRel rel) {
        return RelMetadataQuery.distribution(rel.getLeft());
    }

    public RelDistribution distribution(SetOp rel) {
        return RelMetadataQuery.distribution(rel.getInputs().get(0));
    }

    public RelDistribution distribution(TableScan scan) {
        return RelMdDistribution.table(scan.getTable());
    }

    public RelDistribution distribution(Project project) {
        return RelMdDistribution.project(project.getInput(), project.getProjects());
    }

    public RelDistribution distribution(Values values) {
        return RelMdDistribution.values(values.getRowType(), values.getTuples());
    }

    public RelDistribution distribution(Exchange exchange) {
        return RelMdDistribution.exchange(exchange.distribution);
    }

    public RelDistribution distribution(HepRelVertex rel) {
        return RelMetadataQuery.distribution(rel.getCurrentRel());
    }

    public static RelDistribution table(RelOptTable table) {
        return table.getDistribution();
    }

    public static RelDistribution sort(RelNode input) {
        return RelMetadataQuery.distribution(input);
    }

    public static RelDistribution filter(RelNode input) {
        return RelMetadataQuery.distribution(input);
    }

    public static RelDistribution limit(RelNode input) {
        return RelMetadataQuery.distribution(input);
    }

    public static RelDistribution calc(RelNode input, RexProgram program) {
        throw new AssertionError();
    }

    public static RelDistribution project(RelNode input, List<? extends RexNode> projects) {
        RelDistribution inputDistribution = RelMetadataQuery.distribution(input);
        Mappings.TargetMapping mapping = Project.getPartialMapping(input.getRowType().getFieldCount(), projects);
        return inputDistribution.apply(mapping);
    }

    public static RelDistribution values(RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        return RelDistributions.BROADCAST_DISTRIBUTED;
    }

    public static RelDistribution exchange(RelDistribution distribution) {
        return distribution;
    }
}

