/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.avatica.remote.AvaticaRemoteConnectionProperty;
import org.apache.calcite.avatica.remote.MockJsonService;
import org.apache.calcite.avatica.remote.RemoteMeta;
import org.apache.calcite.avatica.remote.RemoteService;
import org.apache.calcite.avatica.remote.Service;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:avatica:remote:";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Avatica Remote JDBC Driver", "unknown version", "Avatica", "unknown version");
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, AvaticaRemoteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        Service service;
        ConnectionConfig config = connection.config();
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            URL url;
            try {
                url = new URL(config.url());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            service = new RemoteService(url);
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return new RemoteMeta(connection, service);
    }

    static {
        new Driver().register();
    }
}

