/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.Meta;

public abstract class AvaticaPreparedStatement
extends AvaticaStatement
implements PreparedStatement,
ParameterMetaData {
    private final Meta.Signature signature;
    private final ResultSetMetaData resultSetMetaData;
    protected final Object[] slots;

    protected AvaticaPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.signature = signature;
        this.slots = new Object[signature.parameters.size()];
        this.resultSetMetaData = connection.factory.newResultSetMetaData(this, signature);
    }

    @Override
    protected List<Object> getParameterValues() {
        return Arrays.asList(this.slots);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.getConnection().executeQueryInternal(this, this.signature, null);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.getConnection().executeQueryInternal(this, this.signature, null);
        return this.updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getParameter(parameterIndex).setNull(this.slots, parameterIndex - 1, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getParameter(parameterIndex).setBoolean(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getParameter(parameterIndex).setByte(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getParameter(parameterIndex).setShort(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getParameter(parameterIndex).setInt(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getParameter(parameterIndex).setLong(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getParameter(parameterIndex).setFloat(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getParameter(parameterIndex).setDouble(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getParameter(parameterIndex).setBigDecimal(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getParameter(parameterIndex).setString(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getParameter(parameterIndex).setBytes(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getParameter(parameterIndex).setDate(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getParameter(parameterIndex).setTime(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getParameter(parameterIndex).setTimestamp(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setAsciiStream(this.slots, parameterIndex - 1, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setUnicodeStream(this.slots, parameterIndex - 1, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParameter(parameterIndex).setBinaryStream(this.slots, parameterIndex - 1, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getParameter(parameterIndex).setObject(this.slots, parameterIndex - 1, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getParameter(parameterIndex).setObject(this.slots, parameterIndex - 1, x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.getConnection().executeQueryInternal(this, this.signature, null);
        return this.openResultSet != null && !this.openResultSet.isClosed();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getParameter(parameterIndex).setCharacterStream(this.slots, parameterIndex - 1, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getParameter(parameterIndex).setRef(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getParameter(parameterIndex).setBlob(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getParameter(parameterIndex).setClob(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getParameter(parameterIndex).setArray(this.slots, parameterIndex - 1, x);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.resultSetMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getParameter(parameterIndex).setDate(this.slots, parameterIndex - 1, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getParameter(parameterIndex).setTime(this.slots, parameterIndex - 1, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getParameter(parameterIndex).setTimestamp(this.slots, parameterIndex - 1, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getParameter(parameterIndex).setNull(this.slots, parameterIndex - 1, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getParameter(parameterIndex).setURL(this.slots, parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getParameter(parameterIndex).setObject(this.slots, parameterIndex - 1, x, targetSqlType, scaleOrLength);
    }

    protected AvaticaParameter getParameter(int param) throws SQLException {
        try {
            return this.signature.parameters.get(param - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.connection.helper.toSQLException(this.connection.helper.createException("parameter ordinal " + param + " out of range"));
        }
    }

    @Override
    public int getParameterCount() {
        return this.signature.parameters.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.getParameter((int)index).signed;
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        return this.getParameter((int)index).precision;
    }

    @Override
    public int getScale(int index) throws SQLException {
        return this.getParameter((int)index).scale;
    }

    @Override
    public int getParameterType(int index) throws SQLException {
        return this.getParameter((int)index).parameterType;
    }

    @Override
    public String getParameterTypeName(int index) throws SQLException {
        return this.getParameter((int)index).typeName;
    }

    @Override
    public String getParameterClassName(int index) throws SQLException {
        return this.getParameter((int)index).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        AvaticaParameter paramDef = this.getParameter(param);
        return 1;
    }
}

