/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import org.apache.spark.annotation.Private;
import org.apache.spark.util.collection.BitSet;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$;
import org.apache.spark.util.collection.OpenHashSet$Hasher$mcI$sp;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Private
public class OpenHashSet$mcI$sp
extends OpenHashSet<Object> {
    public final OpenHashSet.Hasher<Object> hasher$mcI$sp;
    public int[] _data$mcI$sp;
    private final int initialCapacity;
    private final double loadFactor;
    private final ClassTag<Object> evidence$1;

    @Override
    public OpenHashSet.Hasher<Object> hasher$mcI$sp() {
        return this.hasher$mcI$sp;
    }

    @Override
    public OpenHashSet.Hasher<Object> hasher() {
        return this.hasher$mcI$sp();
    }

    @Override
    public int[] _data$mcI$sp() {
        return this._data$mcI$sp;
    }

    public int[] _data() {
        return this._data$mcI$sp();
    }

    @Override
    public void _data$mcI$sp_$eq(int[] x$1) {
        this._data$mcI$sp = x$1;
    }

    public void _data_$eq(int[] x$1) {
        this._data$mcI$sp_$eq(x$1);
    }

    @Override
    public boolean contains(int k) {
        return this.contains$mcI$sp(k);
    }

    @Override
    public boolean contains$mcI$sp(int k) {
        return this.getPos$mcI$sp(k) != OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public void add(int k) {
        this.add$mcI$sp(k);
    }

    @Override
    public void add$mcI$sp(int k) {
        this.addWithoutResize$mcI$sp(k);
        this.rehashIfNeeded$mcI$sp(k, OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$grow(), OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$move());
    }

    @Override
    public OpenHashSet<Object> union(OpenHashSet<Object> other) {
        return this.union$mcI$sp(other);
    }

    @Override
    public OpenHashSet<Object> union$mcI$sp(OpenHashSet<Object> other) {
        Iterator<Object> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            this.add$mcI$sp(BoxesRunTime.unboxToInt((Object)iterator2.next()));
        }
        return this;
    }

    @Override
    public int addWithoutResize(int k) {
        return this.addWithoutResize$mcI$sp(k);
    }

    @Override
    public int addWithoutResize$mcI$sp(int k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcI$sp(k)) & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
        int delta = 1;
        while (this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos)) {
            if (this._data()[pos] == k) {
                return pos;
            }
            pos = pos + delta & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
            ++delta;
        }
        this._data()[pos] = k;
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset().set(pos);
        this.org$apache$spark$util$collection$OpenHashSet$$_size_$eq(this.org$apache$spark$util$collection$OpenHashSet$$_size() + 1);
        return pos | OpenHashSet$.MODULE$.NONEXISTENCE_MASK();
    }

    @Override
    public void rehashIfNeeded(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehashIfNeeded$mcI$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehashIfNeeded$mcI$sp(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        if (this.org$apache$spark$util$collection$OpenHashSet$$_size() > this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold()) {
            this.rehash$mcI$sp(k, allocateFunc, moveFunc);
        }
    }

    @Override
    public int getPos(int k) {
        return this.getPos$mcI$sp(k);
    }

    @Override
    public int getPos$mcI$sp(int k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcI$sp(k)) & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
        int delta = 1;
        while (this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos)) {
            if (k == this._data()[pos]) {
                return pos;
            }
            pos = pos + delta & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
            ++delta;
        }
        return OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public int getValue(int pos) {
        return this.getValue$mcI$sp(pos);
    }

    @Override
    public int getValue$mcI$sp(int pos) {
        return this._data()[pos];
    }

    @Override
    public int getValueSafe(int pos) {
        return this.getValueSafe$mcI$sp(pos);
    }

    @Override
    public int getValueSafe$mcI$sp(int pos) {
        Predef$.MODULE$.assert(this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos));
        return this._data()[pos];
    }

    @Override
    public void rehash(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehash$mcI$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehash$mcI$sp(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        int newCapacity = this.org$apache$spark$util$collection$OpenHashSet$$_capacity() * 2;
        Predef$.MODULE$.require(newCapacity > 0 && newCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), (Function0)new Serializable(this){
            private final /* synthetic */ OpenHashSet$mcI$sp $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't contain more than ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)(this.$outer.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)OpenHashSet$.MODULE$.MAX_CAPACITY())))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        allocateFunc.apply$mcVI$sp(newCapacity);
        BitSet newBitset = new BitSet(newCapacity);
        int[] newData = (int[])this.org$apache$spark$util$collection$OpenHashSet$$evidence$1.newArray(newCapacity);
        int newMask = newCapacity - 1;
        for (int oldPos = 0; oldPos < this.capacity(); ++oldPos) {
            if (!this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(oldPos)) continue;
            int key = this._data()[oldPos];
            int newPos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcI$sp(key)) & newMask;
            int i = 1;
            boolean keepGoing = true;
            while (keepGoing) {
                if (newBitset.get(newPos)) {
                    int delta = i++;
                    newPos = newPos + delta & newMask;
                    continue;
                }
                newData[newPos] = key;
                newBitset.set(newPos);
                moveFunc.apply$mcVII$sp(oldPos, newPos);
                keepGoing = false;
            }
        }
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset_$eq(newBitset);
        this._data_$eq(newData);
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity_$eq(newCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask_$eq(newMask);
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold_$eq((int)(this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)newCapacity));
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public OpenHashSet$mcI$sp(int initialCapacity, double loadFactor, ClassTag<Object> evidence$1) {
        OpenHashSet.Hasher hasher;
        ClassTag mt;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.evidence$1 = evidence$1;
        super(initialCapacity, loadFactor, evidence$1);
        Predef$.MODULE$.require(initialCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't make capacity bigger than ", " elements"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)OpenHashSet$.MODULE$.MAX_CAPACITY())}));
            }
        });
        Predef$.MODULE$.require(initialCapacity >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid initial capacity";
            }
        });
        Predef$.MODULE$.require(loadFactor < 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Load factor must be less than 1.0";
            }
        });
        Predef$.MODULE$.require(loadFactor > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Load factor must be greater than 0.0";
            }
        });
        ClassTag classTag = mt = package$.MODULE$.classTag(this.org$apache$spark$util$collection$OpenHashSet$$evidence$1);
        ClassTag classTag2 = ClassTag$.MODULE$.Long();
        if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
            hasher = new OpenHashSet.LongHasher();
        } else {
            ClassTag classTag3 = mt;
            ClassTag classTag4 = ClassTag$.MODULE$.Int();
            if (!(classTag3 != null ? !classTag3.equals(classTag4) : classTag4 != null)) {
                hasher = new OpenHashSet.IntHasher();
            } else {
                ClassTag classTag5 = mt;
                ClassTag classTag6 = ClassTag$.MODULE$.Double();
                if (!(classTag5 != null ? !classTag5.equals(classTag6) : classTag6 != null)) {
                    hasher = new OpenHashSet.DoubleHasher();
                } else {
                    ClassTag classTag7 = mt;
                    ClassTag classTag8 = ClassTag$.MODULE$.Float();
                    hasher = !(classTag7 != null ? !classTag7.equals(classTag8) : classTag8 != null) ? new OpenHashSet.FloatHasher() : new OpenHashSet$Hasher$mcI$sp();
                }
            }
        }
        this.hasher$mcI$sp = hasher;
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity = this.org$apache$spark$util$collection$OpenHashSet$$nextPowerOf2(initialCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask = this.org$apache$spark$util$collection$OpenHashSet$$_capacity() - 1;
        this.org$apache$spark$util$collection$OpenHashSet$$_size = 0;
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold = (int)(loadFactor * (double)this.org$apache$spark$util$collection$OpenHashSet$$_capacity());
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset = new BitSet(this.org$apache$spark$util$collection$OpenHashSet$$_capacity());
        this._data_$eq(evidence$1.newArray(this.org$apache$spark$util$collection$OpenHashSet$$_capacity()));
    }

    public OpenHashSet$mcI$sp(int initialCapacity, ClassTag<Object> evidence$2) {
        this(initialCapacity, 0.7, evidence$2);
    }

    public OpenHashSet$mcI$sp(ClassTag<Object> evidence$3) {
        this(64, evidence$3);
    }
}

