/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PartiallyOrderedSet<E>
extends AbstractSet<E> {
    private final Map<E, Node<E>> map;
    private final Ordering<E> ordering;
    private final Node<E> topNode;
    private final Node<E> bottomNode;
    private static final boolean DEBUG = Math.random() >= 0.0;

    public PartiallyOrderedSet(Ordering<E> ordering) {
        this(ordering, new HashMap());
    }

    public PartiallyOrderedSet(Ordering<E> ordering, Collection<E> collection) {
        this(ordering, new HashMap(collection.size() * 3 / 2));
        this.addAll(collection);
    }

    private PartiallyOrderedSet(Ordering<E> ordering, Map<E, Node<E>> map) {
        this.ordering = ordering;
        this.map = map;
        this.topNode = new TopBottomNode(true);
        this.bottomNode = new TopBottomNode(false);
        this.topNode.childList.add(this.bottomNode);
        this.bottomNode.parentList.add(this.topNode);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> iterator = this.map.keySet().iterator();
        return new Iterator<E>(){
            E previous;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                this.previous = iterator.next();
                return this.previous;
            }

            @Override
            public void remove() {
                if (!PartiallyOrderedSet.this.remove(this.previous)) {
                    throw new IllegalStateException();
                }
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        int i;
        Node<E> node = this.map.remove(o);
        if (node == null) {
            return false;
        }
        for (i = 0; i < node.parentList.size(); ++i) {
            Node parent = node.parentList.get(i);
            for (Node child : node.childList) {
                if (parent.e == null && child.e == null) {
                    parent.childList.remove(node);
                    continue;
                }
                this.replace(parent.childList, node, child);
            }
        }
        for (i = 0; i < node.childList.size(); ++i) {
            Node child = node.childList.get(i);
            for (Node parent : node.parentList) {
                if (child.e == null && parent.e == null) {
                    child.parentList.remove(node);
                    continue;
                }
                this.replace(child.parentList, node, parent);
            }
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        assert (e != null);
        assert (!DEBUG || this.isValid(true));
        Node<E> node = this.map.get(e);
        if (node != null) {
            return false;
        }
        Set<Node<E>> parents = this.findParents(e);
        Set<Node<E>> children = this.findChildren(e);
        node = new Node<E>(e);
        for (Node<E> parent : parents) {
            node.parentList.add(parent);
            int n = 0;
            for (int i = 0; i < parent.childList.size(); ++i) {
                Node child = parent.childList.get(i);
                if (child.e != null && !this.ordering.lessThan(child.e, e)) continue;
                if (parent.childList.contains(node)) {
                    parent.childList.remove(i);
                    --i;
                } else {
                    parent.childList.set(i, node);
                }
                this.replace(child.parentList, parent, node);
                if (!node.childList.contains(child)) {
                    node.childList.add(child);
                }
                ++n;
            }
            if (n != 0) continue;
            parent.childList.add(node);
        }
        HashSet childSet = new HashSet(node.childList);
        for (Node<E> child : children) {
            if (this.isDescendantOfAny(child, childSet)) continue;
            node.childList.add(child);
            if (child.parentList.contains(node)) continue;
            child.parentList.add(node);
        }
        this.map.put(node.e, node);
        assert (!DEBUG || this.isValid(true));
        return true;
    }

    private boolean isDescendantOfAny(Node<E> node, Set<Node<E>> nodeSet) {
        ArrayDeque deque = new ArrayDeque();
        HashSet seen = new HashSet();
        deque.add(node);
        while (!deque.isEmpty()) {
            Node node1 = (Node)deque.pop();
            if (nodeSet.contains(node1)) {
                return true;
            }
            for (Node parent : node1.parentList) {
                if (!seen.add(parent)) continue;
                deque.add(parent);
            }
        }
        return false;
    }

    private Set<Node<E>> findChildren(E e) {
        ArrayDeque<Node<Node<E>>> descendants = new ArrayDeque<Node<Node<E>>>();
        descendants.add(this.bottomNode);
        return this.findParentsChildren(e, descendants, false);
    }

    private Set<Node<E>> findParents(E e) {
        ArrayDeque<Node<Node<E>>> ancestors = new ArrayDeque<Node<Node<E>>>();
        ancestors.add(this.topNode);
        return this.findParentsChildren(e, ancestors, true);
    }

    private Set<Node<E>> findParentsChildren(E e, ArrayDeque<Node<E>> ancestors, boolean up) {
        HashSet<Node<Node<E>>> parents = new HashSet<Node<Node<E>>>();
        while (!ancestors.isEmpty()) {
            Node<E> ancestor = ancestors.pop();
            assert (ancestor.e == null || (!up ? !this.ordering.lessThan(e, ancestor.e) : !this.ordering.lessThan(ancestor.e, e)));
            assert (ancestor.e != e);
            int found = 0;
            for (Node child : up ? ancestor.childList : ancestor.parentList) {
                if (child.e == null) continue;
                if (up ? this.ordering.lessThan(e, child.e) : this.ordering.lessThan(child.e, e)) {
                    ancestors.add(child);
                    ++found;
                    continue;
                }
                if (!(up ? !this.ordering.lessThan(child.e, e) : !this.ordering.lessThan(e, child.e))) continue;
                ancestors.add(child);
            }
            if (found != 0 || ancestor.e != null && !(up ? this.ordering.lessThan(e, ancestor.e) : this.ordering.lessThan(ancestor.e, e))) continue;
            parents.add(ancestor);
        }
        return parents;
    }

    private <T> void replace(List<T> list, T remove, T add) {
        if (list.contains(add)) {
            list.remove(remove);
        } else {
            int index = list.indexOf(remove);
            if (index >= 0) {
                list.set(index, add);
            } else {
                list.add(add);
            }
        }
    }

    public boolean isValid(boolean fail) {
        for (Node<E> node : this.map.values()) {
            if (node == this.topNode != node.parentList.isEmpty()) {
                assert (!fail) : "only top node should have no parents " + node + ", parents " + node.parentList;
                return false;
            }
            if (node == this.bottomNode != node.childList.isEmpty()) {
                assert (!fail) : "only bottom node should have no children " + node + ", children " + node.childList;
                return false;
            }
            for (int i = 0; i < node.childList.size(); ++i) {
                Node child = node.childList.get(i);
                if (!child.parentList.contains(node)) {
                    assert (!fail) : "child " + child + " of " + node + " does not know its parent";
                    return false;
                }
                if (child.e != null && !this.ordering.lessThan(child.e, node.e)) {
                    assert (!fail) : "child " + child.e + " not less than parent " + node.e;
                    return false;
                }
                for (int i2 = 0; i2 < node.childList.size(); ++i2) {
                    Node child2 = node.childList.get(i2);
                    if (child == child2 && i != i2) {
                        assert (!fail) : "duplicate child " + child + " of parent " + node;
                        return false;
                    }
                    if (child.e == null || child2.e == null || child == child2 || !this.ordering.lessThan(child.e, child2.e)) continue;
                    assert (!fail) : "relation between children " + child.e + " and " + child2.e + " of node " + node.e;
                    return false;
                }
            }
            for (Node parent : node.parentList) {
                if (parent.childList.contains(node)) continue;
                assert (!fail);
                return false;
            }
        }
        HashMap<Node, Integer> distanceToRoot = new HashMap<Node, Integer>();
        this.distanceRecurse(distanceToRoot, this.topNode, 0);
        for (Node<E> node : this.map.values()) {
            if (distanceToRoot.containsKey(node)) continue;
            assert (!fail) : "node " + node + " is not reachable";
            return false;
        }
        HashMap nodeAncestors = new HashMap();
        HashMap nodeDescendants = new HashMap();
        for (Node<E> node : this.map.values()) {
            nodeAncestors.put(node, new HashSet(this.getAncestors(node.e)));
            nodeDescendants.put(node, new HashSet(this.getDescendants(node.e)));
        }
        for (Node<E> node1 : this.map.values()) {
            for (Node<E> node2 : this.map.values()) {
                boolean lt12 = this.ordering.lessThan(node1.e, node2.e);
                boolean lt21 = this.ordering.lessThan(node2.e, node1.e);
                if (node1 == node2 && (!lt12 || !lt21)) assert (!fail) : "self should be less than self: " + node1;
                if (lt12 && lt21 && node1 != node2) {
                    assert (!fail) : "node " + node1.e + " and node " + node2.e + " are less than each other but are not the same" + " value";
                    return false;
                }
                if (lt12 && !lt21) {
                    if (!((Set)nodeAncestors.get(node1)).contains(node2.e)) {
                        assert (!fail) : node1.e + " is less than " + node2.e + " but " + node2.e + " is not in the ancestor set of " + node1.e;
                        return false;
                    }
                    if (!((Set)nodeDescendants.get(node2)).contains(node1.e)) {
                        assert (!fail) : node1.e + " is less than " + node2.e + " but " + node1.e + " is not in the descendant set of " + node2.e;
                        return false;
                    }
                }
                if (!lt21 || lt12) continue;
                if (!((Set)nodeAncestors.get(node2)).contains(node1.e)) {
                    assert (!fail) : node2.e + " is less than " + node1.e + " but " + node1.e + " is not in the ancestor set of " + node2.e;
                    return false;
                }
                if (((Set)nodeDescendants.get(node1)).contains(node2.e)) continue;
                assert (!fail) : node2.e + " is less than " + node1.e + " but " + node2.e + " is not in the descendant set of " + node1.e;
                return false;
            }
        }
        return true;
    }

    private void distanceRecurse(Map<Node, Integer> distanceToRoot, Node<E> node, int distance) {
        Integer best = distanceToRoot.get(node);
        if (best == null || distance < best) {
            distanceToRoot.put(node, distance);
        }
        if (best != null) {
            return;
        }
        for (Node child : node.childList) {
            this.distanceRecurse(distanceToRoot, child, distance + 1);
        }
    }

    public void out(StringBuilder buf) {
        buf.append("PartiallyOrderedSet size: ");
        buf.append(this.size());
        buf.append(" elements: {\n");
        HashSet seen = new HashSet();
        ArrayDeque unseen = new ArrayDeque();
        unseen.addAll(this.getNonChildren());
        while (!unseen.isEmpty()) {
            Object e = unseen.pop();
            buf.append("  ");
            buf.append(e);
            buf.append(" parents: ");
            List parents = this.getParents(e);
            buf.append(parents);
            buf.append(" children: ");
            List children = this.getChildren(e);
            buf.append(children);
            buf.append("\n");
            for (Object child : children) {
                if (!seen.add(child)) continue;
                unseen.add(child);
            }
        }
        buf.append("}");
    }

    public List<E> getChildren(E e) {
        Node<E> node = this.map.get(e);
        if (node == null) {
            return null;
        }
        if (node.childList.get((int)0).e == null) {
            return Collections.emptyList();
        }
        return new StripList(node.childList);
    }

    public List<E> getParents(E e) {
        Node<E> node = this.map.get(e);
        if (node == null) {
            return null;
        }
        if (node.parentList.get((int)0).e == null) {
            return Collections.emptyList();
        }
        return new StripList(node.parentList);
    }

    public List<E> getNonChildren() {
        if (this.topNode.childList.size() == 1 && this.topNode.childList.get((int)0).e == null) {
            return Collections.emptyList();
        }
        return new StripList(this.topNode.childList);
    }

    public List<E> getNonParents() {
        if (this.bottomNode.parentList.size() == 1 && this.bottomNode.parentList.get((int)0).e == null) {
            return Collections.emptyList();
        }
        return new StripList(this.bottomNode.parentList);
    }

    @Override
    public void clear() {
        this.map.clear();
        assert (this.topNode.parentList.isEmpty());
        this.topNode.childList.clear();
        this.topNode.childList.add(this.bottomNode);
        assert (this.bottomNode.childList.isEmpty());
        this.bottomNode.parentList.clear();
        this.bottomNode.parentList.add(this.topNode);
    }

    public List<E> getDescendants(E e) {
        return this.descendants(e, true);
    }

    public List<E> getAncestors(E e) {
        return this.descendants(e, false);
    }

    private List<E> descendants(E e, boolean up) {
        Collection c;
        Node<E> node = this.map.get(e);
        if (node == null) {
            c = up ? this.findChildren(e) : this.findParents(e);
        } else {
            Collection collection = c = up ? node.childList : node.parentList;
        }
        if (c.size() == 1 && c.iterator().next().e == null) {
            return Collections.emptyList();
        }
        ArrayDeque deque = new ArrayDeque(c);
        HashSet seen = new HashSet();
        ArrayList list = new ArrayList();
        block0: while (!deque.isEmpty()) {
            Node node1 = deque.pop();
            list.add(node1.e);
            for (Node child : up ? node1.childList : node1.parentList) {
                if (child.e == null) continue block0;
                if (!seen.add(child)) continue;
                deque.add(child);
            }
        }
        return list;
    }

    private static class ArrayDeque<E> {
        private E[] es;
        private int first = 0;
        private int last = 0;

        public ArrayDeque() {
            this(16);
        }

        public ArrayDeque(Collection<E> nodes) {
            this(ArrayDeque.nextPowerOf2(nodes.size()));
            this.addAll(nodes);
        }

        private ArrayDeque(int capacity) {
            this.es = new Object[capacity];
        }

        private static int nextPowerOf2(int v) {
            --v;
            v |= v >> 1;
            v |= v >> 2;
            v |= v >> 4;
            v |= v >> 8;
            v |= v >> 16;
            return ++v;
        }

        private void expand() {
            E[] olds = this.es;
            this.es = new Object[this.es.length * 2];
            System.arraycopy(olds, 0, this.es, 0, olds.length);
            if (this.last <= this.first) {
                int x = this.last & olds.length - 1;
                System.arraycopy(olds, 0, this.es, olds.length, x);
                this.last += olds.length;
            }
        }

        public void add(E e) {
            this.es[this.last] = e;
            this.last = this.last + 1 & this.es.length - 1;
            if (this.last == this.first) {
                this.expand();
            }
        }

        public boolean isEmpty() {
            return this.last == this.first;
        }

        public E pop() {
            if (this.last == this.first) {
                throw new NoSuchElementException();
            }
            E e = this.es[this.first];
            this.first = this.first + 1 & this.es.length - 1;
            return e;
        }

        public void addAll(Collection<E> list) {
            for (E e : list) {
                this.add(e);
            }
        }
    }

    private static class StripList<E>
    extends AbstractList<E> {
        private final List<Node<E>> list;

        public StripList(List<Node<E>> list) {
            this.list = list;
        }

        @Override
        public E get(int index) {
            return this.list.get((int)index).e;
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    public static interface Ordering<E> {
        public boolean lessThan(E var1, E var2);
    }

    private static class TopBottomNode<E>
    extends Node<E> {
        private final String description;

        public TopBottomNode(boolean top) {
            super(null);
            this.description = top ? "top" : "bottom";
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static class Node<E> {
        final List<Node<E>> parentList = new ArrayList<Node<E>>();
        final List<Node<E>> childList = new ArrayList<Node<E>>();
        final E e;

        public Node(E e) {
            this.e = e;
        }

        public String toString() {
            return this.e.toString();
        }
    }
}

