/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberUtil {
    private static final DecimalFormat FLOAT_FORMATTER = new DecimalFormat();
    private static final DecimalFormat DOUBLE_FORMATTER;
    private static final BigInteger[] BIG_INT_TEN_POW;
    private static final BigInteger[] BIG_INT_MIN_UNSCALED;
    private static final BigInteger[] BIG_INT_MAX_UNSCALED;

    private NumberUtil() {
    }

    public static BigInteger powTen(int exponent) {
        if (exponent >= 0 && exponent < BIG_INT_TEN_POW.length) {
            return BIG_INT_TEN_POW[exponent];
        }
        return BigInteger.TEN.pow(exponent);
    }

    public static BigInteger getMaxUnscaled(int precision) {
        return BIG_INT_MAX_UNSCALED[precision];
    }

    public static BigInteger getMinUnscaled(int precision) {
        return BIG_INT_MIN_UNSCALED[precision];
    }

    public static BigDecimal rescaleBigDecimal(BigDecimal bd, int scale) {
        if (bd != null) {
            bd = bd.setScale(scale, 4);
        }
        return bd;
    }

    public static BigDecimal toBigDecimal(Number number, int scale) {
        BigDecimal bd = NumberUtil.toBigDecimal(number);
        return NumberUtil.rescaleBigDecimal(bd, scale);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Double || number instanceof Float) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.longValue());
    }

    public static boolean isValidDecimal(BigDecimal bd) {
        BigInteger usv = bd.unscaledValue();
        long usvl = usv.longValue();
        return usv.equals(BigInteger.valueOf(usvl));
    }

    public static NumberFormat getApproxFormatter(boolean isFloat) {
        return isFloat ? FLOAT_FORMATTER : DOUBLE_FORMATTER;
    }

    public static long round(double d) {
        if (d < 0.0) {
            return (long)(d - 0.5);
        }
        return (long)(d + 0.5);
    }

    public static Double add(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a + b;
    }

    public static Double divide(Double a, Double b) {
        if (a == null || b == null || b == 0.0) {
            return null;
        }
        return a / b;
    }

    public static Double multiply(Double a, Double b) {
        if (a == null || b == null) {
            return null;
        }
        return a * b;
    }

    static {
        FLOAT_FORMATTER.applyPattern("0.######E0");
        DOUBLE_FORMATTER = new DecimalFormat();
        DOUBLE_FORMATTER.applyPattern("0.###############E0");
        BIG_INT_TEN_POW = new BigInteger[20];
        BIG_INT_MIN_UNSCALED = new BigInteger[20];
        BIG_INT_MAX_UNSCALED = new BigInteger[20];
        for (int i = 0; i < BIG_INT_TEN_POW.length; ++i) {
            NumberUtil.BIG_INT_TEN_POW[i] = BigInteger.TEN.pow(i);
            if (i < 19) {
                NumberUtil.BIG_INT_MAX_UNSCALED[i] = BIG_INT_TEN_POW[i].subtract(BigInteger.ONE);
                NumberUtil.BIG_INT_MIN_UNSCALED[i] = BIG_INT_MAX_UNSCALED[i].negate();
                continue;
            }
            NumberUtil.BIG_INT_MAX_UNSCALED[i] = BigInteger.valueOf(Long.MAX_VALUE);
            NumberUtil.BIG_INT_MIN_UNSCALED[i] = BigInteger.valueOf(Long.MIN_VALUE);
        }
    }
}

