/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class PushProjector {
    private final LogicalProject origProj;
    private final RexNode origFilter;
    private final RelNode childRel;
    private final ExprCondition preserveExprCondition;
    final List<RexNode> origProjExprs;
    final List<RelDataTypeField> childFields;
    final int nChildFields;
    final BitSet projRefs;
    final ImmutableBitSet childBitmap;
    final ImmutableBitSet rightBitmap;
    final int nFields;
    final int nFieldsRight;
    private final int nSysFields;
    final List<RexNode> childPreserveExprs;
    final List<RexNode> rightPreserveExprs;
    int nSystemProject;
    int nProject;
    int nRightProject;
    final RexBuilder rexBuilder;

    public PushProjector(LogicalProject origProj, RexNode origFilter, RelNode childRel, ExprCondition preserveExprCondition) {
        this.origProj = origProj;
        this.origFilter = origFilter;
        this.childRel = childRel;
        this.preserveExprCondition = preserveExprCondition;
        this.origProjExprs = origProj == null ? ImmutableList.of() : origProj.getProjects();
        this.childFields = childRel.getRowType().getFieldList();
        this.nChildFields = this.childFields.size();
        this.projRefs = new BitSet(this.nChildFields);
        if (childRel instanceof Join) {
            Join joinRel = (Join)childRel;
            List<RelDataTypeField> leftFields = joinRel.getLeft().getRowType().getFieldList();
            List<RelDataTypeField> rightFields = joinRel.getRight().getRowType().getFieldList();
            this.nFields = leftFields.size();
            this.nFieldsRight = childRel instanceof SemiJoin ? 0 : rightFields.size();
            this.nSysFields = joinRel.getSystemFieldList().size();
            this.childBitmap = ImmutableBitSet.range(this.nSysFields, this.nFields + this.nSysFields);
            this.rightBitmap = ImmutableBitSet.range(this.nFields + this.nSysFields, this.nChildFields);
        } else {
            this.nFields = this.nChildFields;
            this.nFieldsRight = 0;
            this.childBitmap = ImmutableBitSet.range(this.nChildFields);
            this.rightBitmap = null;
            this.nSysFields = 0;
        }
        assert (this.nChildFields == this.nSysFields + this.nFields + this.nFieldsRight);
        this.childPreserveExprs = new ArrayList<RexNode>();
        this.rightPreserveExprs = new ArrayList<RexNode>();
        this.rexBuilder = childRel.getCluster().getRexBuilder();
    }

    public RelNode convertProject(RexNode defaultExpr) {
        RelNode projChild;
        this.locateAllRefs();
        if (this.origProj == null) {
            if (this.childPreserveExprs.size() == 0) {
                return null;
            }
            if (this.nChildFields > 0) {
                this.projRefs.set(0, this.nChildFields);
            }
            this.nProject = this.nChildFields;
        } else if (this.projRefs.cardinality() == this.nChildFields && this.childPreserveExprs.size() == 0) {
            return null;
        }
        if (this.projRefs.cardinality() == 0 && this.childPreserveExprs.size() == 0) {
            if (defaultExpr != null) {
                this.childPreserveExprs.add(defaultExpr);
            } else {
                if (this.nChildFields == 1) {
                    return null;
                }
                this.projRefs.set(0);
                this.nProject = 1;
            }
        }
        LogicalProject newProject = this.createProjectRefsAndExprs(this.childRel, false, false);
        int[] adjustments = this.getAdjustments();
        if (this.origFilter != null) {
            RexNode newFilter = this.convertRefsAndExprs(this.origFilter, newProject.getRowType().getFieldList(), adjustments);
            projChild = RelOptUtil.createFilter((RelNode)newProject, newFilter);
        } else {
            projChild = newProject;
        }
        return this.createNewProject(projChild, adjustments);
    }

    public boolean locateAllRefs() {
        RexUtil.apply((RexVisitor<Void>)new InputSpecialOpFinder(this.projRefs, this.childBitmap, this.rightBitmap, this.preserveExprCondition, this.childPreserveExprs, this.rightPreserveExprs), this.origProjExprs, this.origFilter);
        this.projRefs.set(this.nSysFields, this.nSysFields + this.nSysFields, true);
        this.projRefs.set(this.nSysFields + this.nFields, this.nSysFields + this.nFields + this.nSysFields, true);
        this.nSystemProject = 0;
        this.nProject = 0;
        this.nRightProject = 0;
        for (int bit : BitSets.toIter(this.projRefs)) {
            if (bit < this.nSysFields) {
                ++this.nSystemProject;
                continue;
            }
            if (bit < this.nSysFields + this.nFields) {
                ++this.nProject;
                continue;
            }
            ++this.nRightProject;
        }
        assert (this.nSystemProject + this.nProject + this.nRightProject == this.projRefs.cardinality());
        if (this.childRel instanceof Join || this.childRel instanceof SetOp) {
            if (this.nProject == 0 && this.childPreserveExprs.size() == 0) {
                this.projRefs.set(0);
                this.nProject = 1;
            }
            if (this.childRel instanceof Join && this.nRightProject == 0 && this.rightPreserveExprs.size() == 0) {
                this.projRefs.set(this.nFields);
                this.nRightProject = 1;
            }
        }
        return this.projRefs.cardinality() == this.nChildFields && this.childPreserveExprs.size() == 0 && this.rightPreserveExprs.size() == 0;
    }

    public LogicalProject createProjectRefsAndExprs(RelNode projChild, boolean adjust, boolean rightSide) {
        int offset;
        int nInputRefs;
        List<RexNode> preserveExprs;
        if (rightSide) {
            preserveExprs = this.rightPreserveExprs;
            nInputRefs = this.nRightProject;
            offset = this.nSysFields + this.nFields;
        } else {
            preserveExprs = this.childPreserveExprs;
            nInputRefs = this.nProject;
            offset = this.nSysFields;
        }
        int refIdx = offset - 1;
        ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> destFields = projChild.getRowType().getFieldList();
        for (int i = 0; i < nInputRefs; ++i) {
            refIdx = this.projRefs.nextSetBit(refIdx + 1);
            assert (refIdx >= 0);
            RelDataTypeField destField = destFields.get(refIdx - offset);
            newProjects.add(Pair.of(this.rexBuilder.makeInputRef(destField.getType(), refIdx - offset), destField.getName()));
        }
        int[] adjustments = new int[]{};
        if (preserveExprs.size() > 0 && adjust) {
            adjustments = new int[this.childFields.size()];
            for (int idx = offset; idx < this.childFields.size(); ++idx) {
                adjustments[idx] = -offset;
            }
        }
        for (RexNode projExpr : preserveExprs) {
            RexNode newExpr = adjust ? projExpr.accept(new RelOptUtil.RexInputConverter(this.rexBuilder, this.childFields, destFields, adjustments)) : projExpr;
            newProjects.add(Pair.of(newExpr, ((RexCall)projExpr).getOperator().getName()));
        }
        return (LogicalProject)RelOptUtil.createProject(projChild, Pair.left(newProjects), Pair.right(newProjects));
    }

    public int[] getAdjustments() {
        int[] adjustments = new int[this.nChildFields];
        int newIdx = 0;
        int rightOffset = this.childPreserveExprs.size();
        for (int pos : BitSets.toIter(this.projRefs)) {
            adjustments[pos] = -(pos - newIdx);
            if (pos >= this.nSysFields + this.nFields) {
                int n = pos;
                adjustments[n] = adjustments[n] + rightOffset;
            }
            ++newIdx;
        }
        return adjustments;
    }

    public RexNode convertRefsAndExprs(RexNode rex, List<RelDataTypeField> destFields, int[] adjustments) {
        return rex.accept(new RefAndExprConverter(this.rexBuilder, this.childFields, destFields, adjustments, this.childPreserveExprs, this.nProject, this.rightPreserveExprs, this.nProject + this.childPreserveExprs.size() + this.nRightProject));
    }

    public RelNode createNewProject(RelNode projChild, int[] adjustments) {
        ArrayList projects = Lists.newArrayList();
        if (this.origProj != null) {
            for (Pair<RexNode, String> p : this.origProj.getNamedProjects()) {
                projects.add(Pair.of(this.convertRefsAndExprs((RexNode)p.left, projChild.getRowType().getFieldList(), adjustments), p.right));
            }
        } else {
            for (Ord field : Ord.zip(this.childFields)) {
                projects.add(Pair.of(this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
            }
        }
        return RelOptUtil.createProject(projChild, Pair.left(projects), Pair.right(projects), true);
    }

    public static class OperatorExprCondition
    implements ExprCondition {
        private final Set<SqlOperator> operatorSet;

        public OperatorExprCondition(Set<SqlOperator> operatorSet) {
            this.operatorSet = operatorSet;
        }

        @Override
        public boolean test(RexNode expr) {
            return expr instanceof RexCall && this.operatorSet.contains(((RexCall)expr).getOperator());
        }
    }

    public static interface ExprCondition {
        public static final ExprCondition FALSE = new ExprCondition(){

            @Override
            public boolean test(RexNode expr) {
                return false;
            }
        };

        public boolean test(RexNode var1);
    }

    private class RefAndExprConverter
    extends RelOptUtil.RexInputConverter {
        private final List<RexNode> preserveLeft;
        private final int firstLeftRef;
        private final List<RexNode> preserveRight;
        private final int firstRightRef;

        public RefAndExprConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, int[] adjustments, List<RexNode> preserveLeft, int firstLeftRef, List<RexNode> preserveRight, int firstRightRef) {
            super(rexBuilder, srcFields, destFields, adjustments);
            this.preserveLeft = preserveLeft;
            this.firstLeftRef = firstLeftRef;
            this.preserveRight = preserveRight;
            this.firstRightRef = firstRightRef;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            int match = this.findExprInLists(call, this.preserveLeft, this.firstLeftRef, this.preserveRight, this.firstRightRef);
            if (match >= 0) {
                return this.rexBuilder.makeInputRef(((RelDataTypeField)this.destFields.get(match)).getType(), match);
            }
            return super.visitCall(call);
        }

        private int findExprInLists(RexNode rex, List<RexNode> rexList1, int adjust1, List<RexNode> rexList2, int adjust2) {
            int match = this.findExprInList(rex, rexList1);
            if (match >= 0) {
                return match + adjust1;
            }
            if (rexList2 != null && (match = this.findExprInList(rex, rexList2)) >= 0) {
                return match + adjust2;
            }
            return -1;
        }

        private int findExprInList(RexNode rex, List<RexNode> rexList) {
            int match = 0;
            for (RexNode rexElement : rexList) {
                if (rexElement.toString().compareTo(rex.toString()) == 0) {
                    return match;
                }
                ++match;
            }
            return -1;
        }
    }

    private class InputSpecialOpFinder
    extends RexVisitorImpl<Void> {
        private final BitSet rexRefs;
        private final ImmutableBitSet leftFields;
        private final ImmutableBitSet rightFields;
        private final ExprCondition preserveExprCondition;
        private final List<RexNode> preserveLeft;
        private final List<RexNode> preserveRight;

        public InputSpecialOpFinder(BitSet rexRefs, ImmutableBitSet leftFields, ImmutableBitSet rightFields, ExprCondition preserveExprCondition, List<RexNode> preserveLeft, List<RexNode> preserveRight) {
            super(true);
            this.rexRefs = rexRefs;
            this.leftFields = leftFields;
            this.rightFields = rightFields;
            this.preserveExprCondition = preserveExprCondition;
            this.preserveLeft = preserveLeft;
            this.preserveRight = preserveRight;
        }

        @Override
        public Void visitCall(RexCall call) {
            if (this.preserve(call)) {
                return null;
            }
            super.visitCall(call);
            return null;
        }

        private boolean preserve(RexNode call) {
            ImmutableBitSet exprArgs;
            if (this.preserveExprCondition.test(call) && (exprArgs = RelOptUtil.InputFinder.bits(call)).cardinality() > 0) {
                if (this.leftFields.contains(exprArgs)) {
                    this.addExpr(this.preserveLeft, call);
                    return true;
                }
                if (this.rightFields.contains(exprArgs)) {
                    assert (this.preserveRight != null);
                    this.addExpr(this.preserveRight, call);
                    return true;
                }
            }
            return false;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.rexRefs.set(inputRef.getIndex());
            return null;
        }

        private void addExpr(List<RexNode> exprList, RexNode newExpr) {
            String newExprString = newExpr.toString();
            for (RexNode expr : exprList) {
                if (newExprString.compareTo(expr.toString()) != 0) continue;
                return;
            }
            exprList.add(newExpr);
        }
    }
}

