/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.RelMetadataProvider;

public class ChainedRelMetadataProvider
implements RelMetadataProvider {
    private final ImmutableList<RelMetadataProvider> providers;

    protected ChainedRelMetadataProvider(ImmutableList<RelMetadataProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass, final Class<? extends Metadata> metadataClass) {
        final ArrayList functions = Lists.newArrayList();
        for (RelMetadataProvider provider : this.providers) {
            Function<RelNode, Metadata> function = provider.apply(relClass, metadataClass);
            if (function == null) continue;
            functions.add(function);
        }
        switch (functions.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Function)functions.get(0);
            }
        }
        return new Function<RelNode, Metadata>(){

            public Metadata apply(RelNode input) {
                ArrayList metadataList = Lists.newArrayList();
                for (Function function : functions) {
                    Metadata metadata = (Metadata)function.apply((Object)input);
                    if (metadata == null) continue;
                    metadataList.add(metadata);
                }
                return (Metadata)Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new ChainedInvocationHandler(metadataList));
            }
        };
    }

    public static RelMetadataProvider of(List<RelMetadataProvider> list) {
        return new ChainedRelMetadataProvider((ImmutableList<RelMetadataProvider>)ImmutableList.copyOf(list));
    }

    private static class ChainedInvocationHandler
    implements InvocationHandler {
        private final List<Metadata> metadataList;

        public ChainedInvocationHandler(List<Metadata> metadataList) {
            this.metadataList = ImmutableList.copyOf(metadataList);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Metadata metadata : this.metadataList) {
                Object o = method.invoke((Object)metadata, args);
                if (o == null) continue;
                return o;
            }
            return null;
        }
    }
}

