/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.interpreter.AggregateNode;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.FilterNode;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.JoinNode;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.NoneToBindableConverterRule;
import org.apache.calcite.interpreter.ProjectNode;
import org.apache.calcite.interpreter.SortNode;
import org.apache.calcite.interpreter.UnionNode;
import org.apache.calcite.interpreter.ValuesNode;
import org.apache.calcite.interpreter.WindowNode;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;

public class Bindables {
    public static final RelOptRule BINDABLE_TABLE_SCAN_RULE = new BindableTableScanRule();
    public static final RelOptRule BINDABLE_FILTER_RULE = new BindableFilterRule();
    public static final RelOptRule BINDABLE_PROJECT_RULE = new BindableProjectRule();
    public static final RelOptRule BINDABLE_SORT_RULE = new BindableSortRule();
    public static final RelOptRule BINDABLE_JOIN_RULE = new BindableJoinRule();
    public static final RelOptRule BINDABLE_UNION_RULE = new BindableUnionRule();
    public static final RelOptRule BINDABLE_VALUES_RULE = new BindableValuesRule();
    public static final RelOptRule BINDABLE_AGGREGATE_RULE = new BindableAggregateRule();
    public static final RelOptRule BINDABLE_WINDOW_RULE = new BindableWindowRule();
    public static final ImmutableList<RelOptRule> RULES = ImmutableList.of((Object)NoneToBindableConverterRule.INSTANCE, (Object)BINDABLE_TABLE_SCAN_RULE, (Object)BINDABLE_FILTER_RULE, (Object)BINDABLE_PROJECT_RULE, (Object)BINDABLE_SORT_RULE, (Object)BINDABLE_JOIN_RULE, (Object)BINDABLE_UNION_RULE, (Object)BINDABLE_VALUES_RULE, (Object)BINDABLE_AGGREGATE_RULE, (Object)BINDABLE_WINDOW_RULE);

    private Bindables() {
    }

    private static Enumerable<Object[]> help(DataContext dataContext, BindableRel rel) {
        return new Interpreter(dataContext, rel);
    }

    private static class BindableWindowRule
    extends ConverterRule {
        private BindableWindowRule() {
            super(LogicalWindow.class, Convention.NONE, BindableConvention.INSTANCE, "BindableWindowRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalWindow winAgg = (LogicalWindow)rel;
            RelTraitSet traitSet = winAgg.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode input = winAgg.getInput();
            RelNode convertedInput = BindableWindowRule.convert(input, input.getTraitSet().replace(BindableConvention.INSTANCE));
            return new BindableWindow(rel.getCluster(), traitSet, convertedInput, winAgg.getConstants(), winAgg.getRowType(), (List<Window.Group>)winAgg.groups);
        }
    }

    public static class BindableWindow
    extends Window
    implements BindableRel {
        BindableWindow(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
            super(cluster, traitSet, input, constants, rowType, groups);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new BindableWindow(this.getCluster(), traitSet, BindableWindow.sole(inputs), this.constants, this.rowType, (List<Window.Group>)this.groups);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return super.computeSelfCost(planner).multiplyBy(2.0);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new WindowNode(implementor.interpreter, this);
        }
    }

    private static class BindableAggregateRule
    extends ConverterRule {
        private BindableAggregateRule() {
            super(LogicalAggregate.class, Convention.NONE, BindableConvention.INSTANCE, "BindableAggregateRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace(BindableConvention.INSTANCE);
            try {
                return new BindableAggregate(rel.getCluster(), traitSet, BindableAggregateRule.convert(agg.getInput(), traitSet), agg.indicator, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                RelOptPlanner.LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    public static class BindableAggregate
    extends Aggregate
    implements BindableRel {
        public BindableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, input, indicator, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof BindableConvention);
            for (AggregateCall aggCall : aggCalls) {
                if (aggCall.isDistinct()) {
                    throw new InvalidRelException("distinct aggregation not supported");
                }
                AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
                if (implementor2 != null) continue;
                throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
            }
        }

        @Override
        public BindableAggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new BindableAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new AggregateNode(implementor.interpreter, this);
        }
    }

    private static class BindableValuesRule
    extends ConverterRule {
        private BindableValuesRule() {
            super(LogicalValues.class, Convention.NONE, BindableConvention.INSTANCE, "BindableValuesRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalValues values = (LogicalValues)rel;
            return new BindableValues(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet().replace(BindableConvention.INSTANCE));
        }
    }

    public static class BindableValues
    extends Values
    implements BindableRel {
        BindableValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new BindableValues(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples, traitSet);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new ValuesNode(implementor.interpreter, this);
        }
    }

    public static class BindableUnion
    extends Union
    implements BindableRel {
        public BindableUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public BindableUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new BindableUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new UnionNode(implementor.interpreter, this);
        }
    }

    private static class BindableUnionRule
    extends ConverterRule {
        private BindableUnionRule() {
            super(LogicalUnion.class, Convention.NONE, BindableConvention.INSTANCE, "BindableUnionRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalUnion union = (LogicalUnion)rel;
            BindableConvention out = BindableConvention.INSTANCE;
            RelTraitSet traitSet = union.getTraitSet().replace(out);
            return new BindableUnion(rel.getCluster(), traitSet, BindableUnionRule.convertList(union.getInputs(), out), union.all);
        }
    }

    public static class BindableJoin
    extends Join
    implements BindableRel {
        protected BindableJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
            super(cluster, traitSet, left, right, condition, joinType, variablesStopped);
        }

        @Override
        public BindableJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            return new BindableJoin(this.getCluster(), traitSet, left, right, conditionExpr, joinType, (Set<String>)this.variablesStopped);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new JoinNode(implementor.interpreter, this);
        }
    }

    private static class BindableJoinRule
    extends ConverterRule {
        private BindableJoinRule() {
            super(LogicalJoin.class, Convention.NONE, BindableConvention.INSTANCE, "BindableJoinRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            BindableConvention out = BindableConvention.INSTANCE;
            RelTraitSet traitSet = join.getTraitSet().replace(out);
            return new BindableJoin(rel.getCluster(), traitSet, BindableJoinRule.convert(join.getLeft(), join.getLeft().getTraitSet().replace(BindableConvention.INSTANCE)), BindableJoinRule.convert(join.getRight(), join.getRight().getTraitSet().replace(BindableConvention.INSTANCE)), join.getCondition(), join.getJoinType(), join.getVariablesStopped());
        }
    }

    public static class BindableSort
    extends Sort
    implements BindableRel {
        public BindableSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, input, collation, offset, fetch);
            assert (this.getConvention() instanceof BindableConvention);
            assert (this.getConvention() == input.getConvention());
        }

        @Override
        public BindableSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new BindableSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new SortNode(implementor.interpreter, this);
        }
    }

    private static class BindableSortRule
    extends ConverterRule {
        private BindableSortRule() {
            super(Sort.class, Convention.NONE, BindableConvention.INSTANCE, "BindableSortRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode input = sort.getInput();
            return new BindableSort(rel.getCluster(), traitSet, BindableSortRule.convert(input, input.getTraitSet().replace(BindableConvention.INSTANCE)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    public static class BindableProject
    extends Project
    implements BindableRel {
        public BindableProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
            super(cluster, traitSet, input, projects, rowType);
            assert (this.getConvention() instanceof BindableConvention);
        }

        @Override
        public BindableProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
            return new BindableProject(this.getCluster(), traitSet, input, projects, rowType);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new ProjectNode(implementor.interpreter, this);
        }
    }

    private static class BindableProjectRule
    extends ConverterRule {
        private BindableProjectRule() {
            super(LogicalProject.class, RelOptUtil.PROJECT_PREDICATE, Convention.NONE, BindableConvention.INSTANCE, "BindableProjectRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new BindableProject(rel.getCluster(), rel.getTraitSet().replace(BindableConvention.INSTANCE), BindableProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(BindableConvention.INSTANCE)), project.getProjects(), project.getRowType());
        }
    }

    public static class BindableFilter
    extends Filter
    implements BindableRel {
        public BindableFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
            super(cluster, traitSet, input, condition);
            assert (this.getConvention() instanceof BindableConvention);
        }

        public static BindableFilter create(final RelNode input, RexNode condition) {
            RelOptCluster cluster = input.getCluster();
            RelTraitSet traitSet = cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

                public List<RelCollation> get() {
                    return RelMdCollation.filter(input);
                }
            });
            return new BindableFilter(cluster, traitSet, input, condition);
        }

        @Override
        public BindableFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new BindableFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new FilterNode(implementor.interpreter, this);
        }
    }

    private static class BindableFilterRule
    extends ConverterRule {
        private BindableFilterRule() {
            super(LogicalFilter.class, RelOptUtil.FILTER_PREDICATE, Convention.NONE, BindableConvention.INSTANCE, "BindableFilterRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return BindableFilter.create(BindableFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(BindableConvention.INSTANCE)), filter.getCondition());
        }
    }

    public static class BindableTableScan
    extends TableScan
    implements BindableRel {
        public final ImmutableList<RexNode> filters;
        public final ImmutableIntList projects;

        BindableTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, ImmutableList<RexNode> filters, ImmutableIntList projects) {
            super(cluster, traitSet, table);
            this.filters = (ImmutableList)Preconditions.checkNotNull(filters);
            this.projects = (ImmutableIntList)Preconditions.checkNotNull((Object)projects);
            Preconditions.checkArgument((boolean)BindableTableScan.canHandle(table));
        }

        public static BindableTableScan create(RelOptCluster cluster, RelOptTable relOptTable) {
            return BindableTableScan.create(cluster, relOptTable, (List<RexNode>)ImmutableList.of(), BindableTableScan.identity(relOptTable));
        }

        public static BindableTableScan create(RelOptCluster cluster, RelOptTable relOptTable, List<RexNode> filters, List<Integer> projects) {
            final Table table = relOptTable.unwrap(Table.class);
            RelTraitSet traitSet = cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

                public List<RelCollation> get() {
                    if (table != null) {
                        return table.getStatistic().getCollations();
                    }
                    return ImmutableList.of();
                }
            });
            return new BindableTableScan(cluster, traitSet, relOptTable, (ImmutableList<RexNode>)ImmutableList.copyOf(filters), ImmutableIntList.copyOf(projects));
        }

        @Override
        public RelDataType deriveRowType() {
            RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
            List<RelDataTypeField> fieldList = this.table.getRowType().getFieldList();
            for (int project : this.projects) {
                builder.add(fieldList.get(project));
            }
            return builder.build();
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).itemIf("filters", this.filters, !this.filters.isEmpty()).itemIf("projects", this.projects, !this.projects.equals(this.identity()));
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return super.computeSelfCost(planner).multiplyBy(0.01);
        }

        public static boolean canHandle(RelOptTable table) {
            return table.unwrap(ScannableTable.class) != null || table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
        }

        @Override
        public Enumerable<Object[]> bind(DataContext dataContext) {
            return this.table.unwrap(ScannableTable.class).scan(dataContext);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            throw new UnsupportedOperationException();
        }
    }

    private static class BindableTableScanRule
    extends RelOptRule {
        private BindableTableScanRule() {
            super(BindableTableScanRule.operand(LogicalTableScan.class, BindableTableScanRule.none()));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalTableScan scan = (LogicalTableScan)call.rel(0);
            RelOptTable table = scan.getTable();
            if (BindableTableScan.canHandle(table)) {
                call.transformTo(BindableTableScan.create(scan.getCluster(), table));
            }
        }
    }
}

