/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

@InterfaceAudience.Private
public class INodeSymlink
extends INodeWithAdditionalFields {
    private final byte[] symlink;

    INodeSymlink(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, String symlink) {
        super(id, name, permissions, mtime, atime);
        this.symlink = DFSUtil.string2Bytes(symlink);
    }

    INodeSymlink(INodeSymlink that) {
        super(that);
        this.symlink = that.symlink;
    }

    @Override
    void recordModification(int latestSnapshotId) {
        if (this.isInLatestSnapshot(latestSnapshotId)) {
            INodeDirectory parent = this.getParent();
            parent.saveChild2Snapshot(this, latestSnapshotId, new INodeSymlink(this));
        }
    }

    @Override
    public boolean isSymlink() {
        return true;
    }

    @Override
    public INodeSymlink asSymlink() {
        return this;
    }

    public String getSymlinkString() {
        return DFSUtil.bytes2String(this.symlink);
    }

    public byte[] getSymlink() {
        return this.symlink;
    }

    @Override
    public QuotaCounts cleanSubtree(BlockStoragePolicySuite bsps, int snapshotId, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        if (snapshotId == 0x7FFFFFFE && priorSnapshotId == -1) {
            this.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
        }
        return new QuotaCounts.Builder().nameSpace(1L).build();
    }

    @Override
    public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        removedINodes.add(this);
    }

    @Override
    public QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts, boolean useCache, int lastSnapshotId) {
        counts.addNameSpace(1L);
        return counts;
    }

    @Override
    public ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) {
        summary.getCounts().addContent(Content.SYMLINK, 1L);
        return summary;
    }

    @Override
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        out.println();
    }

    @Override
    public void removeAclFeature() {
        throw new UnsupportedOperationException("ACLs are not supported on symlinks");
    }

    @Override
    public void addAclFeature(AclFeature f) {
        throw new UnsupportedOperationException("ACLs are not supported on symlinks");
    }

    @Override
    final XAttrFeature getXAttrFeature(int snapshotId) {
        throw new UnsupportedOperationException("XAttrs are not supported on symlinks");
    }

    @Override
    public void removeXAttrFeature() {
        throw new UnsupportedOperationException("XAttrs are not supported on symlinks");
    }

    @Override
    public void addXAttrFeature(XAttrFeature f) {
        throw new UnsupportedOperationException("XAttrs are not supported on symlinks");
    }

    @Override
    public byte getStoragePolicyID() {
        throw new UnsupportedOperationException("Storage policy are not supported on symlinks");
    }

    @Override
    public byte getLocalStoragePolicyID() {
        throw new UnsupportedOperationException("Storage policy are not supported on symlinks");
    }
}

