/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.SparkContext;
import org.apache.spark.SpillListener;
import org.apache.spark.TestUtils;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.util.Utils$;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;
import scala.util.Try;
import scala.util.Try$;

public final class TestUtils$ {
    public static final TestUtils$ MODULE$;
    private final JavaFileObject.Kind org$apache$spark$TestUtils$$SOURCE;

    static {
        new TestUtils$();
    }

    public URL createJarWithClasses(Seq<String> classNames, String toStringValue, Seq<Tuple2<String, String>> classNamesWithBase, Seq<URL> classpathUrls) {
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        Seq files1 = (Seq)classNames.map((Function1)new Serializable(toStringValue, classpathUrls, tempDir){
            public static final long serialVersionUID = 0L;
            private final String toStringValue$1;
            private final Seq classpathUrls$1;
            private final File tempDir$1;

            public final File apply(String name2) {
                String x$8 = name2;
                File x$9 = this.tempDir$1;
                String x$10 = this.toStringValue$1;
                Seq x$11 = this.classpathUrls$1;
                String x$12 = TestUtils$.MODULE$.createCompiledClass$default$4();
                return TestUtils$.MODULE$.createCompiledClass(x$8, x$9, x$10, x$12, (Seq<URL>)x$11);
            }
            {
                this.toStringValue$1 = toStringValue$1;
                this.classpathUrls$1 = classpathUrls$1;
                this.tempDir$1 = tempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq files2 = (Seq)classNamesWithBase.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(toStringValue, classpathUrls, tempDir){
            public static final long serialVersionUID = 0L;
            private final String toStringValue$1;
            private final Seq classpathUrls$1;
            private final File tempDir$1;

            public final File apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String childName = (String)tuple2._1();
                    String baseName = (String)tuple2._2();
                    File file = TestUtils$.MODULE$.createCompiledClass(childName, this.tempDir$1, this.toStringValue$1, baseName, (Seq<URL>)this.classpathUrls$1);
                    return file;
                }
                throw new MatchError(tuple2);
            }
            {
                this.toStringValue$1 = toStringValue$1;
                this.classpathUrls$1 = classpathUrls$1;
                this.tempDir$1 = tempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        File jarFile = new File(tempDir, new StringOps(Predef$.MODULE$.augmentString("testJar-%s.jar")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())})));
        return this.createJar((Seq<File>)((Seq)files1.$plus$plus((GenTraversableOnce)files2, Seq$.MODULE$.canBuildFrom())), jarFile, this.createJar$default$3());
    }

    public URL createJarWithFiles(Map<String, String> files, File dir) {
        File tempDir = (File)Option$.MODULE$.apply((Object)dir).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            }
        });
        File jarFile = File.createTempFile("testJar", ".jar", tempDir);
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jarFile));
        files.foreach((Function1)new Serializable(jarStream){
            public static final long serialVersionUID = 0L;
            private final JarOutputStream jarStream$1;

            public final long apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    JarEntry entry = new JarEntry(k);
                    this.jarStream$1.putNextEntry(entry);
                    long l = ByteStreams.copy((InputStream)new ByteArrayInputStream(v.getBytes(StandardCharsets.UTF_8)), (OutputStream)this.jarStream$1);
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                this.jarStream$1 = jarStream$1;
            }
        });
        jarStream.close();
        return jarFile.toURI().toURL();
    }

    public URL createJar(Seq<File> files, File jarFile, Option<String> directoryPrefix) {
        FileOutputStream jarFileStream = new FileOutputStream(jarFile);
        JarOutputStream jarStream = new JarOutputStream((OutputStream)jarFileStream, new Manifest());
        files.foreach((Function1)new Serializable(directoryPrefix, jarStream){
            public static final long serialVersionUID = 0L;
            private final Option directoryPrefix$1;
            private final JarOutputStream jarStream$2;

            public final void apply(File file) {
                String prefix = (String)this.directoryPrefix$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String d) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d}));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                JarEntry jarEntry = new JarEntry(new StringBuilder().append((Object)prefix).append((Object)file.getName()).toString());
                this.jarStream$2.putNextEntry(jarEntry);
                FileInputStream in = new FileInputStream(file);
                ByteStreams.copy((InputStream)in, (OutputStream)this.jarStream$2);
                in.close();
            }
            {
                this.directoryPrefix$1 = directoryPrefix$1;
                this.jarStream$2 = jarStream$2;
            }
        });
        jarStream.close();
        jarFileStream.close();
        return jarFile.toURI().toURL();
    }

    public String createJarWithClasses$default$2() {
        return "";
    }

    public Seq<Tuple2<String, String>> createJarWithClasses$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<URL> createJarWithClasses$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<String> createJar$default$3() {
        return None$.MODULE$;
    }

    public File createJarWithFiles$default$2() {
        return null;
    }

    public JavaFileObject.Kind org$apache$spark$TestUtils$$SOURCE() {
        return this.org$apache$spark$TestUtils$$SOURCE;
    }

    public URI org$apache$spark$TestUtils$$createURI(String name2) {
        return URI.create(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string:///", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2.replace(".", "/"), this.org$apache$spark$TestUtils$$SOURCE().extension})));
    }

    public File createCompiledClass(String className, File destDir, TestUtils.JavaSourceFromString sourceFile, Seq<URL> classpathUrls) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Seq options = classpathUrls.nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-classpath", ((TraversableOnce)classpathUrls.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(URL x$2) {
                return x$2.getFile();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)})) : (Seq)Seq$.MODULE$.empty();
        compiler.getTask(null, null, null, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(options).asJava(), null, Arrays.asList((Object[])new TestUtils.JavaSourceFromString[]{sourceFile})).call();
        String fileName = new StringBuilder().append((Object)className).append((Object)".class").toString();
        File result2 = new File(fileName);
        Predef$.MODULE$.assert(result2.exists(), (Function0)new Serializable(result2){
            public static final long serialVersionUID = 0L;
            private final File result$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Compiled file not found: ").append((Object)this.result$1.getAbsolutePath()).toString();
            }
            {
                this.result$1 = result$1;
            }
        });
        File out = new File(destDir, fileName);
        Files.move((File)result2, (File)out);
        Predef$.MODULE$.assert(out.exists(), (Function0)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final File out$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Destination file not moved: ").append((Object)this.out$1.getAbsolutePath()).toString();
            }
            {
                this.out$1 = out$1;
            }
        });
        return out;
    }

    public File createCompiledClass(String className, File destDir, String toStringValue, String baseClass, Seq<URL> classpathUrls) {
        String extendsText = (String)Option$.MODULE$.apply((Object)baseClass).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" extends ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        TestUtils.JavaSourceFromString sourceFile = new TestUtils.JavaSourceFromString(className, new StringBuilder().append((Object)"public class ").append((Object)className).append((Object)extendsText).append((Object)" implements java.io.Serializable {").append((Object)"  @Override public String toString() { return \"").append((Object)toStringValue).append((Object)"\"; }}").toString());
        return this.createCompiledClass(className, destDir, sourceFile, classpathUrls);
    }

    public String createCompiledClass$default$3() {
        return "";
    }

    public String createCompiledClass$default$4() {
        return null;
    }

    public Seq<URL> createCompiledClass$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public void assertSpilled(SparkContext sc, String identifier, Function0<BoxedUnit> body2) {
        SpillListener listener = new SpillListener();
        this.withListener(sc, (SparkListener)listener, (Function1)new Serializable(body2){
            public static final long serialVersionUID = 0L;
            private final Function0 body$1;

            public final void apply(SpillListener x$3) {
                this.body$1.apply$mcV$sp();
            }
            {
                this.body$1 = body$1;
            }
        });
        Predef$.MODULE$.assert(listener.numSpilledStages() > 0, (Function0)new Serializable(identifier){
            public static final long serialVersionUID = 0L;
            private final String identifier$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected ", " to spill, but did not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifier$1}));
            }
            {
                this.identifier$1 = identifier$1;
            }
        });
    }

    public void assertNotSpilled(SparkContext sc, String identifier, Function0<BoxedUnit> body2) {
        SpillListener listener = new SpillListener();
        this.withListener(sc, (SparkListener)listener, (Function1)new Serializable(body2){
            public static final long serialVersionUID = 0L;
            private final Function0 body$2;

            public final void apply(SpillListener x$4) {
                this.body$2.apply$mcV$sp();
            }
            {
                this.body$2 = body$2;
            }
        });
        Predef$.MODULE$.assert(listener.numSpilledStages() == 0, (Function0)new Serializable(identifier){
            public static final long serialVersionUID = 0L;
            private final String identifier$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected ", " to not spill, but did"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifier$2}));
            }
            {
                this.identifier$2 = identifier$2;
            }
        });
    }

    public boolean testCommandAvailable(String command) {
        Try attempt = Try$.MODULE$.apply((Function0)new Serializable(command){
            public static final long serialVersionUID = 0L;
            private final String command$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Process$.MODULE$.apply(this.command$1).run(ProcessLogger$.MODULE$.apply((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String x$5) {
                    }
                })).exitValue();
            }
            {
                this.command$1 = command$1;
            }
        });
        return attempt.isSuccess() && BoxesRunTime.unboxToInt((Object)attempt.get()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int httpResponseCode(URL url, String method, Seq<Tuple2<String, String>> headers2) {
        int n;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        headers2.foreach((Function1)new Serializable(connection){
            public static final long serialVersionUID = 0L;
            private final HttpURLConnection connection$1;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.connection$1.setRequestProperty(k, v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.connection$1 = connection$1;
            }
        });
        if (connection instanceof HttpsURLConnection) {
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            X509TrustManager trustManager = new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }
            };
            HostnameVerifier verifier = new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            sslCtx.init(null, (TrustManager[])((Object[])new TrustManager[]{trustManager}), new SecureRandom());
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslCtx.getSocketFactory());
            ((HttpsURLConnection)connection).setHostnameVerifier(verifier);
        }
        try {
            connection.connect();
            n = connection.getResponseCode();
            connection.disconnect();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.disconnect();
            throw throwable;
        }
        return n;
    }

    public String httpResponseCode$default$2() {
        return "GET";
    }

    public Seq<Tuple2<String, String>> httpResponseCode$default$3() {
        return Nil$.MODULE$;
    }

    public <L extends SparkListener> void withListener(SparkContext sc, L listener, Function1<L, BoxedUnit> body2) {
        sc.addSparkListener(listener);
        try {
            body2.apply(listener);
            return;
        }
        finally {
            sc.listenerBus().waitUntilEmpty(TimeUnit.SECONDS.toMillis(10L));
            sc.listenerBus().removeListener(listener);
        }
    }

    public void waitUntilExecutorsUp(SparkContext sc, int numExecutors, long timeout) {
        long finishTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (System.nanoTime() < finishTime) {
            if (sc.statusTracker().getExecutorInfos().length > numExecutors) {
                return;
            }
            Thread.sleep(10L);
        }
        throw new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't find ", " executors before ", " milliseconds elapsed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numExecutors), BoxesRunTime.boxToLong((long)timeout)})));
    }

    public void configTestLog4j(String level) {
        Properties pro = new Properties();
        pro.put("log4j.rootLogger", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", console"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{level})));
        pro.put("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        pro.put("log4j.appender.console.target", "System.err");
        pro.put("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        pro.put("log4j.appender.console.layout.ConversionPattern", "%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n");
        PropertyConfigurator.configure((Properties)pro);
    }

    public File[] recursiveList(File f) {
        Predef$.MODULE$.require(f.isDirectory());
        File[] current = f.listFiles();
        return (File[])Predef$.MODULE$.refArrayOps((Object[])current).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])current).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.isDirectory();
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(File f) {
                return Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(f));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    private TestUtils$() {
        MODULE$ = this;
        this.org$apache$spark$TestUtils$$SOURCE = JavaFileObject.Kind.SOURCE;
    }
}

