/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.api.python.PythonDStream$;
import org.apache.spark.streaming.scheduler.ClearCheckpointData;
import org.apache.spark.streaming.scheduler.ClearMetadata;
import org.apache.spark.streaming.scheduler.DoCheckpoint;
import org.apache.spark.streaming.scheduler.GenerateJobs;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobGeneratorEvent;
import org.apache.spark.streaming.scheduler.JobScheduler;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobSet$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pE\u001e+g.\u001a:bi>\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!\u0011!Q\u0001\nq\tAB[8c'\u000eDW\rZ;mKJ\u001c\u0001\u0001\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\ta!j\u001c2TG\",G-\u001e7fe\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"a\t\u0013\u0011\u0005u\u0001\u0001\"\u0002\u000e!\u0001\u0004a\u0002b\u0002\u0014\u0001\u0005\u0004%IaJ\u0001\u0004gN\u001cW#\u0001\u0015\u0011\u0005%RS\"\u0001\u0003\n\u0005-\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u0019i\u0003\u0001)A\u0005Q\u0005!1o]2!\u0011\u001dy\u0003A1A\u0005\nA\nAaY8oMV\t\u0011\u0007\u0005\u00023g5\ta!\u0003\u00025\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0019\u0002\u000b\r|gN\u001a\u0011\t\u000fa\u0002!\u0019!C\u0005s\u0005)qM]1qQV\t!\b\u0005\u0002*w%\u0011A\b\u0002\u0002\r\tN#(/Z1n\u000fJ\f\u0007\u000f\u001b\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001e\u0002\r\u001d\u0014\u0018\r\u001d5!\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000bQa\u00197pG.,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u001a\tA!\u001e;jY&\u0011q\t\u0012\u0002\u0006\u00072|7m\u001b\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\"\u0002\r\rdwnY6!\u0011\u001dY\u0005A1A\u0005\n1\u000bQ\u0001^5nKJ,\u0012!\u0014\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\u000b\u0012I!!U(\u0003\u001dI+7-\u001e:sS:<G+[7fe\"11\u000b\u0001Q\u0001\n5\u000ba\u0001^5nKJ\u0004\u0003\u0002C+\u0001\u0011\u000b\u0007I\u0011\u0002,\u0002!MDw.\u001e7e\u0007\",7m\u001b9pS:$X#A,\u0011\u00059A\u0016BA-\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0017\u0001\t\u0002\u0003\u0006KaV\u0001\u0012g\"|W\u000f\u001c3DQ\u0016\u001c7\u000e]8j]R\u0004\u0003\u0002C/\u0001\u0011\u000b\u0007I\u0011\u00020\u0002!\rDWmY6q_&tGo\u0016:ji\u0016\u0014X#A0\u0011\u0005%\u0002\u0017BA1\u0005\u0005A\u0019\u0005.Z2la>Lg\u000e^,sSR,'\u000f\u0003\u0005d\u0001!\u0005\t\u0015)\u0003`\u0003E\u0019\u0007.Z2la>Lg\u000e^,sSR,'\u000f\t\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u0003%)g/\u001a8u\u0019>|\u0007/F\u0001h!\r\u0019\u0005N[\u0005\u0003S\u0012\u0013\u0011\"\u0012<f]Rdun\u001c9\u0011\u0005uY\u0017B\u00017\u0003\u0005EQuNY$f]\u0016\u0014\u0018\r^8s\u000bZ,g\u000e\u001e\u0005\b]\u0002\u0001\r\u0011\"\u0003p\u00035)g/\u001a8u\u0019>|\u0007o\u0018\u0013fcR\u0011\u0001o\u001d\t\u0003\u001dEL!A]\b\u0003\tUs\u0017\u000e\u001e\u0005\bi6\f\t\u00111\u0001h\u0003\rAH%\r\u0005\u0007m\u0002\u0001\u000b\u0015B4\u0002\u0015\u00154XM\u001c;M_>\u0004\b\u0005C\u0004y\u0001\u0001\u0007I\u0011B=\u0002%1\f7\u000f\u001e)s_\u000e,7o]3e\u0005\u0006$8\r[\u000b\u0002uB\u0011\u0011f_\u0005\u0003y\u0012\u0011A\u0001V5nK\"9a\u0010\u0001a\u0001\n\u0013y\u0018A\u00067bgR\u0004&o\\2fgN,GMQ1uG\"|F%Z9\u0015\u0007A\f\t\u0001C\u0004u{\u0006\u0005\t\u0019\u0001>\t\u000f\u0005\u0015\u0001\u0001)Q\u0005u\u0006\u0019B.Y:u!J|7-Z:tK\u0012\u0014\u0015\r^2iA!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011!B:uCJ$H#\u00019\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0005!1\u000f^8q)\r\u0001\u00181\u0003\u0005\b\u0003+\ti\u00011\u0001X\u0003M\u0001(o\\2fgN\u0014VmY3jm\u0016$G)\u0019;b\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0011c\u001c8CCR\u001c\u0007nQ8na2,G/[8o)\r\u0001\u0018Q\u0004\u0005\b\u0003?\t9\u00021\u0001{\u0003\u0011!\u0018.\\3\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u00051rN\\\"iK\u000e\\\u0007o\\5oi\u000e{W\u000e\u001d7fi&|g\u000eF\u0003q\u0003O\tI\u0003C\u0004\u0002 \u0005\u0005\u0002\u0019\u0001>\t\u000f\u0005-\u0012\u0011\u0005a\u0001/\u0006A2\r\\3be\u000eCWmY6q_&tG\u000fR1uC2\u000bG/\u001a:\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\u0005a\u0001O]8dKN\u001cXI^3oiR\u0019\u0001/a\r\t\u000f\u0005U\u0012Q\u0006a\u0001U\u0006)QM^3oi\"9\u0011\u0011\b\u0001\u0005\n\u0005-\u0011AD:uCJ$h)\u001b:tiRKW.\u001a\u0005\b\u0003{\u0001A\u0011BA\u0006\u0003\u001d\u0011Xm\u001d;beRDq!!\u0011\u0001\t\u0013\t\u0019%\u0001\u0007hK:,'/\u0019;f\u0015>\u00147\u000fF\u0002q\u0003\u000bBq!a\b\u0002@\u0001\u0007!\u0010C\u0004\u0002J\u0001!I!a\u0013\u0002\u001b\rdW-\u0019:NKR\fG-\u0019;b)\r\u0001\u0018Q\n\u0005\b\u0003?\t9\u00051\u0001{\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\n1c\u00197fCJ\u001c\u0005.Z2la>Lg\u000e\u001e#bi\u0006$2\u0001]A+\u0011\u001d\ty\"a\u0014A\u0002iDq!!\u0017\u0001\t\u0013\tY&\u0001\u0007e_\u000eCWmY6q_&tG\u000fF\u0003q\u0003;\ny\u0006C\u0004\u0002 \u0005]\u0003\u0019\u0001>\t\u000f\u0005-\u0012q\u000ba\u0001/\"9\u00111\r\u0001\u0005\n\u0005\u0015\u0014aF7be.\u0014\u0015\r^2i\rVdG.\u001f)s_\u000e,7o]3e)\r\u0001\u0018q\r\u0005\b\u0003?\t\t\u00071\u0001{\u0001")
public class JobGenerator
implements Logging {
    public final JobScheduler org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler;
    private final StreamingContext ssc;
    private final SparkConf conf;
    private final DStreamGraph org$apache$spark$streaming$scheduler$JobGenerator$$graph;
    private final Clock clock;
    private final RecurringTimer timer;
    private boolean shouldCheckpoint;
    private CheckpointWriter checkpointWriter;
    private EventLoop<JobGeneratorEvent> org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop;
    private Time lastProcessedBatch;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    private boolean shouldCheckpoint$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldCheckpoint = this.ssc().checkpointDuration() != null && this.ssc().checkpointDir() != null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.shouldCheckpoint;
        }
    }

    private CheckpointWriter checkpointWriter$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.checkpointWriter = this.shouldCheckpoint() ? new CheckpointWriter(this, this.ssc().conf(), this.ssc().checkpointDir(), this.ssc().sparkContext().hadoopConfiguration()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.checkpointWriter;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private StreamingContext ssc() {
        return this.ssc;
    }

    private SparkConf conf() {
        return this.conf;
    }

    public DStreamGraph org$apache$spark$streaming$scheduler$JobGenerator$$graph() {
        return this.org$apache$spark$streaming$scheduler$JobGenerator$$graph;
    }

    public Clock clock() {
        return this.clock;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    private boolean shouldCheckpoint() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldCheckpoint$lzycompute() : this.shouldCheckpoint;
    }

    private CheckpointWriter checkpointWriter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.checkpointWriter$lzycompute() : this.checkpointWriter;
    }

    public EventLoop<JobGeneratorEvent> org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop() {
        return this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop;
    }

    private void org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop_$eq(EventLoop<JobGeneratorEvent> x$1) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop = x$1;
    }

    private Time lastProcessedBatch() {
        return this.lastProcessedBatch;
    }

    private void lastProcessedBatch_$eq(Time x$1) {
        this.lastProcessedBatch = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop() == null) {
            this.checkpointWriter();
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop_$eq(new EventLoop<JobGeneratorEvent>(this){
                private final /* synthetic */ JobGenerator $outer;

                public void onReceive(JobGeneratorEvent event) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(event);
                }

                public void onError(Throwable e) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError("Error in job generator", e);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super("JobGenerator");
                }
            });
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().start();
            if (this.ssc().isCheckpointPresent()) {
                this.restart();
            } else {
                this.startFirstTime();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void stop(boolean processReceivedData) {
        block6: {
            if (this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop() == null) {
                return;
            }
            if (processReceivedData) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Stopping JobGenerator gracefully";
                    }
                });
                long timeWhenStopStarted = System.currentTimeMillis();
                long stopTimeoutMs = this.conf().getTimeAsMs("spark.streaming.gracefulStopTimeout", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(10L * this.ssc().graph().batchDuration().milliseconds()))})));
                int pollTime = 100;
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waiting for all received blocks to be consumed for job generation";
                    }
                });
                while (!this.hasTimedOut$1(timeWhenStopStarted, stopTimeoutMs) && this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().hasUnallocatedBlocks()) {
                    Thread.sleep(pollTime);
                }
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waited for all received blocks to be consumed for job generation";
                    }
                });
                long stopTime = this.timer().stop(false);
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Stopped generation timer";
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waiting for jobs to be processed and checkpoints to be written";
                    }
                });
                while (true) {
                    void var6_4;
                    if (this.hasTimedOut$1(timeWhenStopStarted, stopTimeoutMs) || this.haveAllBatchesBeenProcessed$1(stopTime)) {
                        this.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Waited for jobs to be processed and checkpoints to be written";
                            }
                        });
                        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().stop();
                        break block6;
                    }
                    Thread.sleep((long)var6_4);
                }
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping JobGenerator immediately";
                }
            });
            this.timer().stop(true);
            this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().stop();
        }
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().stop();
        if (this.shouldCheckpoint()) {
            this.checkpointWriter().stop();
        }
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped JobGenerator";
            }
        });
    }

    public void onBatchCompletion(Time time) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().post((Object)new ClearMetadata(time));
    }

    public void onCheckpointCompletion(Time time, boolean clearCheckpointDataLater) {
        if (clearCheckpointDataLater) {
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().post((Object)new ClearCheckpointData(time));
        }
    }

    public void org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(JobGeneratorEvent event) {
        JobGeneratorEvent jobGeneratorEvent;
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            this.logDebug((Function0<String>)new Serializable(this, event){
                                public static final long serialVersionUID = 0L;
                                private final JobGeneratorEvent event$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Got event ").append((Object)this.event$1).toString();
                                }
                                {
                                    this.event$1 = event$1;
                                }
                            });
                            jobGeneratorEvent = event;
                            if (!(jobGeneratorEvent instanceof GenerateJobs)) break block2;
                            GenerateJobs generateJobs2 = (GenerateJobs)jobGeneratorEvent;
                            Time time = generateJobs2.time();
                            this.generateJobs(time);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(jobGeneratorEvent instanceof ClearMetadata)) break block4;
                        ClearMetadata clearMetadata2 = (ClearMetadata)jobGeneratorEvent;
                        Time time = clearMetadata2.time();
                        this.clearMetadata(time);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(jobGeneratorEvent instanceof DoCheckpoint)) break block5;
                    DoCheckpoint doCheckpoint2 = (DoCheckpoint)jobGeneratorEvent;
                    Time time = doCheckpoint2.time();
                    boolean clearCheckpointDataLater = doCheckpoint2.clearCheckpointDataLater();
                    this.doCheckpoint(time, clearCheckpointDataLater);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(jobGeneratorEvent instanceof ClearCheckpointData)) break block6;
                ClearCheckpointData clearCheckpointData2 = (ClearCheckpointData)jobGeneratorEvent;
                Time time = clearCheckpointData2.time();
                this.clearCheckpointData(time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)jobGeneratorEvent);
    }

    private void startFirstTime() {
        Time startTime = new Time(this.timer().getStartTime());
        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().start(startTime.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().batchDuration()));
        this.timer().start(startTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, startTime){
            public static final long serialVersionUID = 0L;
            private final Time startTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Started JobGenerator at ").append((Object)this.startTime$1).toString();
            }
            {
                this.startTime$1 = startTime$1;
            }
        });
    }

    private void restart() {
        if (this.clock() instanceof ManualClock) {
            long lastTime = this.ssc().initialCheckpoint().checkpointTime().milliseconds();
            long jumpTime = this.ssc().sc().conf().getLong("spark.streaming.manualClock.jump", 0L);
            ((ManualClock)this.clock()).setTime(lastTime + jumpTime);
        }
        Duration batchDuration = this.ssc().graph().batchDuration();
        Time checkpointTime = this.ssc().initialCheckpoint().checkpointTime();
        Time restartTime = new Time(this.timer().getRestartTime(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().zeroTime().milliseconds()));
        Seq<Time> downTimes = checkpointTime.until(restartTime, batchDuration);
        this.logInfo((Function0<String>)new Serializable(this, downTimes){
            public static final long serialVersionUID = 0L;
            private final Seq downTimes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches during down time (").append((Object)BoxesRunTime.boxToInteger((int)this.downTimes$1.size())).append((Object)" batches): ").append((Object)this.downTimes$1.mkString(", ")).toString();
            }
            {
                this.downTimes$1 = downTimes$1;
            }
        });
        Time[] pendingTimes = (Time[])Predef$.MODULE$.refArrayOps((Object[])this.ssc().initialCheckpoint().pendingTimes()).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)new Serializable(this, pendingTimes){
            public static final long serialVersionUID = 0L;
            private final Time[] pendingTimes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches pending processing (").append((Object)BoxesRunTime.boxToInteger((int)this.pendingTimes$1.length)).append((Object)" batches): ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.pendingTimes$1).mkString(", ")).toString();
            }
            {
                this.pendingTimes$1 = pendingTimes$1;
            }
        });
        Time[] timesToReschedule = (Time[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pendingTimes).$plus$plus(downTimes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Time.class)))).filter((Function1)new Serializable(this, restartTime){
            public static final long serialVersionUID = 0L;
            private final Time restartTime$1;

            public final boolean apply(Time x$1) {
                return x$1.$less(this.restartTime$1);
            }
            {
                this.restartTime$1 = restartTime$1;
            }
        })).distinct()).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)new Serializable(this, timesToReschedule){
            public static final long serialVersionUID = 0L;
            private final Time[] timesToReschedule$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches to reschedule (").append((Object)BoxesRunTime.boxToInteger((int)this.timesToReschedule$1.length)).append((Object)" batches): ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.timesToReschedule$1).mkString(", ")).toString();
            }
            {
                this.timesToReschedule$1 = timesToReschedule$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])timesToReschedule).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobGenerator $outer;

            public final void apply(Time time) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().allocateBlocksToBatch(time);
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$graph().generateJobs(time), JobSet$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.timer().start(restartTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, restartTime){
            public static final long serialVersionUID = 0L;
            private final Time restartTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Restarted JobGenerator at ").append((Object)this.restartTime$1).toString();
            }
            {
                this.restartTime$1 = restartTime$1;
            }
        });
    }

    private void generateJobs(Time time) {
        Try try_;
        block4: {
            block3: {
                block2: {
                    this.ssc().sparkContext().setLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS(), "true");
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, time){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ JobGenerator $outer;
                        private final Time time$1;

                        public final Seq<Job> apply() {
                            this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().allocateBlocksToBatch(this.time$1);
                            return this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$graph().generateJobs(this.time$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.time$1 = time$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    Seq jobs = (Seq)success.value();
                    Map<Object, StreamInputInfo> streamIdToInputInfos = this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().getInfo(time);
                    this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, (Seq<Job>)jobs, streamIdToInputInfos));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError(new StringBuilder().append((Object)"Error generating jobs for time ").append((Object)time).toString(), e);
                PythonDStream$.MODULE$.stopStreamingContextIfPythonProcessIsDead(e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().post((Object)new DoCheckpoint(time, false));
            return;
        }
        throw new MatchError((Object)try_);
    }

    private void clearMetadata(Time time) {
        this.ssc().graph().clearMetadata(time);
        if (this.shouldCheckpoint()) {
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().post((Object)new DoCheckpoint(time, true));
        } else {
            Duration maxRememberDuration = this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().getMaxInputStreamRememberDuration();
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldBlocksAndBatches(time.$minus(maxRememberDuration));
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().cleanup(time.$minus(maxRememberDuration));
            this.markBatchFullyProcessed(time);
        }
    }

    private void clearCheckpointData(Time time) {
        this.ssc().graph().clearCheckpointData(time);
        Duration maxRememberDuration = this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().getMaxInputStreamRememberDuration();
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldBlocksAndBatches(time.$minus(maxRememberDuration));
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().cleanup(time.$minus(maxRememberDuration));
        this.markBatchFullyProcessed(time);
    }

    private void doCheckpoint(Time time, boolean clearCheckpointDataLater) {
        if (this.shouldCheckpoint() && time.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().zeroTime()).isMultipleOf(this.ssc().checkpointDuration())) {
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Checkpointing graph for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            this.ssc().graph().updateCheckpointData(time);
            this.checkpointWriter().write(new Checkpoint(this.ssc(), time), clearCheckpointDataLater);
        } else if (clearCheckpointDataLater) {
            this.markBatchFullyProcessed(time);
        }
    }

    private void markBatchFullyProcessed(Time time) {
        this.lastProcessedBatch_$eq(time);
    }

    private final Clock liftedTree1$1(String clockClass$1) {
        Throwable throwable2;
        block2: {
            Clock clock;
            try {
                clock = (Clock)Utils$.MODULE$.classForName(clockClass$1).newInstance();
            }
            catch (Throwable throwable2) {
                Clock clock2;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof ClassNotFoundException) || !clockClass$1.startsWith("org.apache.spark.streaming")) break block2;
                String newClockClass = clockClass$1.replace("org.apache.spark.streaming", "org.apache.spark");
                clock = clock2 = (Clock)Utils$.MODULE$.classForName(newClockClass).newInstance();
            }
            return clock;
        }
        throw throwable2;
    }

    private final boolean hasTimedOut$1(long timeWhenStopStarted$1, long stopTimeoutMs$1) {
        boolean timedOut;
        boolean bl = timedOut = System.currentTimeMillis() - timeWhenStopStarted$1 > stopTimeoutMs$1;
        if (timedOut) {
            this.logWarning((Function0<String>)new Serializable(this, stopTimeoutMs$1){
                public static final long serialVersionUID = 0L;
                private final long stopTimeoutMs$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Timed out while stopping the job generator (timeout = ").append((Object)BoxesRunTime.boxToLong((long)this.stopTimeoutMs$1)).append((Object)")").toString();
                }
                {
                    this.stopTimeoutMs$1 = stopTimeoutMs$1;
                }
            });
        }
        return timedOut;
    }

    private final boolean haveAllBatchesBeenProcessed$1(long stopTime$1) {
        return this.lastProcessedBatch() != null && this.lastProcessedBatch().milliseconds() == stopTime$1;
    }

    public JobGenerator(JobScheduler jobScheduler) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler = jobScheduler;
        Logging.class.$init$((Logging)this);
        this.ssc = jobScheduler.ssc();
        this.conf = this.ssc().conf();
        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph = this.ssc().graph();
        String clockClass = this.ssc().sc().conf().get("spark.streaming.clock", "org.apache.spark.util.SystemClock");
        this.clock = this.liftedTree1$1(clockClass);
        this.timer = new RecurringTimer(this.clock(), this.ssc().graph().batchDuration().milliseconds(), (Function1<Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobGenerator $outer;

            public final void apply(long longTime) {
                this.apply$mcVJ$sp(longTime);
            }

            public void apply$mcVJ$sp(long longTime) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop().post((Object)new GenerateJobs(new Time(longTime)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "JobGenerator");
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventLoop = null;
        this.lastProcessedBatch = null;
    }
}

