/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001>\u0011abU;cgR\u0014\u0018N\\4J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\bgR\u0014X\t\u001f9s+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\tgR\u0014X\t\u001f9sA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0005eK2LW.\u0012=qe\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0006eK2LW.\u0012=qe\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\nG>,h\u000e^#yaJD\u0001b\f\u0001\u0003\u0012\u0003\u0006IaI\u0001\u000bG>,h\u000e^#yaJ\u0004\u0003\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\b\u0006\u00034iU2\u0004CA\t\u0001\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015I\u0003\u00071\u0001$\u0011\u0015i\u0003\u00071\u0001$\u0011\u0015A\u0004\u0001\"\u0011:\u0003!!\u0017\r^1UsB,W#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011!\u0002;za\u0016\u001c\u0018BA =\u0005!!\u0015\r^1UsB,\u0007\"B!\u0001\t\u0003\u0012\u0015AC5oaV$H+\u001f9fgV\t1\tE\u0002E\u0019jr!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!s\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tY\u0015$A\u0004qC\u000e\\\u0017mZ3\n\u00055s%aA*fc*\u00111*\u0007\u0005\u0006!\u0002!\t%U\u0001\tG\"LG\u000e\u001a:f]V\t!\u000bE\u0002E\u0019\u000eBQ\u0001\u0016\u0001\u0005BU\u000b!\u0002\u001d:fiRLh*Y7f+\u00051\u0006CA,[\u001d\tA\u0002,\u0003\u0002Z3\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI\u0016\u0004C\u0003_\u0001\u0011\u0005s,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003aG\u0016<\u0007C\u0001\rb\u0013\t\u0011\u0017DA\u0002B]fDQ\u0001Z/A\u0002\u0001\f1a\u001d;s\u0011\u00151W\f1\u0001a\u0003\u0015!W\r\\5n\u0011\u0015AW\f1\u0001a\u0003\u0015\u0019w.\u001e8u\u0011\u0015Q\u0007\u0001\"\u0011l\u0003%!wnR3o\u0007>$W\rF\u0002me^\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0002\u0002\u000f\r|G-Z4f]&\u0011\u0011O\u001c\u0002\t\u000bb\u0004(oQ8eK\")1/\u001ba\u0001i\u0006\u00191\r\u001e=\u0011\u00055,\u0018B\u0001<o\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001_5A\u00021\f!!\u001a<\t\u000fi\u0004\u0011\u0011!C\u0001w\u0006!1m\u001c9z)\u0011\u0019D0 @\t\u000f\u0005J\b\u0013!a\u0001G!9\u0011&\u001fI\u0001\u0002\u0004\u0019\u0003bB\u0017z!\u0003\u0005\ra\t\u0005\n\u0003\u0003\u0001\u0011\u0013!C\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0006)\u001a1%a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0005\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\tiAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0007\u0001#\u0003%\t!a\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u0004\u0001\u0012\u0002\u0013\u0005\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0003mC:<'BAA\u0019\u0003\u0011Q\u0017M^1\n\u0007m\u000bY\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\b\t\u00041\u0005u\u0012bAA 3\t\u0019\u0011J\u001c;\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004A\u0006\u001d\u0003BCA%\u0003\u0003\n\t\u00111\u0001\u0002<\u0005\u0019\u0001\u0010J\u0019\t\u0013\u00055\u0003!!A\u0005B\u0005=\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0003#BA*\u00033\u0002WBAA+\u0015\r\t9&G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA.\u0003+\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003?\u0002\u0011\u0011!C\u0001\u0003C\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\nI\u0007E\u0002\u0019\u0003KJ1!a\u001a\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0013\u0002^\u0005\u0005\t\u0019\u00011\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u0005E\u0004\"CA%\u0003W\n\t\u00111\u0001aQ=\u0001\u0011QOA>\u0003{\n\t)a!\u0002\b\u0006%\u0005cA\t\u0002x%\u0019\u0011\u0011\u0010\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qP\u0001\u0004\n*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003\u0005Z3mS6d\u0003eY8v]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];cgR\u0014\u0018N\\4!MJ|W\u000e\t1tiJ\u0004\u0007EY3g_J,\u0007\u0005Y2pk:$\b\rI8dGV\u0014(/\u001a8dKN\u0004sN\u001a\u0011uQ\u0016\u0004C-\u001a7j[&$XM\u001d\u0011aI\u0016d\u0017.\u001c1/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003mY8v]R\u0004\u0007%[:!a>\u001c\u0018\u000e^5wK2\u0002SM^3ssRD\u0017N\\4!i>\u0004C\u000f[3!Y\u00164G\u000fI8gAQDW\r\t4j]\u0006d\u0007\u0005Z3mS6LG/\u001a:!Q\r|WO\u001c;j]\u001e\u0004cM]8nAQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\\3gi&\u0002\u0013n\u001d\u0011sKR,(O\\3e]\u0001Je\r\t1d_VtG\u000f\u0019\u0011jg\u0002rWmZ1uSZ,G\u0006I3wKJLH\u000f[5oO\u0002\"x\u000e\t;iK\u0002\u0012\u0018n\u001a5uA=4\u0007\u0005\u001e5fA\u0019Lg.\u00197!I\u0016d\u0017.\\5uKJT\u0001\u0005\t\u0011!A\u0001B3m\\;oi&tw\r\t4s_6\u0004C\u000f[3!e&<\u0007\u000e^\u0015!SN\u0004#/\u001a;ve:,GM\f\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI:vEN$(/\u001b8h?&tG-\u001a=!a\u0016\u0014hm\u001c:ng\u0002\n\u0007eY1tK6\u001aXM\\:ji&4X\rI7bi\u000eD'\u0002\t\u0011!A\u0001\u0002s\u000f[3oAM,\u0017M]2iS:<\u0007EZ8sA\u0001$W\r\\5nA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QQ\u0001U\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":so^</CB\f7\r[3/_J<w\u0005\f\u0011(]\u001db\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]<xOL1qC\u000eDWM\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY)A\u00032]Ur\u0003gB\u0005\u0002\u0010\n\t\t\u0011#\u0001\u0002\u0012\u0006q1+\u001e2tiJLgnZ%oI\u0016D\bcA\t\u0002\u0014\u001aA\u0011AAA\u0001\u0012\u0003\t)jE\u0003\u0002\u0014\u0006]U\u0004\u0005\u0005\u0002\u001a\u0006}5eI\u00124\u001b\t\tYJC\u0002\u0002\u001ef\tqA];oi&lW-\u0003\u0003\u0002\"\u0006m%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9\u0011'a%\u0005\u0002\u0005\u0015FCAAI\u0011)\tI+a%\u0002\u0002\u0013\u0015\u00131V\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0005\u0005\u000b\u0003_\u000b\u0019*!A\u0005\u0002\u0006E\u0016!B1qa2LHcB\u001a\u00024\u0006U\u0016q\u0017\u0005\u0007C\u00055\u0006\u0019A\u0012\t\r%\ni\u000b1\u0001$\u0011\u0019i\u0013Q\u0016a\u0001G!Q\u00111XAJ\u0003\u0003%\t)!0\u0002\u000fUt\u0017\r\u001d9msR!\u0011qXAf!\u0015A\u0012\u0011YAc\u0013\r\t\u0019-\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ra\t9mI\u0012$\u0013\r\tI-\u0007\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u00055\u0017\u0011XA\u0001\u0002\u0004\u0019\u0014a\u0001=%a!Q\u0011\u0011[AJ\u0003\u0003%I!a5\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003+\u0004B!!\u000b\u0002X&!\u0011\u0011\\A\u0016\u0005\u0019y%M[3di\u0002")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.strExpr(), this.delimExpr(), this.countExpr()}));
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String str, String delim, String count) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".subStringIndex(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str, delim, count}));
            }
        });
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.countExpr();
                break;
            }
            case 1: {
                expression = this.delimExpr();
                break;
            }
            case 0: {
                expression = this.strExpr();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes$class.$init$(this);
    }
}

