/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.SparkConf;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.ConsumerStrategies$;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategies$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DirectKafkaWordCount$ {
    public static final DirectKafkaWordCount$ MODULE$;

    static {
        new DirectKafkaWordCount$();
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |Usage: DirectKafkaWordCount <brokers> <groupId> <topics>\n        |  <brokers> is a list of one or more Kafka brokers\n        |  <groupId> is a consumer group name to consume from topics\n        |  <topics> is a list of one or more kafka topics to consume from\n        |\n        "})).s((Seq)Nil$.MODULE$))).stripMargin());
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
            Tuple3 tuple3;
            String brokers = (String)((SeqLike)option.get()).apply(0);
            String groupId = (String)((SeqLike)option.get()).apply(1);
            String topics = (String)((SeqLike)option.get()).apply(2);
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)brokers, (Object)groupId, (Object)topics);
            String brokers2 = (String)tuple32._1();
            String groupId2 = (String)tuple32._2();
            String topics2 = (String)tuple32._3();
            SparkConf sparkConf = new SparkConf().setAppName("DirectKafkaWordCount");
            StreamingContext ssc = new StreamingContext(sparkConf, Seconds$.MODULE$.apply(2L));
            Set topicsSet = Predef$.MODULE$.refArrayOps((Object[])topics2.split(",")).toSet();
            scala.collection.immutable.Map kafkaParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)brokers2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)groupId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), StringDeserializer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), StringDeserializer.class)}));
            InputDStream messages = KafkaUtils$.MODULE$.createDirectStream(ssc, LocationStrategies$.MODULE$.PreferConsistent(), ConsumerStrategies$.MODULE$.Subscribe((Iterable)topicsSet, (Map)kafkaParams));
            DStream lines = messages.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(ConsumerRecord<String, String> x$2) {
                    return (String)x$2.value();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            DStream words = lines.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(String x$3) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$3.split(" "));
                }
            }, ClassTag$.MODULE$.apply(String.class));
            DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(String x) {
                    return new Tuple2((Object)x, (Object)BoxesRunTime.boxToLong((long)1L));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(long x$4, long x$5) {
                    return this.apply$mcJJJ$sp(x$4, x$5);
                }

                public long apply$mcJJJ$sp(long x$4, long x$5) {
                    return x$4 + x$5;
                }
            });
            wordCounts.print();
            ssc.start();
            ssc.awaitTermination();
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    private DirectKafkaWordCount$() {
        MODULE$ = this;
    }
}

