/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.SparseNaiveBayes;
import org.apache.spark.examples.mllib.SparseNaiveBayes$Params$;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class SparseNaiveBayes$ {
    public static final SparseNaiveBayes$ MODULE$;

    static {
        new SparseNaiveBayes$();
    }

    public void main(String[] args) {
        SparseNaiveBayes.Params defaultParams = new SparseNaiveBayes.Params(SparseNaiveBayes$Params$.MODULE$.apply$default$1(), SparseNaiveBayes$Params$.MODULE$.apply$default$2(), SparseNaiveBayes$Params$.MODULE$.apply$default$3(), SparseNaiveBayes$Params$.MODULE$.apply$default$4());
        OptionParser<SparseNaiveBayes.Params> parser = new OptionParser<SparseNaiveBayes.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseNaiveBayes: an example naive Bayes app for LIBSVM data."}));
                this.opt("numPartitions", Read$.MODULE$.intRead()).text("min number of partitions").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SparseNaiveBayes.Params apply(int x, SparseNaiveBayes.Params c) {
                        int x$3 = x;
                        String x$4 = c.copy$default$1();
                        int x$5 = c.copy$default$3();
                        double x$6 = c.copy$default$4();
                        return c.copy(x$4, x$3, x$5, x$6);
                    }
                });
                this.opt("numFeatures", Read$.MODULE$.intRead()).text("number of features").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SparseNaiveBayes.Params apply(int x, SparseNaiveBayes.Params c) {
                        int x$7 = x;
                        String x$8 = c.copy$default$1();
                        int x$9 = c.copy$default$2();
                        double x$10 = c.copy$default$4();
                        return c.copy(x$8, x$9, x$7, x$10);
                    }
                });
                this.opt("lambda", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lambda (smoothing constant), default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.lambda())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SparseNaiveBayes.Params apply(double x, SparseNaiveBayes.Params c) {
                        double x$11 = x;
                        String x$12 = c.copy$default$1();
                        int x$13 = c.copy$default$2();
                        int x$14 = c.copy$default$3();
                        return c.copy(x$12, x$13, x$14, x$11);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input paths to labeled examples in LIBSVM format").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SparseNaiveBayes.Params apply(String x, SparseNaiveBayes.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4());
                    }
                });
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            SparseNaiveBayes.Params params = (SparseNaiveBayes.Params)some.x();
            this.run(params);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(SparseNaiveBayes.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseNaiveBayes with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        Logger.getRootLogger().setLevel(Level.WARN);
        int minPartitions = params.minPartitions() > 0 ? params.minPartitions() : sc.defaultMinPartitions();
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input(), params.numFeatures(), minPartitions);
        examples.cache();
        RDD[] splits = examples.randomSplit(new double[]{0.8, 0.2}, examples.randomSplit$default$2());
        RDD training = splits[0];
        RDD test = splits[1];
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numTraining = ", ", numTest = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
        NaiveBayesModel model = new NaiveBayes().setLambda(params.lambda()).run(training);
        RDD prediction = model.predict(test.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(LabeledPoint x$1) {
                return x$1.features();
            }
        }, ClassTag$.MODULE$.apply(Vector.class)));
        RDD predictionAndLabel = prediction.zip(test.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(LabeledPoint x$2) {
                return x$2.label();
            }
        }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
        double accuracy = (double)predictionAndLabel.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcD$sp() == x._2$mcD$sp();
            }
        }).count() / (double)numTest;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test accuracy = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)accuracy)})));
        sc.stop();
    }

    private SparseNaiveBayes$() {
        MODULE$ = this;
    }
}

