/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.OneVsRest;
import org.apache.spark.ml.classification.OneVsRestModel;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class OneVsRestExample$ {
    public static final OneVsRestExample$ MODULE$;

    static {
        new OneVsRestExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OneVsRestExample"})).s((Seq)Nil$.MODULE$)).getOrCreate();
        Dataset inputData = spark.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        Dataset[] datasetArray = inputData.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset train = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset test = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)train, (Object)test);
            Dataset train2 = (Dataset)tuple22._1();
            Dataset test2 = (Dataset)tuple22._2();
            LogisticRegression classifier = new LogisticRegression().setMaxIter(10).setTol(1.0E-6).setFitIntercept(true);
            OneVsRest ovr = new OneVsRest().setClassifier((Classifier)classifier);
            OneVsRestModel ovrModel = ovr.fit(train2);
            Dataset predictions = ovrModel.transform(test2);
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("accuracy");
            double accuracy = evaluator.evaluate(predictions);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test Error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(1.0 - accuracy))})));
            spark.stop();
            return;
        }
        throw new MatchError((Object)datasetArray);
    }

    private OneVsRestExample$() {
        MODULE$ = this;
    }
}

