/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.ml.regression.AFTSurvivalRegression;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaAFTSurvivalRegressionExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaAFTSurvivalRegressionExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{1.218, 1.0, Vectors.dense((double)1.56, (double[])new double[]{-0.605})}), RowFactory.create((Object[])new Object[]{2.949, 0.0, Vectors.dense((double)0.346, (double[])new double[]{2.158})}), RowFactory.create((Object[])new Object[]{3.627, 0.0, Vectors.dense((double)1.38, (double[])new double[]{0.231})}), RowFactory.create((Object[])new Object[]{0.273, 1.0, Vectors.dense((double)0.52, (double[])new double[]{1.151})}), RowFactory.create((Object[])new Object[]{4.199, 0.0, Vectors.dense((double)0.795, (double[])new double[]{-0.226})}));
        StructType schema = new StructType(new StructField[]{new StructField("label", DataTypes.DoubleType, false, Metadata.empty()), new StructField("censor", DataTypes.DoubleType, false, Metadata.empty()), new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset training = spark.createDataFrame(data, schema);
        double[] quantileProbabilities = new double[]{0.3, 0.6};
        AFTSurvivalRegression aft = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles");
        AFTSurvivalRegressionModel model = aft.fit(training);
        System.out.println("Coefficients: " + model.coefficients());
        System.out.println("Intercept: " + model.intercept());
        System.out.println("Scale: " + model.scale());
        model.transform(training).show(false);
        spark.stop();
    }
}

