/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.util.List;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.evaluator.memory.VariableNotSetException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.util.Localiser;

public class ListGetMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);

    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        if (invokedValue == null) {
            return null;
        }
        if (!(invokedValue instanceof List)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        Expression param = expr.getArguments().get(0);
        Object paramValue = null;
        if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)param;
            try {
                paramValue = eval.getValueForVariableExpression(varExpr);
            }
            catch (VariableNotSetException vnse) {
                throw new VariableNotSetException(varExpr, ((List)invokedValue).toArray());
            }
        } else {
            throw new NucleusException("Dont currently support use of get(" + param.getClass().getName() + ")");
        }
        if (!(paramValue instanceof Number)) {
            throw new NucleusException("List.get() should take in an integer but is " + paramValue);
        }
        int paramInt = ((Number)paramValue).intValue();
        return ((List)invokedValue).get(paramInt);
    }
}

