/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import org.apache.spark.SparkContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.mesos.MesosCoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.mesos.MesosFineGrainedSchedulerBackend;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001i3Q!\u0001\u0002\u0001\u00119\u00111#T3t_N\u001cE.^:uKJl\u0015M\\1hKJT!a\u0001\u0003\u0002\u000b5,7o\\:\u000b\u0005\u00151\u0011aB2mkN$XM\u001d\u0006\u0003\u000f!\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\r%\u0011\u0001D\u0002\u0002\u0017\u000bb$XM\u001d8bY\u000ecWo\u001d;fe6\u000bg.Y4fe\")!\u0004\u0001C\u00019\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\n1\"T#T\u001fN{&+R$F1V\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005AQ.\u0019;dQ&twM\u0003\u0002(#\u0005!Q\u000f^5m\u0013\tICEA\u0003SK\u001e,\u0007\u0010\u0003\u0004,\u0001\u0001\u0006IAI\u0001\r\u001b\u0016\u001bvjU0S\u000b\u001e+\u0005\f\t\u0005\u0006[\u0001!\tEL\u0001\nG\u0006t7I]3bi\u0016$\"a\f\u001a\u0011\u0005A\u0001\u0014BA\u0019\u0012\u0005\u001d\u0011un\u001c7fC:DQa\r\u0017A\u0002Q\n\u0011\"\\1ti\u0016\u0014XK\u0015'\u0011\u0005UBdB\u0001\t7\u0013\t9\u0014#\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c\u0012\u0011\u0015a\u0004\u0001\"\u0011>\u0003M\u0019'/Z1uKR\u000b7o[*dQ\u0016$W\u000f\\3s)\rq\u0014i\u0012\t\u0003-}J!\u0001\u0011\u0004\u0003\u001bQ\u000b7o[*dQ\u0016$W\u000f\\3s\u0011\u0015\u00115\b1\u0001D\u0003\t\u00198\r\u0005\u0002E\u000b6\t\u0001\"\u0003\u0002G\u0011\ta1\u000b]1sW\u000e{g\u000e^3yi\")1g\u000fa\u0001i!)\u0011\n\u0001C!\u0015\u000612M]3bi\u0016\u001c6\r[3ek2,'OQ1dW\u0016tG\r\u0006\u0003L\u001d>\u0003\u0006C\u0001\fM\u0013\tieA\u0001\tTG\",G-\u001e7fe\n\u000b7m[3oI\")!\t\u0013a\u0001\u0007\")1\u0007\u0013a\u0001i!)q\u0001\u0013a\u0001}!)!\u000b\u0001C!'\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007Q;\u0006\f\u0005\u0002\u0011+&\u0011a+\u0005\u0002\u0005+:LG\u000fC\u0003\b#\u0002\u0007a\bC\u0003Z#\u0002\u00071*A\u0004cC\u000e\\WM\u001c3")
public class MesosClusterManager
implements ExternalClusterManager {
    private final Regex MESOS_REGEX = new StringOps(Predef$.MODULE$.augmentString("mesos://(.*)")).r();

    private Regex MESOS_REGEX() {
        return this.MESOS_REGEX;
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("mesos");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        Predef$.MODULE$.require(!BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.IO_ENCRYPTION_ENABLED())), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "I/O encryption is currently not supported in Mesos.";
            }
        });
        String mesosUrl = ((Regex.MatchData)this.MESOS_REGEX().findFirstMatchIn((CharSequence)masterURL).get()).group(1);
        boolean coarse = sc.conf().getBoolean("spark.mesos.coarse", true);
        return coarse ? new MesosCoarseGrainedSchedulerBackend((TaskSchedulerImpl)scheduler, sc, mesosUrl, sc.env().securityManager()) : new MesosFineGrainedSchedulerBackend((TaskSchedulerImpl)scheduler, sc, mesosUrl);
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }
}

