/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r]h\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\r\u001d!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005\u0019\u0019v.\u001e:dKB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004C\u0001\tS:$XM\u001d8bY&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013\u0001D:qCJ\\7+Z:tS>t\u0007CA\u0013'\u001b\u00051\u0011BA\u0014\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001\u00029bi\"\u0004\"aK\u0019\u000f\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a5B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0014M&dWMR8s[\u0006$8\t\\1tg:\u000bW.\u001a\u0005\to\u0001\u0011)\u0019!C!q\u000511o\u00195f[\u0006,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0019\tQ\u0001^=qKNL!AP\u001e\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003:\u0003\u001d\u00198\r[3nC\u0002B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]N\u00042\u0001\u0012'+\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I\u001d\u00051AH]8pizJ\u0011AL\u0005\u0003\u00176\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-k\u0003\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\t\u0011I\u0003!\u0011!Q\u0001\nM\u000bqa\u001c9uS>t7\u000f\u0005\u0003,)*R\u0013BA+4\u0005\ri\u0015\r\u001d\u0005\u0006/\u0002!\t\u0001W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011eS6\fX/_?\u0002\u0004\"!\u0007\u0001\t\u000b\r2\u0006\u0019\u0001\u0013\t\u000b%2\u0006\u0019\u0001\u0016\t\u000bU2\u0006\u0019\u0001\u0016\t\u000b]2\u0006\u0019A\u001d\t\u000b\t3\u0006\u0019A\"\t\u000bA3\u0006\u0019\u0001\u0016\t\u000bI3\u0006\u0019A*\t\u000f\t\u0004!\u0019!C\u0005G\u0006i1o\\;sG\u0016|\u0005\u000f^5p]N,\u0012\u0001\u001a\t\u00033\u0015L!A\u001a\u0002\u0003#\u0019KG.Z*ue\u0016\fWn\u00149uS>t7\u000f\u0003\u0004i\u0001\u0001\u0006I\u0001Z\u0001\u000fg>,(oY3PaRLwN\\:!\u0011\u001dQ\u0007A1A\u0005\n-\f!\u0002[1e_>\u00048i\u001c8g+\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003\u0011\u0019wN\u001c4\u000b\u0005ET\u0011A\u00025bI>|\u0007/\u0003\u0002t]\ni1i\u001c8gS\u001e,(/\u0019;j_:Da!\u001e\u0001!\u0002\u0013a\u0017a\u00035bI>|\u0007oQ8oM\u0002Bqa\u001e\u0001C\u0002\u0013%\u00010\u0001\u0002ggV\t\u0011\u0010\u0005\u0002{y6\t1P\u0003\u0002xa&\u0011Qp\u001f\u0002\u000b\r&dWmU=ti\u0016l\u0007BB@\u0001A\u0003%\u00110A\u0002gg\u0002B3A`A\u0002!\ra\u0013QA\u0005\u0004\u0003\u000fi#!\u0003;sC:\u001c\u0018.\u001a8u\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti!A\trk\u0006d\u0017NZ5fI\n\u000b7/\u001a)bi\",\"!a\u0004\u0011\u0007i\f\t\"C\u0002\u0002\u0014m\u0014A\u0001U1uQ\"A\u0011q\u0003\u0001!\u0002\u0013\ty!\u0001\nrk\u0006d\u0017NZ5fI\n\u000b7/\u001a)bi\"\u0004\u0003\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0003qy\u0007\u000f^5p]N<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\n\u000b7/\u001a)bi\",\"!a\b\u0011\r\u0005\u0005\u00121\u0006\u0016+\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C5n[V$\u0018M\u00197f\u0015\r\tI#L\u0001\u000bG>dG.Z2uS>t\u0017bA+\u0002$!A\u0011q\u0006\u0001!\u0002\u0013\ty\"A\u000fpaRLwN\\:XSRD\u0007+\u0019:uSRLwN\u001c\"bg\u0016\u0004\u0016\r\u001e5!\u0011%\t\u0019\u0004\u0001b\u0001\n\u0013\t)$A\u0006nKR\fG-\u0019;b\u0019><WCAA\u001c!\rI\u0012\u0011H\u0005\u0004\u0003w\u0011!a\u0005$jY\u0016\u001cFO]3b[N{WO]2f\u0019><\u0007\u0002CA \u0001\u0001\u0006I!a\u000e\u0002\u00195,G/\u00193bi\u0006dun\u001a\u0011\t\u0013\u0005\r\u0003\u00011A\u0005\n\u0005\u0015\u0013\u0001G7fi\u0006$\u0017\r^1M_\u001e\u001cUO\u001d:f]R|eMZ:fiV\u0011\u0011q\t\t\u0004Y\u0005%\u0013bAA&[\t!Aj\u001c8h\u0011%\ty\u0005\u0001a\u0001\n\u0013\t\t&\u0001\u000fnKR\fG-\u0019;b\u0019><7)\u001e:sK:$xJ\u001a4tKR|F%Z9\u0015\t\u0005M\u0013\u0011\f\t\u0004Y\u0005U\u0013bAA,[\t!QK\\5u\u0011)\tY&!\u0014\u0002\u0002\u0003\u0007\u0011qI\u0001\u0004q\u0012\n\u0004\u0002CA0\u0001\u0001\u0006K!a\u0012\u000235,G/\u00193bi\u0006dunZ\"veJ,g\u000e^(gMN,G\u000f\t\u0005\n\u0003G\u0002!\u0019!C\u0005\u0003K\n\u0001#\\1y\r&dWm\u001d)fe\n\u000bGo\u00195\u0016\u0005\u0005\u001d\u0004#\u0002\u0017\u0002j\u00055\u0014bAA6[\t1q\n\u001d;j_:\u00042\u0001LA8\u0013\r\t\t(\f\u0002\u0004\u0013:$\b\u0002CA;\u0001\u0001\u0006I!a\u001a\u0002#5\f\u0007PR5mKN\u0004VM\u001d\"bi\u000eD\u0007\u0005C\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002|\u0005ia-\u001b7f'>\u0014Ho\u0014:eKJ,\"!! \u0011\r\u0005}\u0014QQA$\u001b\t\t\tIC\u0002\u0002\u00046\nA!\\1uQ&!\u0011qQAA\u0005!y%\u000fZ3sS:<\u0007\u0002CAF\u0001\u0001\u0006I!! \u0002\u001d\u0019LG.Z*peR|%\u000fZ3sA!I\u0011q\u0012\u0001C\u0002\u0013%\u0011QI\u0001\r[\u0006Dh)\u001b7f\u0003\u001e,Wj\u001d\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002H\u0005iQ.\u0019=GS2,\u0017iZ3Ng\u0002B\u0011\"a&\u0001\u0005\u0004%I!!'\u0002\u0019\u0019LG.\u001a(b[\u0016|e\u000e\\=\u0016\u0005\u0005m\u0005c\u0001\u0017\u0002\u001e&\u0019\u0011qT\u0017\u0003\u000f\t{w\u000e\\3b]\"A\u00111\u0015\u0001!\u0002\u0013\tY*A\u0007gS2,g*Y7f\u001f:d\u0017\u0010\t\u0005\n\u0003O\u0003!\u0019!C\u0001\u0003S\u000b\u0011b]3f]\u001aKG.Z:\u0016\u0005\u0005-\u0006\u0003BAW\u0005\u0003t1!GAX\u000f\u001d\t\tL\u0001E\u0001\u0003g\u000b\u0001CR5mKN#(/Z1n'>,(oY3\u0011\u0007e\t)L\u0002\u0004\u0002\u0005!\u0005\u0011qW\n\u0005\u0003k\u000bI\fE\u0002-\u0003wK1!!0.\u0005\u0019\te.\u001f*fM\"9q+!.\u0005\u0002\u0005\u0005GCAAZ\u000b\u001d\t)-!.\u0001\u0003\u000f\u0012\u0011\u0002V5nKN$\u0018-\u001c9\u0007\u000f\u0005%\u0017Q\u0017!\u0002L\nIa)\u001b7f\u000b:$(/_\n\t\u0003\u000f\fI,!4\u0002TB\u0019A&a4\n\u0007\u0005EWF\u0001\u0007TKJL\u0017\r\\5{C\ndW\rE\u0002-\u0003+L1!a6.\u0005\u001d\u0001&o\u001c3vGRD!\"KAd\u0005+\u0007I\u0011AAn+\u0005Q\u0003BCAp\u0003\u000f\u0014\t\u0012)A\u0005U\u0005)\u0001/\u0019;iA!Y\u00111]Ad\u0005+\u0007I\u0011AAs\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002hB!\u0011\u0011^Ab\u001b\t\t)\fC\u0006\u0002n\u0006\u001d'\u0011#Q\u0001\n\u0005\u001d\u0018A\u0003;j[\u0016\u001cH/Y7qA!Y\u0011\u0011_Ad\u0005+\u0007I\u0011AA#\u0003\u001d\u0011\u0017\r^2i\u0013\u0012D1\"!>\u0002H\nE\t\u0015!\u0003\u0002H\u0005A!-\u0019;dQ&#\u0007\u0005C\u0004X\u0003\u000f$\t!!?\u0015\u0011\u0005m\u0018Q`A\u0000\u0005\u0003\u0001B!!;\u0002H\"1\u0011&a>A\u0002)B\u0001\"a9\u0002x\u0002\u0007\u0011q\u001d\u0005\t\u0003c\f9\u00101\u0001\u0002H!Q!QAAd\u0003\u0003%\tAa\u0002\u0002\t\r|\u0007/\u001f\u000b\t\u0003w\u0014IAa\u0003\u0003\u000e!A\u0011Fa\u0001\u0011\u0002\u0003\u0007!\u0006\u0003\u0006\u0002d\n\r\u0001\u0013!a\u0001\u0003OD!\"!=\u0003\u0004A\u0005\t\u0019AA$\u0011)\u0011\t\"a2\u0012\u0002\u0013\u0005!1C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)BK\u0002+\u0005/Y#A!\u0007\u0011\t\tm!QE\u0007\u0003\u0005;QAAa\b\u0003\"\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Gi\u0013AC1o]>$\u0018\r^5p]&!!q\u0005B\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005W\t9-%A\u0005\u0002\t5\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005_QC!a:\u0003\u0018!Q!1GAd#\u0003%\tA!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0007\u0016\u0005\u0003\u000f\u00129\u0002\u0003\u0006\u0003<\u0005\u001d\u0017\u0011!C!\u0005{\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B !\r\t\"\u0011I\u0005\u0003eIA!B!\u0012\u0002H\u0006\u0005I\u0011\u0001B$\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0007\u0003\u0006\u0003L\u0005\u001d\u0017\u0011!C\u0001\u0005\u001b\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003P\tU\u0003c\u0001\u0017\u0003R%\u0019!1K\u0017\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002\\\t%\u0013\u0011!a\u0001\u0003[B!B!\u0017\u0002H\u0006\u0005I\u0011\tB.\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B/!\u0019\u0011yF!\u0019\u0003P5\u0011\u0011qE\u0005\u0005\u0005G\n9C\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u00119'a2\u0002\u0002\u0013\u0005!\u0011N\u0001\tG\u0006tW)];bYR!\u00111\u0014B6\u0011)\tYF!\u001a\u0002\u0002\u0003\u0007!q\n\u0005\u000b\u0005_\n9-!A\u0005B\tE\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0004B\u0003B;\u0003\u000f\f\t\u0011\"\u0011\u0003x\u0005AAo\\*ue&tw\r\u0006\u0002\u0003@!Q!1PAd\u0003\u0003%\tE! \u0002\r\u0015\fX/\u00197t)\u0011\tYJa \t\u0015\u0005m#\u0011PA\u0001\u0002\u0004\u0011ye\u0002\u0006\u0003\u0004\u0006U\u0016\u0011!E\u0001\u0005\u000b\u000b\u0011BR5mK\u0016sGO]=\u0011\t\u0005%(q\u0011\u0004\u000b\u0003\u0013\f),!A\t\u0002\t%5C\u0002BD\u0005\u0017\u000bi\rE\u0006\u0003\u000e\nM%&a:\u0002H\u0005mXB\u0001BH\u0015\r\u0011\t*L\u0001\beVtG/[7f\u0013\u0011\u0011)Ja$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004X\u0005\u000f#\tA!'\u0015\u0005\t\u0015\u0005B\u0003B;\u0005\u000f\u000b\t\u0011\"\u0012\u0003x!Q!q\u0014BD\u0003\u0003%\tI!)\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005m(1\u0015BS\u0005OCa!\u000bBO\u0001\u0004Q\u0003\u0002CAr\u0005;\u0003\r!a:\t\u0011\u0005E(Q\u0014a\u0001\u0003\u000fB!Ba+\u0003\b\u0006\u0005I\u0011\u0011BW\u0003\u001d)h.\u00199qYf$BAa,\u00038B)A&!\u001b\u00032BAAFa-+\u0003O\f9%C\u0002\u000366\u0012a\u0001V;qY\u0016\u001c\u0004B\u0003B]\u0005S\u000b\t\u00111\u0001\u0002|\u0006\u0019\u0001\u0010\n\u0019\t\u0015\tu&qQA\u0001\n\u0013\u0011y,A\u0006sK\u0006$'+Z:pYZ,G#\u0001\t\u0007\u000f\t\r\u0017Q\u0017\u0001\u0003F\na1+Z3o\r&dWm]'baN!!\u0011YA]\u0011-\u0011IM!1\u0003\u0002\u0003\u0006I!a\u0012\u0002\u00115\f\u00070Q4f\u001bNDqB!4\u0003B\u0012\u0005\tQ!B\u0001B\u0003%\u00111T\u0001U_J<G%\u00199bG\",Ge\u001d9be.$3/\u001d7%Kb,7-\u001e;j_:$3\u000f\u001e:fC6Lgn\u001a\u0013GS2,7\u000b\u001e:fC6\u001cv.\u001e:dK\u0012\u001aV-\u001a8GS2,7/T1qI\u00112\u0017\u000e\\3OC6,wJ\u001c7z\u0011\u001d9&\u0011\u0019C\u0001\u0005#$bAa5\u0003V\n]\u0007\u0003BAu\u0005\u0003D\u0001B!3\u0003P\u0002\u0007\u0011q\t\u0005\t\u0003/\u0013y\r1\u0001\u0002\u001c\"Q!1\u001cBa\u0005\u0004%IA!8\u0002\u00075\f\u0007/\u0006\u0002\u0003`B9!\u0011\u001dBtU\u0005\u001dXB\u0001Br\u0015\r\u0011)\u000fF\u0001\u0005kRLG.\u0003\u0003\u0003j\n\r(a\u0002%bg\"l\u0015\r\u001d\u0005\n\u0005[\u0014\t\r)A\u0005\u0005?\fA!\\1qA!Q!\u0011\u001fBa\u0001\u0004%I!!:\u0002\u001f1\fG/Z:u)&lWm\u001d;b[BD!B!>\u0003B\u0002\u0007I\u0011\u0002B|\u0003Ma\u0017\r^3tiRKW.Z:uC6\u0004x\fJ3r)\u0011\t\u0019F!?\t\u0015\u0005m#1_A\u0001\u0002\u0004\t9\u000fC\u0005\u0003~\n\u0005\u0007\u0015)\u0003\u0002h\u0006\u0001B.\u0019;fgR$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\u000b\u0007\u0003\u0011\t\r1A\u0005\n\u0005\u0015\u0018A\u00057bgR\u0004VO]4f)&lWm\u001d;b[BD!b!\u0002\u0003B\u0002\u0007I\u0011BB\u0004\u0003Ya\u0017m\u001d;QkJ<W\rV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA*\u0007\u0013A!\"a\u0017\u0004\u0004\u0005\u0005\t\u0019AAt\u0011%\u0019iA!1!B\u0013\t9/A\nmCN$\b+\u001e:hKRKW.Z:uC6\u0004\b\u0005\u0003\u0005\u0004\u0012\t\u0005G\u0011BB\n\u0003Q\u0019HO]5q!\u0006$\b.\u00134OK\u000e,7o]1ssR!!qHB\u000b\u0011\u0019I3q\u0002a\u0001U!\"1qBB\r!\ra31D\u0005\u0004\u0007;i#AB5oY&tW\r\u0003\u0005\u0004\"\t\u0005G\u0011AB\u0012\u0003\r\tG\r\u001a\u000b\u0007\u0003'\u001a)ca\n\t\r%\u001ay\u00021\u0001+\u0011!\t\u0019oa\bA\u0002\u0005\u001d\b\u0002CB\u0016\u0005\u0003$\ta!\f\u0002\u0013%\u001ch*Z<GS2,GCBAN\u0007_\u0019\t\u0004\u0003\u0004*\u0007S\u0001\rA\u000b\u0005\t\u0003G\u001cI\u00031\u0001\u0002h\"A1Q\u0007Ba\t\u0003\u0011\t(A\u0003qkJ<W\r\u0003\u0005\u0004:\t\u0005G\u0011\u0001B$\u0003\u0011\u0019\u0018N_3\t\u0011\ru\u0002\u0001)A\u0005\u0003W\u000b!b]3f]\u001aKG.Z:!\u0011\u001d\u0019\t\u0005\u0001C\u0005\u0007\u0007\naBZ3uG\"l\u0015\r_(gMN,G\u000f\u0006\u0002\u0004FA\u0019\u0011da\u0012\n\u0007\r%#A\u0001\fGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK>3gm]3u\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007\u001f\n!c^5uQ\n\u000bGo\u00195j]\u001edunY6fIV!1\u0011KB,)\u0011\u0019\u0019fa\u0019\u0011\t\rU3q\u000b\u0007\u0001\t!\u0019Ifa\u0013C\u0002\rm#!\u0001+\u0012\t\ru#q\n\t\u0004Y\r}\u0013bAB1[\t9aj\u001c;iS:<\u0007\"CB3\u0007\u0017\"\t\u0019AB4\u0003\u00111WO\\2\u0011\u000b1\u001aIga\u0015\n\u0007\r-TF\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0019y\u0007\u0001C\u0001\u0003\u000b\n\u0001cY;se\u0016tG\u000fT8h\u001f\u001a47/\u001a;\t\u000f\rM\u0004\u0001\"\u0011\u0004v\u0005Aq-\u001a;CCR\u001c\u0007\u000e\u0006\u0004\u0004x\rM5q\u0014\t\u0005\u0007s\u001aiI\u0004\u0003\u0004|\r-e\u0002BB?\u0007\u0013sAaa \u0004\b:!1\u0011QBC\u001d\r151Q\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005-3\u0011\u0002BBH\u0007#\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005-3\u0001\u0002CBK\u0007c\u0002\raa&\u0002\u000bM$\u0018M\u001d;\u0011\u000b1\nIg!'\u0011\u0007e\u0019Y*C\u0002\u0004\u001e\n\u0011aa\u00144gg\u0016$\b\u0002CBQ\u0007c\u0002\ra!'\u0002\u0007\u0015tG\r\u0003\u0006\u0004&\u0002\u0001\r\u0011\"\u0001\u0007\u0007O\u000b\u0011c]8ve\u000e,\u0007*Y:NKR\fG-\u0019;b+\t\u0019I\u000bE\u0003-\u0003S\nY\n\u0003\u0006\u0004.\u0002\u0001\r\u0011\"\u0001\u0007\u0007_\u000bQc]8ve\u000e,\u0007*Y:NKR\fG-\u0019;b?\u0012*\u0017\u000f\u0006\u0003\u0002T\rE\u0006BCA.\u0007W\u000b\t\u00111\u0001\u0004*\"A1Q\u0017\u0001!B\u0013\u0019I+\u0001\nt_V\u00148-\u001a%bg6+G/\u00193bi\u0006\u0004\u0003\u0006BBZ\u0007s\u00032\u0001LB^\u0013\r\u0019i,\f\u0002\tm>d\u0017\r^5mK\"91\u0011\u0019\u0001\u0005\n\r\r\u0017AH1mY\u001aKG.Z:Vg&tw-\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y)\t\u0019)\r\u0005\u0003E\u0019\u000e\u001d\u0007c\u0001>\u0004J&\u001911Z>\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0004\u0004P\u0002!Iaa1\u0002C\u0005dGNR5mKN,6/\u001b8h\u001b\u0016$\u0018\rZ1uC2{wMR5mK&sG-\u001a=\t\u000f\rM\u0007\u0001\"\u0003\u0004V\u0006ia-\u001a;dQ\u0006cGNR5mKN$\"aa6\u0011\t\u0011c5\u0011\u001c\t\u0007Y\rm'&a\u0012\n\u0007\ruWF\u0001\u0004UkBdWM\r\u0005\b\u0007C\u0004A\u0011IBr\u0003%9W\r^(gMN,G/\u0006\u0002\u0004\u0018\"9!Q\u000f\u0001\u0005B\r\u001dH#\u0001\u0016\t\u000f\r-\b\u0001\"\u0011\u0004n\u000611m\\7nSR$B!a\u0015\u0004p\"A1\u0011UBu\u0001\u0004\u0019I\nC\u0004\u0004t\u0002!\te!>\u0002\tM$x\u000e\u001d\u000b\u0003\u0003'\u0002")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions sourceOptions;
    private final Configuration hadoopConf;
    private final transient FileSystem fs;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    private final Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    private final Ordering<Object> fileSortOrder;
    private final long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs;
    private final boolean fileNameOnly;
    private final SeenFilesMap seenFiles;
    private volatile Option<Object> sourceHasMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    private FileStreamOptions sourceOptions() {
        return this.sourceOptions;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = x$1;
    }

    public Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    }

    private Ordering<Object> fileSortOrder() {
        return this.fileSortOrder;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs;
    }

    private boolean fileNameOnly() {
        return this.fileNameOnly;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    boolean bl = this.$outer.seenFiles().isNewFile(path, timestamp);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<String, Object> file) {
                this.$outer.seenFiles().add((String)file._1(), file._2$mcJ$sp());
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)new Serializable(this, newFiles, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;
            private final Seq newFiles$1;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of new files = ", "\n         |Number of files selected for batch = ", "\n         |Number of seen files = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.seenFiles().size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newFiles$1 = newFiles$1;
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;

                public final FileEntry apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String p = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        FileEntry fileEntry = new FileEntry(p, timestamp, this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
                        return fileEntry;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log offset set to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new FileStreamSourceOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized long currentLogOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset();
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start2, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileEntry[] files = (FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileEntry> apply(Tuple2<Object, FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startOffset, endOffset, files){
            public static final long serialVersionUID = 0L;
            private final long startOffset$1;
            private final long endOffset$1;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startOffset$1 + 1L)), BoxesRunTime.boxToLong((long)this.endOffset$1)}));
            }
            {
                this.startOffset$1 = startOffset$1;
                this.endOffset$1 = endOffset$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$6 = this.sparkSession;
        Seq x$7 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileEntry f) {
                return new Path(new URI(f.path())).toString();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$8 = new Some((Object)this.schema());
        Seq<String> x$9 = this.partitionColumns;
        String x$10 = this.fileFormatClassName;
        Map<String, String> x$11 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$12 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$13 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$6, x$10, (Seq<String>)x$7, (Option<StructType>)x$8, x$9, x$12, x$11, x$13);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)LogicalRelation$.MODULE$.apply(newDataSource.resolveRelation(false), true));
    }

    public Option<Object> sourceHasMetadata() {
        return this.sourceHasMetadata;
    }

    public void sourceHasMetadata_$eq(Option<Object> x$1) {
        this.sourceHasMetadata = x$1;
    }

    private Seq<FileStatus> allFilesUsingInMemoryFileIndex() {
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.fs(), this.qualifiedBasePath());
        InMemoryFileIndex fileIndex = new InMemoryFileIndex(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        return fileIndex.allFiles();
    }

    private Seq<FileStatus> allFilesUsingMetadataLogFileIndex() {
        return new MetadataLogFileIndex(this.sparkSession, this.qualifiedBasePath(), (Option<StructType>)None$.MODULE$).allFiles();
    }

    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        Option<Object> option;
        block14: {
            Seq<FileStatus> allFiles2;
            long startTime;
            block12: {
                boolean bl;
                Some some;
                boolean bl2;
                block13: {
                    block11: {
                        BoxedUnit boxedUnit;
                        startTime = System.nanoTime();
                        allFiles2 = null;
                        bl2 = false;
                        some = null;
                        option = this.sourceHasMetadata();
                        if (!None$.MODULE$.equals(option)) break block11;
                        if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                            this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                            allFiles2 = this.allFilesUsingMetadataLogFileIndex();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            allFiles2 = this.allFilesUsingInMemoryFileIndex();
                            if (allFiles2.isEmpty()) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                                this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                                allFiles2 = this.allFilesUsingMetadataLogFileIndex();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block12;
                    }
                    if (!(option instanceof Some)) break block13;
                    bl2 = true;
                    some = (Some)option;
                    boolean bl3 = BoxesRunTime.unboxToBoolean((Object)some.x());
                    if (!bl3) break block13;
                    allFiles2 = this.allFilesUsingMetadataLogFileIndex();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (!bl2 || (bl = BoxesRunTime.unboxToBoolean((Object)some.x()))) break block14;
                allFiles2 = this.allFilesUsingInMemoryFileIndex();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq files = (Seq)((TraversableLike)allFiles2.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(FileStatus x$4) {
                    return x$4.getModificationTime();
                }
            }, this.fileSortOrder())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(FileStatus status) {
                    return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
                }
            }, Seq$.MODULE$.canBuildFrom());
            long endTime = System.nanoTime();
            double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
            if (listingTimeMs > (double)2000) {
                this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                    public static final long serialVersionUID = 0L;
                    private final Seq files$2;
                    private final double listingTimeMs$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                    }
                    {
                        this.files$2 = files$2;
                        this.listingTimeMs$1 = listingTimeMs$1;
                    }
                });
            } else {
                this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                    public static final long serialVersionUID = 0L;
                    private final Seq files$2;
                    private final double listingTimeMs$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                    }
                    {
                        this.files$2 = files$2;
                        this.listingTimeMs$1 = listingTimeMs$1;
                    }
                });
            }
            this.logTrace((Function0<String>)new Serializable(this, files){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
                }
                {
                    this.files$2 = files$2;
                }
            });
            return files;
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStreamSourceOffset x$5) {
                return x$5.logOffset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema2, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        Ordering ordering;
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema2;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.sourceOptions = new FileStreamOptions(options);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fs = new Path(path).getFileSystem(this.hadoopConf());
        this.qualifiedBasePath = this.fs().makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, FileEntry[]> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch = this.sourceOptions().maxFilesPerTrigger();
        if (this.sourceOptions().latestFirst()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("'latestFirst' is true. New files will be processed first, which may affect the watermark\n          |value. In addition, 'maxFileAge' will be ignored.")).stripMargin();
                }
            });
            ordering = ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse();
        } else {
            ordering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        }
        this.fileSortOrder = ordering;
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs = this.sourceOptions().latestFirst() && this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().isDefined() ? Long.MAX_VALUE : this.sourceOptions().maxFileAgeMs();
        this.fileNameOnly = this.sourceOptions().fileNameOnly();
        if (this.fileNameOnly()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "'fileNameOnly' is enabled. Make sure your file names are unique (e.g. using UUID), otherwise, files with the same name but under different paths will be considered the same and causes data lost.";
                }
            });
        }
        this.seenFiles = new SeenFilesMap(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs(), this.fileNameOnly());
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(FileEntry entry2) {
                this.$outer.seenFiles().add(entry2.path(), entry2.timestamp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAgeMs = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sourceHasMetadata = SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$;
    }

    public static class FileEntry
    implements Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.class.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        public final boolean org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        private String stripPathIfNecessary(String path) {
            return this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly ? new Path(new URI(path)).getName() : path;
        }

        public void add(String path, long timestamp) {
            this.map().put(this.stripPathIfNecessary(path), BoxesRunTime.boxToLong((long)timestamp));
            if (timestamp > this.latestTimestamp()) {
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(this.stripPathIfNecessary(path));
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count2 = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry2 = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry2.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count2;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public SeenFilesMap(long maxAgeMs, boolean fileNameOnly) {
            this.maxAgeMs = maxAgeMs;
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly = fileNameOnly;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

