/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTask$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class DataWritingSparkTask$
implements Logging {
    public static final DataWritingSparkTask$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataWritingSparkTask$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public WriterCommitMessage run(DataWriterFactory<InternalRow> writeTask, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        String epochId = (String)Option$.MODULE$.apply((Object)context.getLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY())).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "0";
            }
        });
        DataWriter<InternalRow> dataWriter = writeTask.createDataWriter(partId, taskId, new StringOps(Predef$.MODULE$.augmentString(epochId)).toLong());
        Serializable x$1 = new Serializable(context, iter, useCommitCoordinator, stageId, stageAttempt, partId, taskId, attemptId, dataWriter){
            public static final long serialVersionUID = 0L;
            public final TaskContext context$1;
            private final Iterator iter$1;
            private final boolean useCommitCoordinator$2;
            public final int stageId$1;
            public final int stageAttempt$1;
            public final int partId$1;
            public final long taskId$1;
            public final int attemptId$1;
            private final DataWriter dataWriter$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final WriterCommitMessage apply() {
                void var1_4;
                WriterCommitMessage writerCommitMessage;
                while (this.iter$1.hasNext()) {
                    this.dataWriter$1.write(this.iter$1.next());
                }
                if (this.useCommitCoordinator$2) {
                    OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                    boolean commitAuthorized = coordinator.canCommit(this.stageId$1, this.stageAttempt$1, this.partId$1, this.attemptId$1);
                    if (!commitAuthorized) {
                        String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit denied for partition ", " (task ", ", attempt ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partId$1), BoxesRunTime.boxToLong((long)this.taskId$1), BoxesRunTime.boxToInteger((int)this.attemptId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stage ", ".", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.stageId$1), BoxesRunTime.boxToInteger((int)this.stageAttempt$1)}))).toString();
                        DataWritingSparkTask$.MODULE$.logInfo((Function0<String>)new Serializable(this, message){
                            public static final long serialVersionUID = 0L;
                            private final String message$1;

                            public final String apply() {
                                return this.message$1;
                            }
                            {
                                this.message$1 = message$1;
                            }
                        });
                        throw new CommitDeniedException(message, this.stageId$1, this.partId$1, this.attemptId$1);
                    }
                    DataWritingSparkTask$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.run.3 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit authorized for partition ", " (task ", ", attempt ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.partId$1), BoxesRunTime.boxToLong((long)this.$outer.taskId$1), BoxesRunTime.boxToInteger((int)this.$outer.attemptId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stage ", ".", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stageId$1), BoxesRunTime.boxToInteger((int)this.$outer.stageAttempt$1)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    writerCommitMessage = this.dataWriter$1.commit();
                } else {
                    DataWritingSparkTask$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.run.3 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writer for partition ", " is committing."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.context$1.partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    writerCommitMessage = this.dataWriter$1.commit();
                }
                WriterCommitMessage msg = writerCommitMessage;
                DataWritingSparkTask$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.run.3 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed partition ", " (task ", ", attempt ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.partId$1), BoxesRunTime.boxToLong((long)this.$outer.taskId$1), BoxesRunTime.boxToInteger((int)this.$outer.attemptId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stage ", ".", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stageId$1), BoxesRunTime.boxToInteger((int)this.$outer.stageAttempt$1)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_4;
            }
            {
                this.context$1 = context$1;
                this.iter$1 = iter$1;
                this.useCommitCoordinator$2 = useCommitCoordinator$2;
                this.stageId$1 = stageId$1;
                this.stageAttempt$1 = stageAttempt$1;
                this.partId$1 = partId$1;
                this.taskId$1 = taskId$1;
                this.attemptId$1 = attemptId$1;
                this.dataWriter$1 = dataWriter$1;
            }
        };
        Serializable x$2 = new Serializable(stageId, stageAttempt, partId, taskId, attemptId, dataWriter){
            public static final long serialVersionUID = 0L;
            public final int stageId$1;
            public final int stageAttempt$1;
            public final int partId$1;
            public final long taskId$1;
            public final int attemptId$1;
            private final DataWriter dataWriter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DataWritingSparkTask$.MODULE$.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.run.1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting commit for partition ", " (task ", ", attempt ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.partId$1), BoxesRunTime.boxToLong((long)this.$outer.taskId$1), BoxesRunTime.boxToInteger((int)this.$outer.attemptId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stage ", ".", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stageId$1), BoxesRunTime.boxToInteger((int)this.$outer.stageAttempt$1)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.dataWriter$1.abort();
                DataWritingSparkTask$.MODULE$.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.run.1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborted commit for partition ", " (task ", ", attempt ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.partId$1), BoxesRunTime.boxToLong((long)this.$outer.taskId$1), BoxesRunTime.boxToInteger((int)this.$outer.attemptId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stage ", ".", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stageId$1), BoxesRunTime.boxToInteger((int)this.$outer.stageAttempt$1)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.stageId$1 = stageId$1;
                this.stageAttempt$1 = stageAttempt$1;
                this.partId$1 = partId$1;
                this.taskId$1 = taskId$1;
                this.attemptId$1 = attemptId$1;
                this.dataWriter$1 = dataWriter$1;
            }
        };
        Serializable x$3 = new Serializable((Function0)x$1){
            public static final long serialVersionUID = 0L;
            private final Function0 x$1$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(this.x$1$1);
            }
            {
                this.x$1$1 = x$1$1;
            }
        };
        return (WriterCommitMessage)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$2, (Function0)x$3);
    }

    private DataWritingSparkTask$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

