/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001>\u0011q#\u00117uKJ$\u0016M\u00197f%\u0016t\u0017-\\3D_6l\u0017M\u001c3\u000b\u0005\r!\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"D\b\u0013\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u00037qi\u0011AA\u0005\u0003;\t\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b!J|G-^2u!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\"A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0011&A\u0004pY\u0012t\u0015-\\3\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003YI!!\f\f\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJD\u0001b\f\u0001\u0003\u0012\u0003\u0006IAK\u0001\t_2$g*Y7fA!A\u0011\u0007\u0001BK\u0002\u0013\u0005\u0011&A\u0004oK^t\u0015-\\3\t\u0011M\u0002!\u0011#Q\u0001\n)\n\u0001B\\3x\u001d\u0006lW\r\t\u0005\tk\u0001\u0011)\u001a!C\u0001m\u00051\u0011n\u001d,jK^,\u0012a\u000e\t\u0003?aJ!!\u000f\u0011\u0003\u000f\t{w\u000e\\3b]\"A1\b\u0001B\tB\u0003%q'A\u0004jgZKWm\u001e\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0011y\u0004)\u0011\"\u0011\u0005m\u0001\u0001\"\u0002\u0015=\u0001\u0004Q\u0003\"B\u0019=\u0001\u0004Q\u0003\"B\u001b=\u0001\u00049\u0004\"\u0002#\u0001\t\u0003*\u0015a\u0001:v]R\u0011aI\u0016\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tYe\"\u0001\u0004=e>|GOP\u0005\u0002C%\u0011a\nI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!A\u0014\u0011\u0011\u0005M#V\"\u0001\u0004\n\u0005U3!a\u0001*po\")qk\u0011a\u00011\u0006a1\u000f]1sWN+7o]5p]B\u00111+W\u0005\u00035\u001a\u0011Ab\u00159be.\u001cVm]:j_:Dq\u0001\u0018\u0001\u0002\u0002\u0013\u0005Q,\u0001\u0003d_BLH\u0003B _?\u0002Dq\u0001K.\u0011\u0002\u0003\u0007!\u0006C\u000427B\u0005\t\u0019\u0001\u0016\t\u000fUZ\u0006\u0013!a\u0001o!9!\rAI\u0001\n\u0003\u0019\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002I*\u0012!&Z\u0016\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001b\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002nQ\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f=\u0004\u0011\u0013!C\u0001G\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004bB9\u0001#\u0003%\tA]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0005\u0019(FA\u001cf\u0011\u001d)\b!!A\u0005BY\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018\u0001\u00027b]\u001eT\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fs\n11\u000b\u001e:j]\u001eD\u0011\"!\u0001\u0001\u0003\u0003%\t!a\u0001\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0001cA\u0010\u0002\b%\u0019\u0011\u0011\u0002\u0011\u0003\u0007%sG\u000fC\u0005\u0002\u000e\u0001\t\t\u0011\"\u0001\u0002\u0010\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\t\u0003/\u00012aHA\n\u0013\r\t)\u0002\t\u0002\u0004\u0003:L\bBCA\r\u0003\u0017\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005u\u0001!!A\u0005B\u0005}\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0002CBA\u0012\u0003S\t\t\"\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0015\"\u0001C%uKJ\fGo\u001c:\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\n\u0019\u0004\u0003\u0006\u0002\u001a\u00055\u0012\u0011!a\u0001\u0003#A\u0011\"a\u000e\u0001\u0003\u0003%\t%!\u000f\u0002\r\u0015\fX/\u00197t)\r9\u00141\b\u0005\u000b\u00033\t)$!AA\u0002\u0005Eq!CA \u0005\u0005\u0005\t\u0012AA!\u0003]\tE\u000e^3s)\u0006\u0014G.\u001a*f]\u0006lWmQ8n[\u0006tG\rE\u0002\u001c\u0003\u00072\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QI\n\u0006\u0003\u0007\n9\u0005\n\t\t\u0003\u0013\nyE\u000b\u00168\u007f5\u0011\u00111\n\u0006\u0004\u0003\u001b\u0002\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003#\nYEA\tBEN$(/Y2u\rVt7\r^5p]NBq!PA\"\t\u0003\t)\u0006\u0006\u0002\u0002B!Q\u0011\u0011LA\"\u0003\u0003%)%a\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001e\u0005\u000b\u0003?\n\u0019%!A\u0005\u0002\u0006\u0005\u0014!B1qa2LHcB \u0002d\u0005\u0015\u0014q\r\u0005\u0007Q\u0005u\u0003\u0019\u0001\u0016\t\rE\ni\u00061\u0001+\u0011\u0019)\u0014Q\fa\u0001o!Q\u00111NA\"\u0003\u0003%\t)!\u001c\u0002\u000fUt\u0017\r\u001d9msR!\u0011qNA>!\u0015y\u0012\u0011OA;\u0013\r\t\u0019\b\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r}\t9H\u000b\u00168\u0013\r\tI\b\t\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005u\u0014\u0011NA\u0001\u0002\u0004y\u0014a\u0001=%a!Q\u0011\u0011QA\"\u0003\u0003%I!a!\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000b\u00032\u0001_AD\u0013\r\tI)\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class AlterTableRenameCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier oldName;
    private final TableIdentifier newName;
    private final boolean isView;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, TableIdentifier, Object>> unapply(AlterTableRenameCommand alterTableRenameCommand) {
        return AlterTableRenameCommand$.MODULE$.unapply(alterTableRenameCommand);
    }

    public static Function1<Tuple3<TableIdentifier, TableIdentifier, Object>, AlterTableRenameCommand> tupled() {
        return AlterTableRenameCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<Object, AlterTableRenameCommand>>> curried() {
        return AlterTableRenameCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        AlterTableRenameCommand alterTableRenameCommand = this;
        synchronized (alterTableRenameCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier oldName() {
        return this.oldName;
    }

    public TableIdentifier newName() {
        return this.newName;
    }

    public boolean isView() {
        return this.isView;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog2 = sparkSession.sessionState().catalog();
        if (catalog2.isTemporaryTable(this.oldName())) {
            catalog2.renameTable(this.oldName(), this.newName());
        } else {
            CatalogTable table = catalog2.getTableMetadata(this.oldName());
            DDLUtils$.MODULE$.verifyAlterTableType(catalog2, table, this.isView());
            boolean wasCached = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AlterTableRenameCommand $outer;
                private final SparkSession sparkSession$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.sparkSession$1.catalog().isCached(this.$outer.oldName().unquotedString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sparkSession$1 = sparkSession$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            if (wasCached) {
                try {
                    sparkSession.catalog().uncacheTable(this.oldName().unquotedString());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.log().warn(e.toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catalog2.refreshTable(this.oldName());
            catalog2.renameTable(this.oldName(), this.newName());
            if (wasCached) {
                sparkSession.catalog().cacheTable(this.newName().unquotedString());
            }
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableRenameCommand copy(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        return new AlterTableRenameCommand(oldName, newName, isView);
    }

    public TableIdentifier copy$default$1() {
        return this.oldName();
    }

    public TableIdentifier copy$default$2() {
        return this.newName();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public String productPrefix() {
        return "AlterTableRenameCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 1: {
                object = this.newName();
                break;
            }
            case 0: {
                object = this.oldName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenameCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenameCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)x$1;
        TableIdentifier tableIdentifier = this.oldName();
        TableIdentifier tableIdentifier2 = alterTableRenameCommand.oldName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.newName();
        TableIdentifier tableIdentifier4 = alterTableRenameCommand.newName();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        if (this.isView() != alterTableRenameCommand.isView()) return false;
        if (!alterTableRenameCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRenameCommand(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        this.oldName = oldName;
        this.newName = newName;
        this.isView = isView;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

