/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SparkSession;
import org.spark_project.guava.collect.Iterables;
import scala.Tuple2;

public final class JavaPageRank {
    private static final Pattern SPACES = Pattern.compile("\\s+");

    static void showWarning() {
        String warning = "WARN: This is a naive implementation of PageRank and is given as an example! \nPlease use the PageRank implementation found in org.apache.spark.graphx.lib.PageRank for more conventional use.";
        System.err.println(warning);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaPageRank <file> <number_of_iterations>");
            System.exit(1);
        }
        JavaPageRank.showWarning();
        SparkSession spark = SparkSession.builder().appName("JavaPageRank").getOrCreate();
        JavaRDD lines = spark.read().textFile(args[0]).javaRDD();
        JavaPairRDD links = lines.mapToPair((PairFunction & Serializable)s -> {
            String[] parts = SPACES.split((CharSequence)s);
            return new Tuple2((Object)parts[0], (Object)parts[1]);
        }).distinct().groupByKey().cache();
        JavaPairRDD ranks = links.mapValues((Function & Serializable)rs -> 1.0);
        for (int current = 0; current < Integer.parseInt(args[1]); ++current) {
            JavaPairRDD contribs = links.join(ranks).values().flatMapToPair((PairFlatMapFunction & Serializable)s -> {
                int urlCount = Iterables.size((Iterable)((Iterable)s._1()));
                ArrayList<Tuple2> results = new ArrayList<Tuple2>();
                for (String n : (Iterable)s._1) {
                    results.add(new Tuple2((Object)n, (Object)((Double)s._2() / (double)urlCount)));
                }
                return results.iterator();
            });
            ranks = contribs.reduceByKey((Function2)new Sum()).mapValues((Function & Serializable)sum -> 0.15 + sum * 0.85);
        }
        List output = ranks.collect();
        for (Tuple2 tuple : output) {
            System.out.println(tuple._1() + " has rank: " + tuple._2() + ".");
        }
        spark.stop();
    }

    private static class Sum
    implements Function2<Double, Double, Double> {
        private Sum() {
        }

        public Double call(Double a, Double b) {
            return a + b;
        }
    }
}

