/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ToUTCTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, timezone) - Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a time in the given time zone, and renders that time as a timestamp in UTC. For example, 'GMT+1' would yield '2017-07-14 01:40:00.0'.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 'Asia/Seoul');\n       2016-08-30 15:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001>\u0011a\u0002V8V)\u000e#\u0016.\\3ti\u0006l\u0007O\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%\u0001\u0003mK\u001a$X#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u0005)A.\u001a4uA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%A\u0003sS\u001eDG\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0011\u0018n\u001a5uA!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\t\t\u0002\u0001C\u0003\"Y\u0001\u00071\u0005C\u0003*Y\u0001\u00071\u0005C\u00034\u0001\u0011\u0005C'\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u000e\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q(G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0002TKFT!!P\r\u0011\u0005\t+U\"A\"\u000b\u0005\u00113\u0011!\u0002;za\u0016\u001c\u0018B\u0001$D\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003I\u0001\u0011\u0005\u0013*\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0005C\u0001\"L\u0013\ta5I\u0001\u0005ECR\fG+\u001f9f\u0011\u0015q\u0005\u0001\"\u0011P\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002!B\u0011\u0011\u000b\u0016\b\u00031IK!aU\r\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'fAQ\u0001\u0017\u0001\u0005Be\u000bAB\\;mYN\u000bg-Z#wC2$2AW/`!\tA2,\u0003\u0002]3\t\u0019\u0011I\\=\t\u000by;\u0006\u0019\u0001.\u0002\tQLW.\u001a\u0005\u0006A^\u0003\rAW\u0001\ti&lWM_8oK\")!\r\u0001C!G\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004I*|\u0007CA3i\u001b\u00051'BA4\u0003\u0003\u001d\u0019w\u000eZ3hK:L!!\u001b4\u0003\u0011\u0015C\bO]\"pI\u0016DQa[1A\u00021\f1a\u0019;y!\t)W.\u0003\u0002oM\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u00029b\u0001\u0004!\u0017AA3w\u0011\u001d\u0011\b!!A\u0005\u0002M\fAaY8qsR\u0019q\u0006^;\t\u000f\u0005\n\b\u0013!a\u0001G!9\u0011&\u001dI\u0001\u0002\u0004\u0019\u0003bB<\u0001#\u0003%\t\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005I(FA\u0012{W\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003I\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011QA?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\n\u0001\t\n\u0011\"\u0001y\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!\u0004\u0001\u0003\u0003%\t%a\u0004\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\t1\fgn\u001a\u0006\u0003\u00037\tAA[1wC&\u0019Q+!\u0006\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0013!\rA\u0012qE\u0005\u0004\u0003SI\"aA%oi\"I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0011qF\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rQ\u0016\u0011\u0007\u0005\u000b\u0003g\tY#!AA\u0002\u0005\u0015\u0012a\u0001=%c!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0013\u0011H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\b\t\u0006\u0003{\t\u0019EW\u0007\u0003\u0003\u007fQ1!!\u0011\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\nyD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tI\u0005AA\u0001\n\u0003\tY%\u0001\u0005dC:,\u0015/^1m)\u0011\ti%a\u0015\u0011\u0007a\ty%C\u0002\u0002Re\u0011qAQ8pY\u0016\fg\u000eC\u0005\u00024\u0005\u001d\u0013\u0011!a\u00015\"I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011L\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u00131\f\u0005\n\u0003g\t)&!AA\u0002iCs\u0002AA0\u0003K\n9'a\u001b\u0002n\u0005E\u00141\u000f\t\u0004#\u0005\u0005\u0014bAA2\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA5\u0003\u0005%wLR+O\u0007~CC/[7fgR\fW\u000e\u001d\u0017!i&lWM_8oK&\u0002S\u0006I$jm\u0016t\u0007%\u0019\u0011uS6,7\u000f^1na\u0002b\u0017n[3!OI\u0002\u0014gN\u00171o5\nD\u0007\t\u00193uQ\u0002$\b\r\u0019/a\u001db\u0003%\u001b8uKJ\u0004(/\u001a;tA%$\b%Y:!C\u0002\"\u0018.\\3!S:\u0004C\u000f[3!O&4XM\u001c\u0011uS6,\u0007E_8oK2\u0002\u0013M\u001c3!e\u0016tG-\u001a:tAQD\u0017\r\u001e\u0011uS6,\u0007%Y:!C\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI5oAU#6I\f\u0011G_J\u0004S\r_1na2,G\u0006I\u0014H\u001bR[\u0013g\n\u0011x_VdG\rI=jK2$\u0007e\n\u001a1c]j\u0003gN\u00172i\u0001\u0002\u0014G\u000f\u001b1uA\u0002d\u0006M\u0014/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA8\u0003}S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0003\u0007O\u00174c\u001db\u0003eJ!tS\u0006|3+Z8vY\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0003\u0007O\u00174a\u0001\nTG\u000f\u00191uA\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0014!B\u0019/k9\u0002t!CA=\u0005\u0005\u0005\t\u0012AA>\u00039!v.\u0016+D)&lWm\u001d;b[B\u00042!EA?\r!\t!!!A\t\u0002\u0005}4#BA?\u0003\u0003k\u0002cBAB\u0003\u0013\u001b3eL\u0007\u0003\u0003\u000bS1!a\"\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!a#\u0002\u0006\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f5\ni\b\"\u0001\u0002\u0010R\u0011\u00111\u0010\u0005\u000b\u0003'\u000bi(!A\u0005F\u0005U\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0001BCAM\u0003{\n\t\u0011\"!\u0002\u001c\u0006)\u0011\r\u001d9msR)q&!(\u0002 \"1\u0011%a&A\u0002\rBa!KAL\u0001\u0004\u0019\u0003BCAR\u0003{\n\t\u0011\"!\u0002&\u00069QO\\1qa2LH\u0003BAT\u0003g\u0003R\u0001GAU\u0003[K1!a+\u001a\u0005\u0019y\u0005\u000f^5p]B)\u0001$a,$G%\u0019\u0011\u0011W\r\u0003\rQ+\b\u000f\\33\u0011%\t),!)\u0002\u0002\u0003\u0007q&A\u0002yIAB!\"!/\u0002~\u0005\u0005I\u0011BA^\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0006\u0003BA\n\u0003\u007fKA!!1\u0002\u0016\t1qJ\u00196fGR\u0004")
public class ToUTCTimestamp
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ToUTCTimestamp toUTCTimestamp) {
        return ToUTCTimestamp$.MODULE$.unapply(toUTCTimestamp);
    }

    public static Function1<Tuple2<Expression, Expression>, ToUTCTimestamp> tupled() {
        return ToUTCTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToUTCTimestamp>> curried() {
        return ToUTCTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "to_utc_timestamp";
    }

    @Override
    public Object nullSafeEval(Object time, Object timezone) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toUTCTime(BoxesRunTime.unboxToLong((Object)time), ((UTF8String)timezone).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        if (this.right().foldable()) {
            UTF8String tz = (UTF8String)this.right().eval(this.right().eval$default$1());
            if (tz == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |long ", " = 0;\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String tzClass = TimeZone.class.getName();
                String dtu2 = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                String escapedTz = StringEscapeUtils.escapeJava((String)tz.toString());
                String tzTerm = ctx.addMutableState(tzClass, "tz", (Function1<String, String>)new Serializable(this, dtu2, escapedTz){
                    public static final long serialVersionUID = 0L;
                    private final String dtu$23;
                    private final String escapedTz$2;

                    public final String apply(String v) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".getTimeZone(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v, this.dtu$23, this.escapedTz$2}));
                    }
                    {
                        this.dtu$23 = dtu$23;
                        this.escapedTz$2 = escapedTz$2;
                    }
                }, ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String utcTerm = "tzUTC";
                ctx.addImmutableStateIfNotExists(tzClass, utcTerm, (Function1<String, String>)new Serializable(this, dtu2){
                    public static final long serialVersionUID = 0L;
                    private final String dtu$23;

                    public final String apply(String v) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".getTimeZone(\"UTC\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v, this.dtu$23}));
                    }
                    {
                        this.dtu$23 = dtu$23;
                    }
                });
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |boolean ", " = ", ";\n           |long ", " = 0;\n           |if (!", ") {\n           |  ", " = ", ".convertTz(", ", ", ", ", ");\n           |}\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), ev.value(), ev.isNull(), ev.value(), dtu2, eval2.value(), tzTerm, utcTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, dtu){
                public static final long serialVersionUID = 0L;
                private final String dtu$22;

                public final String apply(String timestamp, String format2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".toUTCTime(", ", ", ".toString())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$22, timestamp, format2}));
                }
                {
                    this.dtu$22 = dtu$22;
                }
            });
        }
        return exprCode;
    }

    public ToUTCTimestamp copy(Expression left, Expression right) {
        return new ToUTCTimestamp(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToUTCTimestamp";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUTCTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUTCTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUTCTimestamp toUTCTimestamp = (ToUTCTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = toUTCTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toUTCTimestamp.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toUTCTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUTCTimestamp(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

