/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001>\u0011Q\"T1q\rJ|W.\u0011:sCf\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\u0005Y\u00164G/F\u0001$!\t\tB%\u0003\u0002&\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\r\nQ\u0001\\3gi\u0002B\u0001\"\u000b\u0001\u0003\u0016\u0004%\tAI\u0001\u0006e&<\u0007\u000e\u001e\u0005\tW\u0001\u0011\t\u0012)A\u0005G\u00051!/[4ii\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00181cA\u0011\u0011\u0003\u0001\u0005\u0006C1\u0002\ra\t\u0005\u0006S1\u0002\ra\t\u0005\u0006g\u0001!\t\u0005N\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A\u001b\u0011\u0007Yr\u0014I\u0004\u00028y9\u0011\u0001hO\u0007\u0002s)\u0011!HD\u0001\u0007yI|w\u000e\u001e \n\u0003iI!!P\r\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\u0004'\u0016\f(BA\u001f\u001a!\t\u0011U)D\u0001D\u0015\t!e!A\u0003usB,7/\u0003\u0002G\u0007\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u0006\u0011\u0002!\t%S\u0001\tI\u0006$\u0018\rV=qKV\t!\n\u0005\u0002C\u0017&\u0011Aj\u0011\u0002\t\t\u0006$\u0018\rV=qK\")a\n\u0001C!\u001f\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001kU+\u0011\u0005a\t\u0016B\u0001*\u001a\u0005\r\te.\u001f\u0005\u0006)6\u0003\r\u0001U\u0001\tW\u0016L\u0018I\u001d:bs\")a+\u0014a\u0001!\u0006Qa/\u00197vK\u0006\u0013(/Y=\t\u000ba\u0003A\u0011I-\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u0001.aKB\u00111LX\u0007\u00029*\u0011QLA\u0001\bG>$WmZ3o\u0013\tyFL\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\tw\u000b1\u0001c\u0003\r\u0019G\u000f\u001f\t\u00037\u000eL!\u0001\u001a/\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")am\u0016a\u00015\u0006\u0011QM\u001e\u0005\u0006Q\u0002!\t%[\u0001\u000baJ,G\u000f^=OC6,W#\u00016\u0011\u0005-tgB\u0001\rm\u0013\ti\u0017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7\u001a\u0011\u001d\u0011\b!!A\u0005\u0002M\fAaY8qsR\u0019q\u0006^;\t\u000f\u0005\n\b\u0013!a\u0001G!9\u0011&\u001dI\u0001\u0002\u0004\u0019\u0003bB<\u0001#\u0003%\t\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005I(FA\u0012{W\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003I\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011QA?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\n\u0001\t\n\u0011\"\u0001y\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!\u0004\u0001\u0003\u0003%\t%a\u0004\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\t1\fgn\u001a\u0006\u0003\u00037\tAA[1wC&\u0019q.!\u0006\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0013!\rA\u0012qE\u0005\u0004\u0003SI\"aA%oi\"I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0011qF\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0001\u0016\u0011\u0007\u0005\u000b\u0003g\tY#!AA\u0002\u0005\u0015\u0012a\u0001=%c!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0013\u0011H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\b\t\u0006\u0003{\t\u0019\u0005U\u0007\u0003\u0003\u007fQ1!!\u0011\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\nyD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tI\u0005AA\u0001\n\u0003\tY%\u0001\u0005dC:,\u0015/^1m)\u0011\ti%a\u0015\u0011\u0007a\ty%C\u0002\u0002Re\u0011qAQ8pY\u0016\fg\u000eC\u0005\u00024\u0005\u001d\u0013\u0011!a\u0001!\"I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011L\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u00131\f\u0005\n\u0003g\t)&!AA\u0002ACs\u0002AA0\u0003K\n9'a\u001b\u0002n\u0005E\u00141\u000f\t\u0004#\u0005\u0005\u0014bAA2\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA5\u0003\u0005\u0015!\u0002\t\u0011!A}3UKT\"`Q-,\u0017p\u001d\u0017!m\u0006dW/Z:*A5\u00023I]3bi\u0016\u001c\b%\u0019\u0011nCB\u0004s/\u001b;iA\u0005\u0004\u0003/Y5sA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!W\u0016LxF^1mk\u0016\u0004\u0013M\u001d:bsNt\u0003%\u00117mA\u0015dW-\\3oiNT\u0001\u0005\t\u0011!A\u0001Jg\u000eI6fsN\u00043\u000f[8vY\u0012\u0004cn\u001c;!E\u0016\u0004c.\u001e7m\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA8\u0003\rT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013G\f\u0019-AMr\u0003'\u000b\u0017!CJ\u0014\u0018-\u001f\u0015(e\u001db\u0003e\n\u001b(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e_\u0019/ai\u0012#G\t\u00174]AR$\u0005\u000e\u0012~\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA;\u0003\u0015\u0011d\u0006\u000e\u00181\u000f%\tIHAA\u0001\u0012\u0003\tY(A\u0007NCB4%o\\7BeJ\f\u0017p\u001d\t\u0004#\u0005ud\u0001C\u0001\u0003\u0003\u0003E\t!a \u0014\u000b\u0005u\u0014\u0011Q\u000f\u0011\u000f\u0005\r\u0015\u0011R\u0012$_5\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fK\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\u000b)IA\tBEN$(/Y2u\rVt7\r^5p]JBq!LA?\t\u0003\ty\t\u0006\u0002\u0002|!Q\u00111SA?\u0003\u0003%)%!&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0005\t\u0015\u0005e\u0015QPA\u0001\n\u0003\u000bY*A\u0003baBd\u0017\u0010F\u00030\u0003;\u000by\n\u0003\u0004\"\u0003/\u0003\ra\t\u0005\u0007S\u0005]\u0005\u0019A\u0012\t\u0015\u0005\r\u0016QPA\u0001\n\u0003\u000b)+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u001d\u00161\u0017\t\u00061\u0005%\u0016QV\u0005\u0004\u0003WK\"AB(qi&|g\u000eE\u0003\u0019\u0003_\u001b3%C\u0002\u00022f\u0011a\u0001V;qY\u0016\u0014\u0004\"CA[\u0003C\u000b\t\u00111\u00010\u0003\rAH\u0005\r\u0005\u000b\u0003s\u000bi(!A\u0005\n\u0005m\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!0\u0011\t\u0005M\u0011qX\u0005\u0005\u0003\u0003\f)B\u0001\u0004PE*,7\r\u001e")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays mapFromArrays) {
        return MapFromArrays$.MODULE$.unapply(mapFromArrays);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        if (keyArrayData.numElements() != valueArrayData.numElements()) {
            throw new RuntimeException("The given two arrays should have the same length");
        }
        ArrayType leftArrayType = (ArrayType)this.left().dataType();
        if (leftArrayType.containsNull()) {
            for (int i = 0; i < keyArrayData.numElements(); ++i) {
                if (!keyArrayData.isNullAt(i)) continue;
                throw new RuntimeException("Cannot use null as map key!");
            }
        }
        return new ArrayBasedMapData(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MapFromArrays $outer;
            private final CodegenContext ctx$3;
            private final ExprCode ev$1;

            public final String apply(String keyArrayData, String valueArrayData) {
                String string;
                String arrayBasedMapData = ArrayBasedMapData.class.getName();
                ArrayType leftArrayType = (ArrayType)this.$outer.left().dataType();
                if (leftArrayType.containsNull()) {
                    String i = this.ctx$3.freshName("i");
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |for (int ", " = 0; ", " < ", ".numElements(); ", "++) {\n           |  if (", ".isNullAt(", ")) {\n           |    throw new RuntimeException(\"Cannot use null as map key!\");\n           |  }\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i, i, keyArrayData, i, keyArrayData, i})))).stripMargin();
                } else {
                    string = "";
                }
                String keyArrayElemNullCheck = string;
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (", ".numElements() != ", ".numElements()) {\n         |  throw new RuntimeException(\"The given two arrays should have the same length\");\n         |}\n         |", "\n         |", " = new ", "(", ".copy(), ", ".copy());\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyArrayData, valueArrayData, keyArrayElemNullCheck, this.ev$1.value(), arrayBasedMapData, keyArrayData, valueArrayData})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$3 = ctx$3;
                this.ev$1 = ev$1;
            }
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

