/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public abstract class Row$class {
    public static int size(Row $this) {
        return $this.length();
    }

    public static StructType schema(Row $this) {
        return null;
    }

    public static Object apply(Row $this, int i) {
        return $this.get(i);
    }

    public static boolean isNullAt(Row $this, int i) {
        return $this.get(i) == null;
    }

    public static boolean getBoolean(Row $this, int i) {
        return BoxesRunTime.unboxToBoolean((Object)Row$class.getAnyValAs($this, i));
    }

    public static byte getByte(Row $this, int i) {
        return BoxesRunTime.unboxToByte((Object)Row$class.getAnyValAs($this, i));
    }

    public static short getShort(Row $this, int i) {
        return BoxesRunTime.unboxToShort((Object)Row$class.getAnyValAs($this, i));
    }

    public static int getInt(Row $this, int i) {
        return BoxesRunTime.unboxToInt((Object)Row$class.getAnyValAs($this, i));
    }

    public static long getLong(Row $this, int i) {
        return BoxesRunTime.unboxToLong((Object)Row$class.getAnyValAs($this, i));
    }

    public static float getFloat(Row $this, int i) {
        return BoxesRunTime.unboxToFloat((Object)Row$class.getAnyValAs($this, i));
    }

    public static double getDouble(Row $this, int i) {
        return BoxesRunTime.unboxToDouble((Object)Row$class.getAnyValAs($this, i));
    }

    public static String getString(Row $this, int i) {
        return (String)$this.getAs(i);
    }

    public static BigDecimal getDecimal(Row $this, int i) {
        return (BigDecimal)$this.getAs(i);
    }

    public static Date getDate(Row $this, int i) {
        return (Date)$this.getAs(i);
    }

    public static Timestamp getTimestamp(Row $this, int i) {
        return (Timestamp)$this.getAs(i);
    }

    public static Seq getSeq(Row $this, int i) {
        return (Seq)$this.getAs(i);
    }

    public static List getList(Row $this, int i) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter($this.getSeq(i)).asJava();
    }

    public static Map getMap(Row $this, int i) {
        return (Map)$this.getAs(i);
    }

    public static java.util.Map getJavaMap(Row $this, int i) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter($this.getMap(i)).asJava();
    }

    public static Row getStruct(Row $this, int i) {
        return (Row)$this.getAs(i);
    }

    public static Object getAs(Row $this, int i) {
        return $this.get(i);
    }

    public static Object getAs(Row $this, String fieldName) {
        return $this.getAs($this.fieldIndex(fieldName));
    }

    public static int fieldIndex(Row $this, String name2) {
        throw new UnsupportedOperationException("fieldIndex on a Row without schema is undefined.");
    }

    public static scala.collection.immutable.Map getValuesMap(Row $this, Seq fieldNames2) {
        return ((TraversableOnce)fieldNames2.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Row $outer;

            public final Tuple2<String, T> apply(String name2) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name2), this.$outer.getAs(name2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static String toString(Row $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.mkString(",")}));
    }

    public static boolean anyNull(Row $this) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            if (!$this.isNullAt(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Row $this, Object o) {
        if (o instanceof Row) {
            Row other = (Row)o;
            if (other == null) {
                return false;
            }
            if ($this.length() != other.length()) {
                return false;
            }
            for (int i = 0; i < $this.length(); ++i) {
                double d;
                float f;
                BoxedUnit boxedUnit;
                if ($this.isNullAt(i) != other.isNullAt(i)) {
                    return false;
                }
                if ($this.isNullAt(i)) continue;
                Object o1 = $this.get(i);
                Object o2 = other.get(i);
                Object object = o1;
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (o2 instanceof byte[] && Arrays.equals(byArray, (byte[])o2)) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return false;
                }
                if (object instanceof Float && Float.isNaN(f = BoxesRunTime.unboxToFloat((Object)object))) {
                    if (o2 instanceof Float && Float.isNaN(BoxesRunTime.unboxToFloat((Object)o2))) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return false;
                }
                if (object instanceof Double && Double.isNaN(d = BoxesRunTime.unboxToDouble((Object)object))) {
                    if (o2 instanceof Double && Double.isNaN(BoxesRunTime.unboxToDouble((Object)o2))) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    return false;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (o2 instanceof BigDecimal) {
                        if (bigDecimal.compareTo((BigDecimal)o2) != 0) {
                            return false;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                }
                if (BoxesRunTime.equals((Object)o1, (Object)o2)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static int hashCode(Row $this) {
        int n;
        int h = MurmurHash3$.MODULE$.seqSeed();
        int len = $this.length();
        for (n = 0; n < len; ++n) {
            h = MurmurHash3$.MODULE$.mix(h, ScalaRunTime$.MODULE$.hash($this.apply(n)));
        }
        return MurmurHash3$.MODULE$.finalizeHash(h, n);
    }

    public static Seq toSeq(Row $this) {
        int n = $this.length();
        Object[] values2 = new Object[n];
        for (int i = 0; i < n; ++i) {
            values2[i] = $this.get(i);
        }
        return Predef$.MODULE$.genericArrayOps((Object)values2).toSeq();
    }

    public static String mkString(Row $this) {
        return $this.toSeq().mkString();
    }

    public static String mkString(Row $this, String sep) {
        return $this.toSeq().mkString(sep);
    }

    public static String mkString(Row $this, String start, String sep, String end) {
        return $this.toSeq().mkString(start, sep, end);
    }

    private static Object getAnyValAs(Row $this, int i) {
        if ($this.isNullAt(i)) {
            throw new NullPointerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Value at index ", " is null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
        }
        return $this.getAs(i);
    }

    public static void $init$(Row $this) {
    }
}

