/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public class JavaBinaryClassificationMetricsExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Java Binary Classification Metrics Example");
        SparkContext sc = new SparkContext(conf);
        String path = "data/mllib/sample_binary_classification_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc, (String)path).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        JavaRDD training = splits[0].cache();
        JavaRDD test = splits[1];
        LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(2).run(training.rdd());
        model.clearThreshold();
        JavaPairRDD predictionAndLabels = test.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)model.predict(p.features()), (Object)p.label()));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabels.rdd());
        JavaRDD precision = metrics.precisionByThreshold().toJavaRDD();
        System.out.println("Precision by threshold: " + precision.collect());
        JavaRDD recall = metrics.recallByThreshold().toJavaRDD();
        System.out.println("Recall by threshold: " + recall.collect());
        JavaRDD f1Score = metrics.fMeasureByThreshold().toJavaRDD();
        System.out.println("F1 Score by threshold: " + f1Score.collect());
        JavaRDD f2Score = metrics.fMeasureByThreshold(2.0).toJavaRDD();
        System.out.println("F2 Score by threshold: " + f2Score.collect());
        JavaRDD prc = metrics.pr().toJavaRDD();
        System.out.println("Precision-recall curve: " + prc.collect());
        JavaRDD thresholds = precision.map((Function & Serializable)t -> Double.parseDouble(t._1().toString()));
        JavaRDD roc = metrics.roc().toJavaRDD();
        System.out.println("ROC curve: " + roc.collect());
        System.out.println("Area under precision-recall curve = " + metrics.areaUnderPR());
        System.out.println("Area under ROC = " + metrics.areaUnderROC());
        model.save(sc, "target/tmp/LogisticRegressionModel");
        LogisticRegressionModel.load((SparkContext)sc, (String)"target/tmp/LogisticRegressionModel");
        sc.stop();
    }
}

