/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;
import org.apache.derby.impl.store.raw.data.RecordId;

public final class UpdateOperation
extends PhysicalPageOperation {
    protected int doMeSlot;
    protected int recordId;
    protected transient int nextColumn;
    protected transient ByteArray preparedLog;

    UpdateOperation(RawTransaction rawTransaction, BasePage basePage, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, int n3, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n4, RecordHandle recordHandle) throws StandardException {
        super(basePage);
        this.doMeSlot = n;
        this.recordId = n2;
        this.nextColumn = -1;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, dynamicByteArrayOutputStream, objectArray, formatableBitSet, n3, n4, recordHandle);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public UpdateOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        CompressedNumber.writeInt(objectOutput, this.recordId);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.recordId = CompressedNumber.readInt(objectInput);
    }

    @Override
    public int getTypeFormatId() {
        return 108;
    }

    public int getNextStartColumn() {
        return this.nextColumn;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.storeRecord(logInstant, this.doMeSlot, false, limitObjectInput);
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = basePage.findRecordById(this.recordId, 0);
        basePage.skipRecord(limitObjectInput);
        basePage.storeRecord(logInstant, n, false, limitObjectInput);
        basePage.setAuxObject(null);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, Object[] objectArray, FormatableBitSet formatableBitSet, int n, int n2, RecordHandle recordHandle) throws StandardException, IOException {
        int n3;
        if (n == -1) {
            dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        }
        int n4 = dynamicByteArrayOutputStream.getPosition();
        this.nextColumn = this.page.logRow(this.doMeSlot, false, this.recordId, objectArray, formatableBitSet, dynamicByteArrayOutputStream, 0, (byte)8, n, n2, 100);
        FormatableBitSet formatableBitSet2 = formatableBitSet;
        if (this.nextColumn != -1 && formatableBitSet != null) {
            n3 = this.page.getHeaderAtSlot(this.doMeSlot).getNumberFields();
            formatableBitSet2 = new FormatableBitSet(formatableBitSet);
            int n5 = this.nextColumn + n3;
            formatableBitSet2.grow(n5);
            for (int i = this.nextColumn; i < n5; ++i) {
                formatableBitSet2.set(i);
            }
        }
        this.page.logRecord(this.doMeSlot, 1, this.recordId, formatableBitSet2, dynamicByteArrayOutputStream, recordHandle);
        n4 = dynamicByteArrayOutputStream.getBeginPosition();
        n3 = dynamicByteArrayOutputStream.getPosition() - n4;
        dynamicByteArrayOutputStream.setPosition(n4);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n4, n3);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    private RecordHandle getRecordHandle() {
        return new RecordId(this.getPageId(), this.recordId);
    }

    @Override
    public void reclaimPrepareLocks(Transaction transaction, LockingPolicy lockingPolicy) throws StandardException {
        ContainerHandle containerHandle = transaction.openContainer(this.getPageId().getContainerId(), lockingPolicy, 196);
        if (containerHandle != null) {
            containerHandle.close();
        }
        boolean bl = lockingPolicy.lockRecordForWrite(transaction, this.getRecordHandle(), false, false);
        this.releaseResource(transaction);
    }

    @Override
    public String toString() {
        return null;
    }
}

