/*
 * Decompiled with CFR 0.152.
 */
package parquet.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import parquet.Log;

public class BytesUtils {
    private static final Log LOG = Log.getLog(BytesUtils.class);
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static int getWidthFromMaxInt(int bound) {
        return 32 - Integer.numberOfLeadingZeros(bound);
    }

    public static int readIntLittleEndian(byte[] in, int offset) throws IOException {
        int ch4 = in[offset] & 0xFF;
        int ch3 = in[offset + 1] & 0xFF;
        int ch2 = in[offset + 2] & 0xFF;
        int ch1 = in[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static int readIntLittleEndian(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public static int readIntLittleEndianOnOneByte(InputStream in) throws IOException {
        int ch1 = in.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        return ch1;
    }

    public static int readIntLittleEndianOnTwoBytes(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    public static int readIntLittleEndianOnThreeBytes(InputStream in) throws IOException {
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public static int readIntLittleEndianPaddedOnBitWidth(InputStream in, int bitWidth) throws IOException {
        int bytesWidth = BytesUtils.paddedByteCountFromBits(bitWidth);
        switch (bytesWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return BytesUtils.readIntLittleEndianOnOneByte(in);
            }
            case 2: {
                return BytesUtils.readIntLittleEndianOnTwoBytes(in);
            }
            case 3: {
                return BytesUtils.readIntLittleEndianOnThreeBytes(in);
            }
            case 4: {
                return BytesUtils.readIntLittleEndian(in);
            }
        }
        throw new IOException(String.format("Encountered bitWidth (%d) that requires more than 4 bytes", bitWidth));
    }

    public static void writeIntLittleEndianOnOneByte(OutputStream out, int v) throws IOException {
        out.write(v >>> 0 & 0xFF);
    }

    public static void writeIntLittleEndianOnTwoBytes(OutputStream out, int v) throws IOException {
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
    }

    public static void writeIntLittleEndianOnThreeBytes(OutputStream out, int v) throws IOException {
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 16 & 0xFF);
    }

    public static void writeIntLittleEndian(OutputStream out, int v) throws IOException {
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 24 & 0xFF);
        if (Log.DEBUG) {
            LOG.debug("write le int: " + v + " => " + (v >>> 0 & 0xFF) + " " + (v >>> 8 & 0xFF) + " " + (v >>> 16 & 0xFF) + " " + (v >>> 24 & 0xFF));
        }
    }

    public static void writeIntLittleEndianPaddedOnBitWidth(OutputStream out, int v, int bitWidth) throws IOException {
        int bytesWidth = BytesUtils.paddedByteCountFromBits(bitWidth);
        switch (bytesWidth) {
            case 0: {
                break;
            }
            case 1: {
                BytesUtils.writeIntLittleEndianOnOneByte(out, v);
                break;
            }
            case 2: {
                BytesUtils.writeIntLittleEndianOnTwoBytes(out, v);
                break;
            }
            case 3: {
                BytesUtils.writeIntLittleEndianOnThreeBytes(out, v);
                break;
            }
            case 4: {
                BytesUtils.writeIntLittleEndian(out, v);
                break;
            }
            default: {
                throw new IOException(String.format("Encountered value (%d) that requires more than 4 bytes", v));
            }
        }
    }

    public static int readUnsignedVarInt(InputStream in) throws IOException {
        int b;
        int value = 0;
        int i = 0;
        while (((b = in.read()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            i += 7;
        }
        return value | b << i;
    }

    public static int readZigZagVarInt(InputStream in) throws IOException {
        int raw = BytesUtils.readUnsignedVarInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static void writeUnsignedVarInt(int value, OutputStream out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value & 0x7F);
    }

    public static void writeZigZagVarInt(int intValue, OutputStream out) throws IOException {
        BytesUtils.writeUnsignedVarInt(intValue << 1 ^ intValue >> 31, out);
    }

    public static int paddedByteCountFromBits(int bitLength) {
        return (bitLength + 7) / 8;
    }

    public static byte[] intToBytes(int value) {
        byte[] outBuffer = new byte[4];
        outBuffer[3] = (byte)(value >>> 24);
        outBuffer[2] = (byte)(value >>> 16);
        outBuffer[1] = (byte)(value >>> 8);
        outBuffer[0] = (byte)(value >>> 0);
        return outBuffer;
    }

    public static int bytesToInt(byte[] bytes) {
        return ((bytes[3] & 0xFF) << 24) + ((bytes[2] & 0xFF) << 16) + ((bytes[1] & 0xFF) << 8) + ((bytes[0] & 0xFF) << 0);
    }

    public static byte[] longToBytes(long value) {
        byte[] outBuffer = new byte[8];
        outBuffer[7] = (byte)(value >>> 56);
        outBuffer[6] = (byte)(value >>> 48);
        outBuffer[5] = (byte)(value >>> 40);
        outBuffer[4] = (byte)(value >>> 32);
        outBuffer[3] = (byte)(value >>> 24);
        outBuffer[2] = (byte)(value >>> 16);
        outBuffer[1] = (byte)(value >>> 8);
        outBuffer[0] = (byte)(value >>> 0);
        return outBuffer;
    }

    public static long bytesToLong(byte[] bytes) {
        return ((long)bytes[7] << 56) + ((long)(bytes[6] & 0xFF) << 48) + ((long)(bytes[5] & 0xFF) << 40) + ((long)(bytes[4] & 0xFF) << 32) + ((long)(bytes[3] & 0xFF) << 24) + ((long)(bytes[2] & 0xFF) << 16) + ((long)(bytes[1] & 0xFF) << 8) + ((long)(bytes[0] & 0xFF) << 0);
    }

    public static byte[] booleanToBytes(boolean value) {
        byte[] outBuffer = new byte[]{(byte)(value ? 1 : 0)};
        return outBuffer;
    }

    public static boolean bytesToBool(byte[] bytes) {
        return (bytes[0] & 0xFF) != 0;
    }
}

