/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="max", value="_FUNC_(expr) - Returns the maximum value of expr (vectorized, type: long)")
public class VectorUDAFMaxLong
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient VectorExpressionWriter resultWriter;

    public VectorUDAFMaxLong(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFMaxLong() {
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
        this.resultWriter = VectorExpressionWriterFactory.genVectorExpressionWritable(desc.getParameters().get(0));
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregrateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        LongColumnVector inputVector = (LongColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        long[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(values[selection[i]]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(values[i]);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long value, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[selection[i]]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(value);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long value, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, j);
            myagg.checkValue(values[i]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, long[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(values[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        LongColumnVector inputVector = (LongColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        long[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls && (myagg.isNull || vector[0] > myagg.value)) {
                myagg.isNull = false;
                myagg.value = vector[0];
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            long value = vector[i];
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.value = value;
                continue;
            }
            if (value <= myagg.value) continue;
            myagg.value = value;
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.value = vector[selected[0]];
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            long value = vector[selected[i]];
            if (value <= myagg.value) continue;
            myagg.value = value;
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            long value = vector[i];
            if (myagg.isNull) {
                myagg.value = value;
                myagg.isNull = false;
                continue;
            }
            if (value <= myagg.value) continue;
            myagg.value = value;
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize) {
        if (myagg.isNull) {
            myagg.value = vector[0];
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            long value = vector[i];
            if (value <= myagg.value) continue;
            myagg.value = value;
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        return this.resultWriter.writeValue(myagg.value);
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.resultWriter.getObjectInspector();
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2(), model.memoryAlign());
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient long value;
        private transient boolean isNull = true;

        private Aggregation() {
        }

        public void checkValue(long value) {
            if (this.isNull) {
                this.isNull = false;
                this.value = value;
            } else if (value > this.value) {
                this.value = value;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.value = 0L;
        }
    }
}

