--100 sposobw na SQL, Sposb 87: 
--Wersja sqlserver

----------------------
--   Przygotowania  --
----------------------

CREATE VIEW pierwszyDzien AS SELECT '2007-03-01' AS pierwszy
;
CREATE TABLE kal (d DATETIME PRIMARY KEY);

INSERT INTO kal(d)
    SELECT DATEADD(d,i,pierwszy) FROM pierwszyDzien CROSS JOIN sto;
CREATE TABLE swieci
(d DATETIME
,imie VARCHAR(20)
);
INSERT INTO swieci VALUES ('2007-03-08', 'Sw. Jan');
INSERT INTO swieci VALUES ('2007-03-09', 'Sw. Franciszek');
INSERT INTO swieci VALUES ('2007-03-17', 'Sw. Patryk');
INSERT INTO swieci VALUES ('2007-03-19', 'Sw. Jozef');
INSERT INTO swieci VALUES ('2007-03-23', 'Sw. Turibiusz');

INSERT INTO swieci VALUES ('2007-05-01', 'Sw. Jozef');
INSERT INTO swieci VALUES ('2007-05-02', 'St. Athanasius');
INSERT INTO swieci VALUES ('2007-05-03', 'Sw. Filip');
INSERT INTO swieci VALUES ('2007-05-12', 'Sw. Pankracy');
---------------------
--       Sposb    --
---------------------

CREATE VIEW poczatekTygodnia AS
  SELECT DAY(d) - DATEPART(dw,d) AS wk
   FROM kal JOIN pierwszyDzien
     ON (MONTH ( d) = MONTH ( pierwszy))
   GROUP BY DAY(d) - DATEPART(dw,d);




CREATE VIEW kalSiatka AS
SELECT wk, DateAdd(d, wk + 0, pierwszy) AS Nd
         , DateAdd(d, wk + 1, pierwszy) AS Pon
         , DateAdd(d, wk + 2, pierwszy) AS Wt
         , DateAdd(d, wk + 3, pierwszy) AS Sr
         , DateAdd(d, wk + 4, pierwszy) AS Czw
         , DateAdd(d, wk + 5, pierwszy) AS Pt
         , DateAdd(d, wk + 6, pierwszy) AS Sob
  FROM poczatekTygodnia CROSS JOIN pierwszyDzien;

SELECT * FROM kalSiatka;
SELECT
  COALESCE((SELECT imie FROM swieci WHERE d=Nd),
           CAST(EXTRACT(DAY FROM Nd) AS CHAR(2))) AS Nd
 ,COALESCE((SELECT imie FROM swieci WHERE d=Pon),
           CAST(EXTRACT(DAY FROM Pon) AS CHAR(2))) AS Pon
 ,COALESCE((SELECT imie FROM swieci WHERE d=Wt),
           CAST(EXTRACT(DAY FROM Wt) AS CHAR(2))) AS Wt
 ,COALESCE((SELECT imie FROM swieci WHERE d=Sr),
           CAST(EXTRACT(DAY FROM Sr) AS CHAR(2))) AS Sr
 ,COALESCE((SELECT imie FROM swieci WHERE d=Czw),
           CAST(EXTRACT(DAY FROM Czw) AS CHAR(2))) AS Czw
 ,COALESCE((SELECT imie FROM swieci WHERE d=Pt),
           CAST(EXTRACT(DAY FROM Pt) AS CHAR(2))) AS Pt
 ,COALESCE((SELECT imie FROM swieci WHERE d=Sob),
           CAST(EXTRACT(DAY FROM Sob) AS CHAR(2))) AS Sob
FROM kalSiatka
ORDER BY wk;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP VIEW kalSiatka;
DROP VIEW poczatekTygodnia;
DROP VIEW pierwszyDzien;
DROP TABLE kal;
DROP TABLE swieci;