--100 sposobw na SQL, Sposb 45: Przetwarzanie dziennikw serwerw sieciowych
--Wersja postgres

----------------------
--   Przygotowania  --
----------------------


CREATE TABLE dziennik
(ip    VARCHAR(15)
,pom   VARCHAR(15)
,uzyt   VARCHAR(15)
,kiedy   TIMESTAMP
,metoda  VARCHAR(5)
,strona  VARCHAR(255)
,wer   VARCHAR(10)
,odp  INTEGER
,bajty INTEGER
,odn  VARCHAR(255)
,agent  VARCHAR(255)
);
CREATE INDEX stronaidx ON dziennik(strona);
CREATE INDEX ipidx   ON dziennik(ip);
CREATE INDEX kiedyidx  ON dziennik(kiedy);
CREATE INDEX odnidx ON dziennik(odn);
---------------------
--       Sposb    --
---------------------

SELECT COUNT(*), MIN(kiedy), MAX(kiedy)
  FROM dziennik;
SELECT LEFT(agent,50), COUNT(*)
  FROM dziennik
  WHERE strona='/robots.txt'
  GROUP BY agent
  ORDER BY 2 DESC'
DELETE FROM dziennik
  WHERE ip IN (SELECT ip
               FROM dziennik
               WHERE strona='/robots.txt');
UPDATE dziennik x JOIN dziennik y ON x.ip=y.ip
   SET x.agent = 'robot'
 WHERE y.strona='/robots.txt';
DELETE FROM dziennik WHERE agent='robot';
SELECT LEFT(strona,20), odn, COUNT(*)
  FROM dziennik
  WHERE odp BETWEEN 400 AND 499
  GROUP BY strona
  ORDER BY 3 DESC
  LIMIT 5;
DELETE FROM dziennik
 WHERE strona LIKE '%.css'
    OR strona LIKE '%.png'
    OR strona LIKE '%.js'
    OR strona LIKE '%.ico';
SELECT strona, COUNT(*) FROM dziennik
 GROUP BY strona
 ORDER BY 2 DESC
 LIMIT 6;
SELECT strona,odn, COUNT(*)
   FROM dziennik
  WHERE odn LIKE 'http://sqlzoo.net%'
  GROUP BY strona,odn
  ORDER BY 3 DESC
  LIMIT 10;
SELECT strona,odn, COUNT(*)
   FROM dziennik
  WHERE odn LIKE 'http://sqlzoo.net%'
    AND strona LIKE '/1_.htm'
  GROUP BY strona,odn
  ORDER BY 3 DESC
  LIMIT 10;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE dziennik;