--100 sposobw na SQL, Sposb 78: 
--Wersja sqlserver

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE populacja
(id INT PRIMARY KEY
,plec CHAR(1)
,wiek INT
,wydatki DECIMAL
);
INSERT INTO populacja(id,wiek,wydatki) Values (1,34,100);
INSERT INTO populacja(id,wiek,wydatki) Values (2,39,110);
INSERT INTO populacja(id,wiek,wydatki) Values (3,35,140);
INSERT INTO populacja(id,wiek,wydatki) Values (4,24,150);
INSERT INTO populacja(id,wiek,wydatki) Values (5,35,120);
INSERT INTO populacja(id,wiek,wydatki) Values (6,24,120);
INSERT INTO populacja(id,wiek,wydatki) Values (7,44,130);
INSERT INTO populacja(id,wiek,wydatki) Values (8,24,180);
INSERT INTO populacja(id,wiek,wydatki) Values (9,34,100);

CREATE TABLE daty
(kiedy DataTIME
);
INSERT INTO daty Values ('2006-12-05');
INSERT INTO daty Values ('2007-01-01');
INSERT INTO daty Values ('2007-02-05');

CREATE TABLE sezon
(id         VARCHAR(20) PRIMARY KEY
,poczData DataTIME
,koncowaData DataTIME
);
INSERT INTO sezon Values ('Jesien 2006','2006-09-21','2006-11-30');
INSERT INTO sezon Values ('Zima 06/07','2006-12-01','2007-02-28');
INSERT INTO sezon Values ('Wiosna 2007','2007-03-01','2007-06-01');
CREATE TABLE kategoria
(id        VARCHAR(20) PRIMARY KEY
,poczWartosc  DECIMAL(10,2)
,koncowaWartosc    DECIMAL(10,2)
);
INSERT INTO kategoria Values ('Mala (ponizej 15)',0,14.99);
INSERT INTO kategoria Values ('Srednia (od 15 do 25)',15,24.99);
INSERT INTO kategoria Values ('Duza (powyzej 25)',25,1E6);
CREATE TABLE zrodlo
(kiedy    DataTIME
,Wartosc    DECIMAL(10,2)
);
INSERT INTO zrodlo Values ('2006-10-26',14.00);
INSERT INTO zrodlo Values ('2006-10-28',32.12);
INSERT INTO zrodlo Values ('2006-10-29',30.00);
INSERT INTO zrodlo Values ('2006-11-29',23.99);
INSERT INTO zrodlo Values ('2006-11-30',20.65);
INSERT INTO zrodlo Values ('2006-12-05',29.65);
INSERT INTO zrodlo Values ('2006-12-05',19.65);
INSERT INTO zrodlo Values ('2006-12-05',9.65);
---------------------
--       Sposb    --
---------------------

SELECT id, wiek, ROUND(wiek,-1) FROM populacja;
SELECT ROUND(wiek,-1) AS grupa,
       AVG(wydatki)    AS srednieWydatki
  FROM populacja
 GROUP BY ROUND(wiek,-1)
;

SELECT STR(grupa-5) + '-' + STR(grupa+4) AS zakres
      ,srednieWydatki
  FROM(SELECT ROUND(wiek,-1) AS grupa,
              AVG(wydatki)    AS srednieWydatki
         FROM populacja
        GROUP BY ROUND(wiek,-1)) t;

SELECT wiek, 5*FLOOR(wiek/5) AS kategoria
          , CONCAT(5*FLOOR(wiek/5),'-',5*FLOOR(wiek/5)+4)
                               AS zakres
  FROM populacja;





SELECT kiedy,
       CONVERT(CHAR(7),kiedy,120) AS RokIMiesiac,
       CONVERT(DataTIME,CONVERT(CHAR(7),kiedy,120)+'-01')
                                AS PierwszyDzienMies
  FROM daty;

SELECT Wartosc,kategoria.id AS kategoriaWartosci, kiedy, sezon.id AS sezon
  FROM zrodlo
        JOIN kategoria  ON Wartosc BETWEEN poczWartosc  AND koncowaWartosc
        JOIN sezon ON kiedy   BETWEEN poczData AND koncowaData;

SELECT kategoria.id AS kategoriaWartosci, sezon.id AS sezon,
       AVG(Wartosc) sredniaWartosc
  FROM zrodlo
        JOIN kategoria  ON Wartosc BETWEEN poczWartosc  AND koncowaWartosc
        JOIN sezon ON kiedy   BETWEEN poczData AND koncowaData
 GROUP BY kategoria.id, sezon.id;
--------------------------
--    Usuwanie danych   --
--------------------------
;
DROP TABLE populacja;
DROP TABLE daty;
DROP TABLE sezon;
DROP TABLE kategoria;
DROP TABLE zrodlo;