--100 sposobw na SQL, Sposb 23: Drugi wtorek miesica
--Wersja mysql

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE daty(datamiesiaca DATE NOT NULL PRIMARY KEY);
INSERT INTO daty(datamiesiaca) VALUES (DATE '2007-04-01');
INSERT INTO daty(datamiesiaca) VALUES (DATE '2007-05-01');
INSERT INTO daty(datamiesiaca) VALUES (DATE '2007-06-01');
----------------------
--       Sposb     --
----------------------

SELECT datamiesiaca    AS pierwszy_dzien_miesiaca
     , DATE_ADD(datamiesiaca 
              , INTERVAL
                ( ( 10 - DAYOFWEEK(datamiesiaca) ) % 7 ) + 7
                DAY
              )     AS drugi_wtorek_miesiaca
  FROM daty;

SELECT datamiesiaca AS pierwszy_dzien_miesiaca
      ,DATE_ADD(datamiesiaca,INTERVAL 1 MONTH)
                 AS pierwszy_dzien_nastepnego_miesiaca
  FROM daty;

SELECT pierwszy_dzien_miesiaca
      ,DATE_ADD(pierwszy_dzien_nastepnego_miesiaca
               ,INTERVAL
                 ((12 - DAYOFWEEK(pierwszy_dzien_nastepnego_miesiaca)) % 7)
                      - 7 DAY) AS ostatni_czwartek_miesiaca
  FROM (SELECT datamiesiaca AS pierwszy_dzien_miesiaca
              ,DATE_ADD(datamiesiaca,INTERVAL 1 MONTH)
                         AS pierwszy_dzien_nastepnego_miesiaca
           FROM daty) t;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE daty;
