--100 sposobw na SQL, Sposb 36: Obliczanie odlegoci midzy lokalizacjami wskazywanymi przez system GPS
--Wersja oracle

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE gps(miejsce varchar(20), polnoc FLOAT, wschod FLOAT);
INSERT INTO gps VALUES ('dom', 55.954742,   -3.207630);
INSERT INTO gps VALUES ('napier', 55.932809,   -3.214617);
INSERT INTO gps VALUES ('zzuli',34.749660, 113.670094);
---------------------
--       Sposb    --
---------------------

CREATE VIEW gpsRad AS
  SELECT miejsce, 3.14159265359*e/180 AS dl
             , 3.14159265359*n/180 AS szer
             , 6378.1              AS R
    FROM gps;
SELECT p1.R*(p2.dl-p1.dl)*COS(p1.szer) AS dx,
       p1.R*(p2.szer-p1.szer)             AS dy
  FROM gpsRad p1 JOIN gpsRad p2
       ON (p1.miejsce='dom' AND p2.miejsce='napier');
SELECT SQRT(dx*dx+dy*dy) FROM
 (SELECT p1.R*(p2.dl-p1.dl)*COS(p1.szer) AS dx,
         p1.R*(p2.szer-p1.szer)             AS dy
    FROM gpsRad p1 JOIN gpsRad p2
         ON (p1.miejsce='dom' AND p2.miejsce='napier')) t;
SELECT SQRT(dx*dx+dy*dy) FROM
 (SELECT p1.R*(p2.dl-p1.dl)*COS(p1.szer) AS dx,
         p1.R*(p2.szer-p1.szer)             AS dy
    FROM gpsRad p1 JOIN gpsRad p2
         ON (p1.miejsce='zzuli' AND p2.miejsce='napier')) t;
SELECT SQRT(dx*dx+dy*dy) FROM
 (SELECT p1.R*(p2.dl-p1.dl)*COS(p1.szer) AS dx,
         p1.R*(p2.szer-p1.szer)             AS dy
    FROM gpsRad p1 JOIN gpsRad p2
         ON (p1.miejsce='napier' AND p2.miejsce='zzuli')) t;


CREATE VIEW gpsTrig AS
  SELECT miejsce, R, COS(szer) AS cos_szer, SIN(szer) AS sin_szer,
                  COS(dl) AS cos_dl, SIN(dl) AS sin_dl
    FROM gpsRad;
CREATE VIEW gpsGlb AS
  SELECT miejsce, R*cos_szer*cos_dl AS x,R*cos_szer*sin_dl AS y, R*sin_szer AS z
    FROM gpsTrig;

SELECT p1.x-p2.x AS dx, p1.y-p2.y AS dy, p1.z-p2.z AS dz
  FROM gpsGlb p1 JOIN gpsGlb p2
       ON (p1.miejsce='zzuli' AND p2.miejsce='napier');

SELECT SQRT(dx*dx+dy*dy+dz*dz) FROM
  (SELECT p1.x-p2.x AS dx, p1.y-p2.y AS dy, p1.z-p2.z AS dz
     FROM gpsGlb p1 JOIN gpsGlb p2
          ON (p1.miejsce='zzuli' AND p2.miejsce='napier')) t;

SELECT 2*R*ASIN(d/2/R) AS luk FROM
 (SELECT 6378 AS R) t0,
 (SELECT SQRT(dx*dx+dy*dy+dz*dz) AS d FROM
  (SELECT p1.x-p2.x AS dx, p1.y-p2.y AS dy, p1.z-p2.z AS dz
     FROM gpsGlb p1 JOIN gpsGlb p2
          ON (p1.miejsce='zzuli' AND p2.miejsce='napier')
  ) t1) t2;

SELECT 2*R*ASIN(d/2/R) AS luk FROM
 (SELECT 6378 AS R) t0,
 (SELECT SQRT(dx*dx+dy*dy+dz*dz) AS d FROM
  (SELECT p1.x-p2.x AS dx, p1.y-p2.y AS dy, p1.z-p2.z AS dz
     FROM gpsGlb p1 JOIN gpsGlb p2
          ON (p1.miejsce='napier' AND p2.miejsce='zzuli')
  ) t1) t2;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP VIEW gpsGlb;
DROP VIEW gpsTrig;
DROP VIEW gpsRad;
DROP TABLE gps;
