--100 sposobw na SQL, Sposb 17: Rozwizywanie anagramw
--Wersja mysql

----------------------
--   Przygotowania  --
----------------------

CREATE TEMPORARY TABLE tmp(s VARCHAR(50), INDEX(s));

LOAD DATA LOCAL INFILE '/usr/share/dict/words' INTO TABLE tmp(s);

UPDATE tmp SET s = REPLACE(REPLACE(LOWER(s),'''',''),'-','');



CREATE TABLE slownik
(s   VARCHAR(50)
,w   BIGINT
,INDEX(s)
,INDEX(w)
);

INSERT INTO slownik(s) SELECT DISTINCT s FROM tmp;


CREATE TABLE l_calkowite (c INTEGER PRIMARY KEY);

SELECT MAX(LENGTH(s)) FROM slownik;

INSERT INTO l_calkowite VALUES (1),(2),(3),(4);
INSERT INTO l_calkowite SELECT c+4 FROM l_calkowite;
INSERT INTO l_calkowite SELECT c+8 FROM l_calkowite;
INSERT INTO l_calkowite SELECT c+16 FROM l_calkowite;
INSERT INTO l_calkowite SELECT c+32 FROM l_calkowite;


----------------------
--       Sposb     --
----------------------

UPDATE slownik
  SET w = (SELECT SUM(ORD(SUBSTRING(s,c,1)))
           FROM l_calkowite
            WHERE c<=LENGTH(s));

SELECT * FROM slownik WHERE s='rat';

SELECT * FROM slownik WHERE w=327;

UPDATE slownik
  SET w = (SELECT SUM(ORD(SUBSTRING(s,c,1))*ORD(SUBSTRING(s,c,1)))
           FROM l_calkowite
            WHERE c<=LENGTH(s));


SELECT COUNT(DISTINCT w) FROM slownik;



UPDATE slownik
  SET w = (SELECT SUM(1<<(ORD(SUBSTRING(s,c,1))-97)*2)
           FROM l_calkowite
            WHERE c<=LENGTH(s));


SELECT s, LPAD(BIN(w),52,0) AS
          '-z y x w v u t s r q p o n m l k j i h g f e d c b a'
 FROM slownik WHERE s IN ('tango','zoo');

--------------------------
--    Usuwanie danych   --
--------------------------


DROP TABLE slownik;
DROP TABLE l_calkowite;
DROP TABLE tmp;
