package alexa;

import java.text.NumberFormat;
import java.util.Map;

/** Standardowa encja wg wzorcw bean; przydatne na powizane dane.
 *
 * @author Niall Kennedy
 * @version 1.0
 */
public final class TrafficBean {
    /** W duych liczbach dodaje przecinki
     */
    public final NumberFormat NUMBER_PURIFY = NumberFormat.getInstance();
    /** poddomeny. klucz procentowy wyraony jako <code>Integer</code> oraz
     *  warto waciwoci name */
    private Map sites;
    /** Procent miliona uytkownikw Internetu odwiedzajcych dan witryn */
    private int reach_per_million;
    /** Ranking wszystkich witryn tylko wedug ich zasigu */
    private int reach_rank;
    /** Liczba stron wykorzystywanych przez uytkownikw Alexa Toolbar.
     * Wielokrotne ogldanie tej samej strony przez danego uytkownika w jednym dniu liczy si tylko raz.*/
    private int views_per_user;
    /** ranking wszystkich witryn oparty wycznie na cznej liczbie ogldw stron (nie wedug uytkonikw) */
    private int views_rank;

    /** Inicjalizacja wszystkich zmiennych
     */
    public TrafficBean() {
        clearAll();
    }

    /** Czyszczenie wszystkich zmiennych klasy
     */
    public void clearAll() {
        sites = null;
        reach_per_million = 0;
        reach_rank = 0;
        views_per_user = 0;
        views_rank = 0;
    }

    public Map getSites() {
        return sites;
    }

    public void setSites(final Map val) {
        this.sites = val;
    }

    public int getReachPerMillion() {
        return reach_per_million;
    }

    public void setReachPerMillion(final String val) {
        reach_per_million = stringToInt(val);
    }

    public int getReachRank() {
        return reach_rank;
    }

    public void setReachRank(final String val) {
        reach_rank = stringToInt(val);
    }

    public int getViewsPerUser() {
        return views_per_user;
    }

    public void setViewsPerUser(final String val) {
        views_per_user = stringToInt(val);
    }

    public int getViewsRank() {
        return views_rank;
    }

    public void setViewsRank(final String val) {
        views_rank = stringToInt(val);
    }

    /** Usuwamy typowe elementy liczb, jak przecinki, wynik przeksztacamy 
     * na typ danych <code>int</code>
     * @param val String warto wymagajca konwersji
     * @return warto przekazanego <code>String</code> lub jeli go brak, zero
     * Uamki s nie zaokrglane, lecz odrzucane
     */
    private int stringToInt(final String val) {
        int retval = 0;
        try {
            retval = NUMBER_PURIFY.parse(val).intValue();
        }
        catch (Exception e) {}
        return retval;
    }
}
