<?php
require_once 'HTTP/Client.php';
require_once 'PHPUnit2/Framework/TestCase.php';

class RobotUnit extends PHPUnit2_Framework_TestCase
{
  var $client = null;

  private function check_html( $testname, $values )
  {
    $resp = $this->client->currentResponse();
    $body = $resp['body'];
  
    preg_match( "/\<\!\-\- KOSZYK \: (.*?) \-\-\>/", $body, $found );
  
    return ( $found[1] == join(",", $values ) );
  }

  function test1()
  {
    $this->client = new HTTP_Client();
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/add.php", array( 'prod_id' => 1 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );
    $this->assertTrue( $this->check_html( "Dodanie pierwszego towaru", array( 1 ) ) );
  }

  function test2()
  {
    $this->client = new HTTP_Client();
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/add.php", array( 'prod_id' => 1 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );
    $this->assertTrue( $this->check_html( "Dodanie pierwszego towaru", array( 1 ) ) );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/add.php", array( 'prod_id' => 2 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );
    $this->assertTrue( $this->check_html( "Dodanie drugiego towaru", array( 1, 2 ) ) );
  }

  function test3()
  {
    $this->client = new HTTP_Client();
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/add.php", array( 'prod_id' => 1 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );
    $this->assertTrue( $this->check_html( "Dodanie pierwszego towaru", array( 1 ) ) );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/add.php", array( 'prod_id' => 2 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );
    $this->assertTrue( $this->check_html( "Dodanie drugiego towaru", array( 1, 2 ) ) );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/add.php", array( 'prod_id' => 3 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/index.php" );
    $this->assertTrue( $this->check_html( "Dodanie trzeciego towaru", array( 1, 2, 3 ) ) );

    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/checkout.php" );
    $this->assertTrue( $this->check_html( "Do kasy", array( 1, 2, 3 ) ) );

    $this->client->post( "http://localhost/phphacks/rozdzial6/shopcart/delete.php", array( 'ids[]' => 2 ) );
    $this->client->get( "http://localhost/phphacks/rozdzial6/shopcart/checkout.php" );
    $this->assertTrue( $this->check_html( "Usunicie dwch towarw", array( 1, 3 ) ) );
  }
}
?>
