<?PHP
// ex5_map_points.php
// Tworzenie mapy z wykorzystaniem GeoTIFF
// i pliku tekstowego ze wsprzdnymi/etykietami.
// Do dziaania nie wymaga pliku .map systemu mapserver.
// Tyler Mitchell, sierpie 2005

// Zaadowanie rozszerzenia MapScript
if (!extension_loaded("MapScript"))
  dl('php_mapscript.'.PHP_SHLIB_SUFFIX);

// Utworzenie obiektu mapy. Jeli nie korzysta si z pliku .map 
// naley wprowadzi pusty cig znakw.
$oMap = ms_newMapObj("");

// Ustawienie rozmiaru wynikowego pliku graficznego z map.
$oMap->setSize(600,300);

// Ustawienie obszaru geograficznego mapy.
$oMap->setExtent(-180,-90,180,90);

// Utworzenie symbolu wykorzystywanego jako wzr pdzla 
// do rysowania elementw na mapie (linii, punktw, etc.).
$nSymbolId = ms_newSymbolObj($oMap, "circle");
$oSymbol = $oMap->getsymbolobjectbyid($nSymbolId);
$oSymbol->set("type", MS_SYMBOL_ELLIPSE);
$oSymbol->set("filled", MS_TRUE);
$aPoints[0] = 1;
$aPoints[1] = 1;
$oSymbol->setpoints($aPoints);

// Utworzenie warstwy danych i powizanie jej z map.
// Warstwa rastrowa wywietlajca zachmurzenie.
$oLayerClouds = ms_newLayerObj($oMap);
$oLayerClouds->set( "name", "clouds");
$oLayerClouds->set( "type", MS_LAYER_RASTER);
$oLayerClouds->set( "status", MS_DEFAULT);
$oLayerClouds->set( "data","data/global_clouds.tif");

// Utworzenie innej warstwy zawierajcej lokalizacje punktw.
$oLayerPoints = ms_newLayerObj($oMap);
$oLayerPoints->set( "name", "custom_points");
$oLayerPoints->set( "type", MS_LAYER_POINT);
$oLayerPoints->set( "status", MS_DEFAULT);

// Otwarcie pliku ze wsprzdnymi i etykietami tekstowymi (x,y,etykieta).
$fPointList = file("data/points.txt");

// Dla kadego wiersza w pliku tekstowym.
foreach ($fPointList as $sPointItem)
{
   $aPointArray = explode(",",$sPointItem);
   // :UWAGA: Zwrmy uwag, e cho stosujemy punkty,
   // musimy korzysta z obiektu linii (newLineObj).
   // Dla uproszczenia nadaem obiektowi nazw CoordList. 
   $oCoordList = ms_newLineObj();
   $oPointShape = ms_newShapeObj(MS_SHAPE_POINT);
   $oCoordList->addXY($aPointArray[0],$aPointArray[1]);
   $oPointShape->add($oCoordList);
   $oPointShape->set( "text", chop($aPointArray[2]));
   $oLayerPoints->addFeature($oPointShape);
}

// Utworzenie obiektu klasy w celu okrelenia stylu rysowania.
$oMapClass = ms_newClassObj($oLayerPoints);

// Utworzenie obiektu stylu definiujcego sposb rysowania elementw.
$oPointStyle = ms_newStyleObj($oMapClass);
$oPointStyle->color->setRGB(250,0,0);
$oPointStyle->outlinecolor->setRGB(255,255,255);
$oPointStyle->set( "symbolname", "circle");
$oPointStyle->set( "size", "10");

// Utworzenie opcji etykiet w celu wykrelenia etykiet tekstowych.
$oMapClass->label->set( "position", MS_AUTO);
$oMapClass->label->color->setRGB(250,0,0);
$oMapClass->label->outlinecolor->setRGB(255,255,255);


// Renderowanie mapy do obiektu graficznego.
$oMapImage = $oMap->draw();

// Zapis mapy do pliku graficznego.
$oMapImage->saveImage("worldmap.png");

?>
